/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.PairBIDE;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.PseudoSequenceBIDE;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPatterns;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoBIDEPlus {
    long startTime;
    long endTime;
    int patternCount = 0;
    private int minsuppAbsolute;
    BufferedWriter writer = null;
    private List<PseudoSequenceBIDE> initialDatabase = null;
    private SequentialPatterns patterns = null;
    Map<Integer, Map<Integer, Integer>> coocMapBefore = null;

    public SequentialPatterns runAlgorithm(SequenceDatabase database, String outputPath, int minsup) throws IOException {
        this.minsuppAbsolute = minsup;
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.bide(database, outputPath);
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    private void bide(SequenceDatabase database, String outputFilePath) throws IOException {
        if (outputFilePath == null) {
            this.writer = null;
            this.patterns = new SequentialPatterns("FREQUENT SEQUENTIAL PATTERNS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        Map<Integer, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(database);
        this.initialDatabase = new ArrayList<PseudoSequenceBIDE>();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppAbsolute);
            if (optimizedSequence.size() == 0) continue;
            this.initialDatabase.add(new PseudoSequenceBIDE(optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppAbsolute) continue;
            Integer item = (Integer)entry.getKey();
            List<PseudoSequenceBIDE> projectedContext = this.buildProjectedContextSingleItem(item, this.initialDatabase, false, (Set)entry.getValue());
            SequentialPattern prefix = new SequentialPattern();
            prefix.addItemset(new Itemset(item));
            prefix.setSequenceIDs((Set)entry.getValue());
            if (projectedContext.size() >= this.minsuppAbsolute) {
                int successorSupport = 0;
                if (!this.checkBackScanPruning(prefix, (Set)entry.getValue())) {
                    successorSupport = this.recursion(prefix, projectedContext);
                }
                if (successorSupport == ((Set)entry.getValue()).size() || this.checkBackwardExtension(prefix, (Set)entry.getValue())) continue;
                this.savePattern(prefix);
                continue;
            }
            if (this.checkBackwardExtension(prefix, (Set)entry.getValue())) continue;
            this.savePattern(prefix);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private boolean checkBackwardExtension(SequentialPattern prefix, Set<Integer> sidset) {
        int totalOccurenceCount = prefix.getItemOccurencesTotalCount();
        int i = 0;
        while (i < totalOccurenceCount) {
            HashSet<Integer> alreadyVisitedSID = new HashSet<Integer>();
            Integer itemI = prefix.getIthItem(i);
            Integer itemIm1 = null;
            if (i > 0) {
                itemIm1 = prefix.getIthItem(i - 1);
            }
            HashMap<PairBIDE, PairBIDE> mapPaires = new HashMap<PairBIDE, PairBIDE>();
            int highestSupportUntilNow = -1;
            for (int sequenceID : sidset) {
                int remainingSeqID = sidset.size() - alreadyVisitedSID.size();
                if (highestSupportUntilNow != -1 && highestSupportUntilNow + remainingSeqID < sidset.size()) break;
                alreadyVisitedSID.add(sequenceID);
                PseudoSequenceBIDE sequence = this.initialDatabase.get(sequenceID);
                PseudoSequenceBIDE period = sequence.getIthMaximumPeriodOfAPrefix(prefix.getItemsets(), i);
                if (period == null) continue;
                boolean hasBackwardExtension = this.findAllFrequentPairsForBackwardExtensionCheck(alreadyVisitedSID.size(), prefix, period, i, mapPaires, itemI, itemIm1);
                if (hasBackwardExtension) {
                    return true;
                }
                if (sidset.size() - alreadyVisitedSID.size() >= this.minsuppAbsolute) continue;
                for (PairBIDE pair : mapPaires.values()) {
                    int supportOfPair = pair.getSequenceIDs().size();
                    if (supportOfPair <= highestSupportUntilNow) continue;
                    highestSupportUntilNow = supportOfPair;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean checkBackScanPruning(SequentialPattern prefix, Set<Integer> sidset) {
        int i = 0;
        while (i < prefix.getItemOccurencesTotalCount()) {
            HashSet<Integer> alreadyVisitedSID = new HashSet<Integer>();
            HashMap<PairBIDE, PairBIDE> mapPaires = new HashMap<PairBIDE, PairBIDE>();
            Integer itemI = prefix.getIthItem(i);
            Integer itemIm1 = null;
            if (i > 0) {
                itemIm1 = prefix.getIthItem(i - 1);
            }
            boolean seqCount = false;
            for (int sequenceID : sidset) {
                boolean hasExtension;
                alreadyVisitedSID.add(sequenceID);
                PseudoSequenceBIDE sequence = this.initialDatabase.get(sequenceID);
                PseudoSequenceBIDE period = sequence.getIthSemiMaximumPeriodOfAPrefix(prefix.getItemsets(), i);
                if (period == null || !(hasExtension = this.findAllFrequentPairsForBackwardExtensionCheck(alreadyVisitedSID.size(), prefix, period, i, mapPaires, itemI, itemIm1))) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean findAllFrequentPairsForBackwardExtensionCheck(int seqProcessedCount, SequentialPattern prefix, PseudoSequenceBIDE maximumPeriod, int iPeriod, Map<PairBIDE, PairBIDE> mapPaires, Integer itemI, Integer itemIm1) {
        int supportToMatch = prefix.getSequenceIDs().size();
        int maxPeriodSize = maximumPeriod.size();
        int i = 0;
        while (i < maxPeriodSize) {
            Integer item;
            int sizeOfItemsetAtI = maximumPeriod.getSizeOfItemsetAt(i);
            boolean sawI = false;
            boolean sawIm1 = false;
            int j = 0;
            while (j < sizeOfItemsetAtI) {
                item = maximumPeriod.getItemAtInItemsetAt(j, i);
                if (item.equals(itemI)) {
                    sawI = true;
                } else if (item > itemI) break;
                ++j;
            }
            j = 0;
            while (j < sizeOfItemsetAtI) {
                PairBIDE paire2;
                item = maximumPeriod.getItemAtInItemsetAt(j, i);
                if (itemIm1 != null && item == itemIm1) {
                    sawIm1 = true;
                }
                boolean isPrefix = maximumPeriod.isCutAtRight(i);
                boolean isPostfix = maximumPeriod.isPostfix(i);
                PairBIDE paire = new PairBIDE(isPrefix, isPostfix, item);
                if (seqProcessedCount >= this.minsuppAbsolute) {
                    if (this.addPair(mapPaires, maximumPeriod.getId(), paire, supportToMatch)) {
                        return true;
                    }
                    if (sawIm1) {
                        paire2 = new PairBIDE(isPrefix, !isPostfix, item);
                        if (this.addPair(mapPaires, maximumPeriod.getId(), paire2, supportToMatch)) {
                            return true;
                        }
                    }
                    if (sawI) {
                        paire2 = new PairBIDE(!isPrefix, isPostfix, item);
                        if (this.addPair(mapPaires, maximumPeriod.getId(), paire2, supportToMatch)) {
                            return true;
                        }
                    }
                } else {
                    this.addPairWithoutCheck(mapPaires, maximumPeriod.getId(), paire);
                    if (sawIm1) {
                        paire2 = new PairBIDE(isPrefix, !isPostfix, item);
                        this.addPairWithoutCheck(mapPaires, maximumPeriod.getId(), paire2);
                    }
                    if (sawI) {
                        paire2 = new PairBIDE(!isPrefix, isPostfix, item);
                        this.addPairWithoutCheck(mapPaires, maximumPeriod.getId(), paire2);
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void addPairWithoutCheck(Map<PairBIDE, PairBIDE> mapPaires, Integer seqID, PairBIDE pair) {
        PairBIDE oldPaire = mapPaires.get(pair);
        if (oldPaire == null) {
            mapPaires.put(pair, pair);
            pair.getSequenceIDs().add(seqID);
        } else {
            oldPaire.getSequenceIDs().add(seqID);
        }
    }

    private boolean addPair(Map<PairBIDE, PairBIDE> mapPaires, Integer seqID, PairBIDE pair, int supportToMatch) {
        PairBIDE oldPaire = mapPaires.get(pair);
        if (oldPaire == null) {
            mapPaires.put(pair, pair);
        } else {
            pair = oldPaire;
        }
        pair.getSequenceIDs().add(seqID);
        return pair.getSequenceIDs().size() == supportToMatch;
    }

    private Map<Integer, Set<Integer>> findSequencesContainingItems(SequenceDatabase database) {
        HashMap<Integer, Set<Integer>> mapSequenceID = new HashMap<Integer, Set<Integer>>();
        for (Sequence sequence : database.getSequences()) {
            for (List<Integer> itemset : sequence.getItemsets()) {
                for (Integer item : itemset) {
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private List<PseudoSequenceBIDE> buildProjectedContextSingleItem(Integer item, List<PseudoSequenceBIDE> database, boolean inSuffix, Set<Integer> sidset) {
        ArrayList<PseudoSequenceBIDE> sequenceDatabase = new ArrayList<PseudoSequenceBIDE>();
        for (int sid : sidset) {
            PseudoSequenceBIDE sequence = database.get(sid);
            int i = 0;
            while (i < sequence.size()) {
                int sizeOfItemsetAti = sequence.getSizeOfItemsetAt(i);
                int index = sequence.indexOf(sizeOfItemsetAti, i, item);
                if (index != -1 && sequence.isPostfix(i) == inSuffix) {
                    if (index != sizeOfItemsetAti - 1) {
                        sequenceDatabase.add(new PseudoSequenceBIDE(sequence, i, index + 1));
                    } else if (i != sequence.size() - 1) {
                        sequenceDatabase.add(new PseudoSequenceBIDE(sequence, i + 1, 0));
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private List<PseudoSequenceBIDE> buildProjectedDatabase(Integer item, List<PseudoSequenceBIDE> database, boolean inSuffix, Set<Integer> sidset) {
        ArrayList<PseudoSequenceBIDE> sequenceDatabase = new ArrayList<PseudoSequenceBIDE>();
        for (PseudoSequenceBIDE sequence : database) {
            if (!sidset.contains(sequence.getId())) continue;
            int i = 0;
            while (i < sequence.size()) {
                int sizeOfItemsetAti = sequence.getSizeOfItemsetAt(i);
                int index = sequence.indexOf(sizeOfItemsetAti, i, item);
                if (index != -1 && sequence.isPostfix(i) == inSuffix) {
                    if (index != sizeOfItemsetAti - 1) {
                        sequenceDatabase.add(new PseudoSequenceBIDE(sequence, i, index + 1));
                    } else if (i != sequence.size() - 1) {
                        sequenceDatabase.add(new PseudoSequenceBIDE(sequence, i + 1, 0));
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private int recursion(SequentialPattern prefix, List<PseudoSequenceBIDE> contexte) throws IOException {
        Set<PairBIDE> pairs = this.findAllFrequentPairs(prefix, contexte);
        int maxSupport = 0;
        for (PairBIDE pair : pairs) {
            if (pair.getCount() < this.minsuppAbsolute) continue;
            SequentialPattern newPrefix = pair.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, pair.getItem()) : this.appendItemToSequence(prefix, pair.getItem());
            List<PseudoSequenceBIDE> projectedContext = this.buildProjectedDatabase(pair.getItem(), contexte, pair.isPostfix(), pair.getSequenceIDs());
            newPrefix.setSequenceIDs(pair.getSequenceIDs());
            if (projectedContext.size() >= this.minsuppAbsolute) {
                int maxSupportOfSuccessors = 0;
                if (!this.checkBackScanPruning(newPrefix, pair.getSequenceIDs())) {
                    maxSupportOfSuccessors = this.recursion(newPrefix, projectedContext);
                }
                if (newPrefix.getSequenceIDs().size() != maxSupportOfSuccessors && !this.checkBackwardExtension(newPrefix, pair.getSequenceIDs())) {
                    this.savePattern(newPrefix);
                }
            } else if (!this.checkBackwardExtension(newPrefix, pair.getSequenceIDs())) {
                this.savePattern(newPrefix);
            }
            if (newPrefix.getAbsoluteSupport() <= maxSupport) continue;
            maxSupport = newPrefix.getAbsoluteSupport();
        }
        return maxSupport;
    }

    protected Set<PairBIDE> findAllFrequentPairs(SequentialPattern prefix, List<PseudoSequenceBIDE> sequences) {
        HashMap<PairBIDE, PairBIDE> mapPairs = new HashMap<PairBIDE, PairBIDE>();
        for (PseudoSequenceBIDE sequence : sequences) {
            int i = 0;
            while (i < sequence.size()) {
                int j = 0;
                while (j < sequence.getSizeOfItemsetAt(i)) {
                    Integer item = sequence.getItemAtInItemsetAt(j, i);
                    PairBIDE pair = new PairBIDE(sequence.isCutAtRight(i), sequence.isPostfix(i), item);
                    this.addPairWithoutCheck(mapPairs, sequence.getId(), pair);
                    ++j;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapPairs.keySet();
    }

    private SequentialPattern appendItemToSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item));
        return newPrefix;
    }

    private SequentialPattern appendItemToPrefixOfSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    private void savePattern(SequentialPattern prefix) throws IOException {
        ++this.patternCount;
        if (this.writer != null) {
            StringBuffer r = new StringBuffer("");
            for (Itemset itemset : prefix.getItemsets()) {
                for (Integer item : itemset.getItems()) {
                    String string = item.toString();
                    r.append(string);
                    r.append(' ');
                }
                r.append("-1 ");
            }
            r.append(" #SUP: ");
            r.append(prefix.getSequenceIDs().size());
            this.writer.write(r.toString());
            this.writer.newLine();
        } else {
            this.patterns.addSequence(prefix, prefix.size());
        }
    }

    public void printStatistics(int size) {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  Algorithm BIDE2 - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Closed sequential pattern count : ");
        r.append(this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb):");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }
}

