/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.rulegen;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.AlgoPrefixSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPatterns;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class AlgoRuleGen {
    private long startTime;
    private long endTime;
    private int patternCount;
    BufferedWriter writer = null;

    public void runAlgorithm(int minsup, double minconf, String input, String output) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(output));
        this.startTime = System.currentTimeMillis();
        SequenceDatabase sequenceDatabase = new SequenceDatabase();
        sequenceDatabase.loadFile(input);
        AlgoPrefixSpan algo = new AlgoPrefixSpan();
        SequentialPatterns patternsLists = algo.runAlgorithm(sequenceDatabase, null, minsup);
        int i = 0;
        while (i < patternsLists.getLevels().size()) {
            int j = 0;
            while (j < patternsLists.getLevel(i).size()) {
                SequentialPattern pattern1 = patternsLists.getLevel(i).get(j);
                int k = i + 1;
                while (k < patternsLists.getLevels().size()) {
                    int m = 0;
                    while (m < patternsLists.getLevel(k).size()) {
                        SequentialPattern pattern2 = patternsLists.getLevel(k).get(m);
                        this.tryToGenerateRule(pattern1, pattern2, minconf);
                        this.tryToGenerateRule(pattern2, pattern1, minconf);
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    private void tryToGenerateRule(SequentialPattern pattern1, SequentialPattern pattern2, double minconf) throws IOException {
        if (!this.strictlyContains(pattern2, pattern1)) {
            return;
        }
        double conf = (double)pattern2.getAbsoluteSupport() / (double)pattern1.getAbsoluteSupport();
        if (conf < minconf) {
            return;
        }
        ++this.patternCount;
        StringBuffer buffer = new StringBuffer();
        buffer.append(pattern1.itemsetsToString());
        buffer.append(" ==> ");
        buffer.append(pattern2.itemsetsToString());
        buffer.append(" #SUP: ");
        buffer.append(pattern2.getAbsoluteSupport());
        buffer.append(" #CONF: ");
        buffer.append(conf);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    boolean strictlyContains(SequentialPattern pattern1, SequentialPattern pattern2) {
        if (pattern1.size() <= pattern2.size()) {
            return false;
        }
        int i = 0;
        int j = 0;
        do {
            if (pattern1.getItemsets().get(j).containsAll(pattern2.get(i)) && ++i == pattern2.size()) {
                return true;
            }
            if (++j < pattern1.size()) continue;
            return false;
        } while (pattern1.size() - j >= pattern2.size() - i);
        return false;
    }

    public void printStats() {
        System.out.println("=============  SEQUENTIAL RULES - STATS =============");
        System.out.println("Sequential rules count: " + this.patternCount);
        System.out.println("Total time : " + (this.endTime - this.startTime) + " ms");
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("===================================================");
    }
}

