/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.uapriori;

import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.ItemUApriori;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class ItemsetUApriori {
    private List<ItemUApriori> items = new ArrayList<ItemUApriori>();
    private double expectedsupport = 0.0;

    public double getExpectedSupport() {
        return this.expectedsupport;
    }

    public String getSupportAsString() {
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(this.expectedsupport);
    }

    void increaseSupportBy(double supp) {
        this.expectedsupport += supp;
    }

    void addItem(ItemUApriori value) {
        this.items.add(value);
    }

    public List<ItemUApriori> getItems() {
        return this.items;
    }

    public ItemUApriori get(int index) {
        return this.items.get(index);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void printWithoutSupport() {
        StringBuffer r = new StringBuffer();
        for (ItemUApriori attribute : this.items) {
            r.append(attribute.getId());
            r.append(' ');
        }
        System.out.print(r);
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        for (ItemUApriori attribute : this.items) {
            r.append(attribute.toString());
            r.append(' ');
        }
        return r.toString();
    }

    public boolean contains(ItemUApriori item) {
        return this.items.contains(item);
    }

    boolean isLexicallySmallerthan(ItemsetUApriori itemset2) {
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).getId() > itemset2.items.get(i).getId()) {
                return false;
            }
            if (this.items.get(i).getId() < itemset2.items.get(i).getId()) {
                return true;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualTo(ItemsetUApriori itemset2) {
        if (this.items.size() != itemset2.items.size()) {
            return false;
        }
        for (ItemUApriori val : this.items) {
            if (itemset2.contains(val)) continue;
            return false;
        }
        return true;
    }

    void setExpectedSupport(double expectedsupport) {
        this.expectedsupport = expectedsupport;
    }

    ItemsetUApriori cloneItemSetMinusOneItem(ItemUApriori itemToExclude) {
        ItemsetUApriori itemset = new ItemsetUApriori();
        for (ItemUApriori item : this.items) {
            if (item.equals(itemToExclude)) continue;
            itemset.addItem(item);
        }
        return itemset;
    }

    public int size() {
        return this.items.size();
    }

    ItemUApriori allTheSameExceptLastItem(ItemsetUApriori itemset2) {
        if (itemset2.size() != this.items.size()) {
            return null;
        }
        int i = 0;
        while (i < this.items.size()) {
            if (i == this.items.size() - 1 ? this.items.get(i).getId() >= itemset2.get(i).getId() : this.items.get(i).getId() != itemset2.get(i).getId()) {
                return null;
            }
            ++i;
        }
        return itemset2.get(itemset2.size() - 1);
    }

    void setItems(List<ItemUApriori> items) {
        this.items = items;
    }
}

