/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm;

import ca.pfv.spmf.patterns.itemset_set_integers_with_tids.Itemset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ITNode {
    private Itemset itemset;
    private Set<Integer> tidset;
    private ITNode parent = null;
    private List<ITNode> childNodes = new ArrayList<ITNode>();

    public ITNode(Itemset itemset) {
        this.itemset = itemset;
    }

    public Itemset getItemset() {
        return this.itemset;
    }

    public void setItemset(Itemset itemset) {
        this.itemset = itemset;
    }

    public Set<Integer> getTidset() {
        return this.tidset;
    }

    public void setTidset(Set<Integer> tidset) {
        this.tidset = tidset;
    }

    public List<ITNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(List<ITNode> childNodes) {
        this.childNodes = childNodes;
    }

    public ITNode getParent() {
        return this.parent;
    }

    public void setParent(ITNode parent) {
        this.parent = parent;
    }

    void replaceInChildren(Itemset replacement) {
        for (ITNode node : this.getChildNodes()) {
            Itemset itemset = node.getItemset();
            for (Integer item : replacement.getItems()) {
                if (itemset.contains(item)) continue;
                itemset.addItem(item);
            }
            node.replaceInChildren(replacement);
        }
    }

    Set<Integer> peformOptimizedTidSetsIntersection(ITNode brother, int minsupRelative) {
        int brotherSize = brother.getTidset().size();
        int thisNodeSize = this.getTidset().size();
        HashSet<Integer> commonTids = new HashSet<Integer>();
        if (brotherSize < thisNodeSize) {
            for (Integer tid : brother.getTidset()) {
                if (this.getTidset().contains(tid)) {
                    commonTids.add(tid);
                }
                if (--brotherSize + commonTids.size() >= minsupRelative) continue;
                return null;
            }
        } else {
            for (Integer tid : this.getTidset()) {
                if (brother.getTidset().contains(tid)) {
                    commonTids.add(tid);
                }
                if (--thisNodeSize + commonTids.size() >= minsupRelative) continue;
                return null;
            }
        }
        return commonTids;
    }
}

