/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.aprioriTIDClose;

import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoAprioriTIDClose {
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    private int databaseSize = 0;
    protected int k;
    Map<Integer, Set<Integer>> mapItemTIDS = new HashMap<Integer, Set<Integer>>();
    int minSuppRelative;
    int maxItemsetSize = Integer.MAX_VALUE;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int itemsetCount = 0;

    public Itemsets runAlgorithm(TransactionDatabase database, double minsupp, String outputFile) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        if (outputFile == null) {
            this.writer = null;
            this.patterns = new Itemsets("FREQUENT CLOSED ITEMSETS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(outputFile));
        }
        this.minSuppRelative = (int)Math.ceil(minsupp * (double)database.size());
        if (this.minSuppRelative == 0) {
            this.minSuppRelative = 1;
        }
        this.mapItemTIDS = new HashMap<Integer, Set<Integer>>();
        int j = 0;
        while (j < database.getTransactions().size()) {
            List<Integer> transaction = database.getTransactions().get(j);
            int i = 0;
            while (i < transaction.size()) {
                Set<Integer> ids = this.mapItemTIDS.get(transaction.get(i));
                if (ids == null) {
                    ids = new HashSet<Integer>();
                    this.mapItemTIDS.put(transaction.get(i), ids);
                }
                ids.add(j);
                ++i;
            }
            ++j;
        }
        this.databaseSize = database.getTransactions().size();
        this.k = 1;
        List<Itemset> level = new ArrayList<Itemset>();
        Iterator<Map.Entry<Integer, Set<Integer>>> iterator = this.mapItemTIDS.entrySet().iterator();
        while (iterator.hasNext()) {
            MemoryLogger.getInstance().checkMemory();
            Map.Entry<Integer, Set<Integer>> entry = iterator.next();
            if (entry.getValue().size() >= this.minSuppRelative) {
                Integer item = entry.getKey();
                Itemset itemset = new Itemset(item);
                itemset.setTIDs(this.mapItemTIDS.get(item));
                level.add(itemset);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(level, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return o1.get(0) - o2.get(0);
            }
        });
        this.k = 2;
        while (!level.isEmpty() && this.k <= this.maxItemsetSize) {
            List<Itemset> levelK = this.generateCandidateSizeK(level);
            this.checkIfItemsetsK_1AreClosed(level, levelK);
            level = levelK;
            ++this.k;
        }
        this.endTimestamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    private Map<Integer, Set<Integer>> removeItemsThatAreNotFrequent(TransactionDatabase database) {
        List<Integer> transaction;
        this.mapItemTIDS = new HashMap<Integer, Set<Integer>>();
        int j = 0;
        while (j < database.getTransactions().size()) {
            transaction = database.getTransactions().get(j);
            int i = 0;
            while (i < transaction.size()) {
                Set<Integer> ids = this.mapItemTIDS.get(transaction.get(i));
                if (ids == null) {
                    ids = new HashSet<Integer>();
                    this.mapItemTIDS.put(transaction.get(i), ids);
                }
                ids.add(j);
                ++i;
            }
            ++j;
        }
        System.out.println("NUMBER OF DIFFERENT ITEMS : " + this.mapItemTIDS.size());
        j = 0;
        while (j < database.getTransactions().size()) {
            transaction = database.getTransactions().get(j);
            Iterator<Integer> iter = transaction.iterator();
            while (iter.hasNext()) {
                Integer nextItem = iter.next();
                Set<Integer> ids = this.mapItemTIDS.get(nextItem);
                if (ids.size() >= this.minSuppRelative) continue;
                iter.remove();
            }
            ++j;
        }
        return this.mapItemTIDS;
    }

    private void checkIfItemsetsK_1AreClosed(Collection<Itemset> levelKm1, List<Itemset> levelK) throws IOException {
        for (Itemset itemset : levelKm1) {
            boolean isClosed = true;
            for (Itemset itemsetK : levelK) {
                if (itemsetK.getAbsoluteSupport() != itemset.getAbsoluteSupport() || !itemsetK.containsAll(itemset)) continue;
                isClosed = false;
                break;
            }
            if (!isClosed) continue;
            this.saveItemset(itemset);
        }
    }

    void saveItemset(Itemset itemset) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            this.writer.write(String.valueOf(itemset.toString()) + " #SUP: " + itemset.getTransactionsIds().size());
            this.writer.newLine();
        } else {
            this.patterns.addItemset(itemset, itemset.size());
        }
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        int i = 0;
        while (i < levelK_1.size()) {
            Itemset itemset1 = levelK_1.get(i);
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block9: {
                    Itemset itemset2 = levelK_1.get(j);
                    int k = 0;
                    while (k < itemset1.size()) {
                        if (k == itemset1.size() - 1) {
                            if (itemset1.getItems()[k] >= itemset2.get(k)) {
                                break block1;
                            }
                        } else {
                            if (itemset1.getItems()[k] >= itemset2.get(k)) {
                                if (itemset1.getItems()[k] > itemset2.get(k)) break block1;
                            }
                            break block9;
                        }
                        ++k;
                    }
                    HashSet<Integer> list = new HashSet<Integer>();
                    for (Integer val1 : itemset1.getTransactionsIds()) {
                        if (!itemset2.getTransactionsIds().contains(val1)) continue;
                        list.add(val1);
                    }
                    if (list.size() >= this.minSuppRelative) {
                        int[] newItemset = new int[itemset1.size() + 1];
                        System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                        newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                        Itemset candidate = new Itemset(newItemset);
                        candidate.setTIDs(list);
                        candidates.add(candidate);
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    public Itemsets getFrequentClosed() {
        return this.patterns;
    }

    public void setMaxItemsetSize(int maxItemsetSize) {
        this.maxItemsetSize = maxItemsetSize;
    }

    public void printStats() {
        System.out.println("=============  APRIORI-CLOSE - STATS =============");
        long temps = this.endTimestamp - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.databaseSize);
        System.out.println(" The algorithm stopped at size " + (this.k - 1) + ", because there is no candidate");
        System.out.println(" Frequent closed itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }
}

