/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.decisiontree.id3;

import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.ClassNode;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.DecisionNode;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.DecisionTree;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.Node;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoID3 {
    private String[] allAttributes;
    private int indexTargetAttribute = -1;
    private Set<String> targetAttributeValues = new HashSet<String>();
    private long startTime;
    private long endTime;

    public DecisionTree runAlgorithm(String input, String targetAttribute, String separator) throws IOException {
        this.startTime = System.currentTimeMillis();
        DecisionTree tree = new DecisionTree();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        String line = reader.readLine();
        this.allAttributes = line.split(separator);
        int[] remainingAttributes = new int[this.allAttributes.length - 1];
        int pos = 0;
        int i = 0;
        while (i < this.allAttributes.length) {
            if (this.allAttributes[i].equals(targetAttribute)) {
                this.indexTargetAttribute = i;
            } else {
                remainingAttributes[pos++] = i;
            }
            ++i;
        }
        ArrayList<String[]> instances = new ArrayList<String[]>();
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplit = line.split(separator);
            instances.add(lineSplit);
            this.targetAttributeValues.add(lineSplit[this.indexTargetAttribute]);
        }
        reader.close();
        tree.root = this.id3(remainingAttributes, instances);
        tree.allAttributes = this.allAttributes;
        this.endTime = System.currentTimeMillis();
        return tree;
    }

    private Node id3(int[] remainingAttributes, List<String[]> instances) {
        if (remainingAttributes.length == 0) {
            Map<String, Integer> targetValuesFrequency = this.calculateFrequencyOfAttributeValues(instances, this.indexTargetAttribute);
            int highestCount = 0;
            String highestName = "";
            for (Map.Entry<String, Integer> entry : targetValuesFrequency.entrySet()) {
                if (entry.getValue() <= highestCount) continue;
                highestCount = entry.getValue();
                highestName = entry.getKey();
            }
            ClassNode classNode = new ClassNode();
            classNode.className = highestName;
            return classNode;
        }
        Map<String, Integer> targetValuesFrequency = this.calculateFrequencyOfAttributeValues(instances, this.indexTargetAttribute);
        if (targetValuesFrequency.entrySet().size() == 1) {
            ClassNode classNode = new ClassNode();
            classNode.className = (String)targetValuesFrequency.keySet().toArray()[0];
            return classNode;
        }
        double globalEntropy = 0.0;
        for (String value : this.targetAttributeValues) {
            Integer frequencyInt = targetValuesFrequency.get(value);
            if (frequencyInt == null) continue;
            double frequencyDouble = (double)frequencyInt.intValue() / (double)instances.size();
            globalEntropy -= frequencyDouble * Math.log(frequencyDouble) / Math.log(2.0);
        }
        int attributeWithHighestGain = 0;
        double highestGain = -99999.0;
        int[] nArray = remainingAttributes;
        int n = remainingAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            int attribute = nArray[n2];
            double gain = this.calculateGain(attribute, instances, globalEntropy);
            if (gain >= highestGain) {
                highestGain = gain;
                attributeWithHighestGain = attribute;
            }
            ++n2;
        }
        if (highestGain == 0.0) {
            ClassNode classNode = new ClassNode();
            int topFrequency = 0;
            String className = null;
            for (Map.Entry<String, Integer> entry : targetValuesFrequency.entrySet()) {
                if (entry.getValue() <= topFrequency) continue;
                topFrequency = entry.getValue();
                className = entry.getKey();
            }
            classNode.className = className;
            return classNode;
        }
        DecisionNode decisionNode = new DecisionNode();
        decisionNode.attribute = attributeWithHighestGain;
        int[] newRemainingAttribute = new int[remainingAttributes.length - 1];
        int pos = 0;
        int i = 0;
        while (i < remainingAttributes.length) {
            if (remainingAttributes[i] != attributeWithHighestGain) {
                newRemainingAttribute[pos++] = remainingAttributes[i];
            }
            ++i;
        }
        HashMap<String, ArrayList<String[]>> partitions = new HashMap<String, ArrayList<String[]>>();
        for (String[] instance : instances) {
            String value = instance[attributeWithHighestGain];
            ArrayList<String[]> listInstances = (ArrayList<String[]>)partitions.get(value);
            if (listInstances == null) {
                listInstances = new ArrayList<String[]>();
                partitions.put(value, listInstances);
            }
            listInstances.add(instance);
        }
        decisionNode.nodes = new Node[partitions.size()];
        decisionNode.attributeValues = new String[partitions.size()];
        int index = 0;
        for (Map.Entry partition : partitions.entrySet()) {
            decisionNode.attributeValues[index] = (String)partition.getKey();
            decisionNode.nodes[index] = this.id3(newRemainingAttribute, (List)partition.getValue());
            ++index;
        }
        return decisionNode;
    }

    private double calculateGain(int attributePos, List<String[]> instances, double globalEntropy) {
        Map<String, Integer> valuesFrequency = this.calculateFrequencyOfAttributeValues(instances, attributePos);
        double sum = 0.0;
        for (Map.Entry<String, Integer> entry : valuesFrequency.entrySet()) {
            sum += (double)entry.getValue().intValue() / (double)instances.size() * this.calculateEntropyIfValue(instances, attributePos, entry.getKey());
        }
        return globalEntropy - sum;
    }

    private double calculateEntropyIfValue(List<String[]> instances, int attributeIF, String valueIF) {
        int instancesCount = 0;
        HashMap<String, Integer> valuesFrequency = new HashMap<String, Integer>();
        for (String[] instance : instances) {
            if (!instance[attributeIF].equals(valueIF)) continue;
            String targetValue = instance[this.indexTargetAttribute];
            if (valuesFrequency.get(targetValue) == null) {
                valuesFrequency.put(targetValue, 1);
            } else {
                valuesFrequency.put(targetValue, (Integer)valuesFrequency.get(targetValue) + 1);
            }
            ++instancesCount;
        }
        double entropy = 0.0;
        for (String value : this.targetAttributeValues) {
            Integer count = (Integer)valuesFrequency.get(value);
            if (count == null) continue;
            double frequency = (double)count.intValue() / (double)instancesCount;
            entropy -= frequency * Math.log(frequency) / Math.log(2.0);
        }
        return entropy;
    }

    private Map<String, Integer> calculateFrequencyOfAttributeValues(List<String[]> instances, int indexAttribute) {
        HashMap<String, Integer> targetValuesFrequency = new HashMap<String, Integer>();
        for (String[] instance : instances) {
            String targetValue = instance[indexAttribute];
            if (targetValuesFrequency.get(targetValue) == null) {
                targetValuesFrequency.put(targetValue, 1);
                continue;
            }
            targetValuesFrequency.put(targetValue, (Integer)targetValuesFrequency.get(targetValue) + 1);
        }
        return targetValuesFrequency;
    }

    public void printStatistics() {
        System.out.println("Time to construct decision tree = " + (this.endTime - this.startTime) + " ms");
        System.out.println("Target attribute = " + this.allAttributes[this.indexTargetAttribute]);
        System.out.print("Other attributes = ");
        String[] stringArray = this.allAttributes;
        int n = this.allAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!attribute.equals(this.allAttributes[this.indexTargetAttribute])) {
                System.out.print(String.valueOf(attribute) + " ");
            }
            ++n2;
        }
        System.out.println();
    }
}

