/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.closedrules;

import ca.pfv.spmf.algorithms.associationrules.closedrules.ClosedRule;
import java.util.ArrayList;
import java.util.List;

public class ClosedRules {
    public final List<ClosedRule> rules = new ArrayList<ClosedRule>();
    private final String name;

    public ClosedRules(String name) {
        this.name = name;
    }

    public void printRules(int databaseSize) {
        System.out.println(" ------- " + this.name + " -------");
        int i = 0;
        for (ClosedRule rule : this.rules) {
            System.out.print("  rule " + i + ":  " + rule.toString());
            System.out.print("support :  " + rule.getRelativeSupport(databaseSize) + " (" + rule.getAbsoluteSupport() + "/" + databaseSize + ") ");
            System.out.print("confidence :  " + rule.getConfidence());
            System.out.println("");
            ++i;
        }
        System.out.println(" --------------------------------");
    }

    public String toString(int databaseSize) {
        StringBuffer buffer = new StringBuffer(" ------- ");
        buffer.append(this.name);
        buffer.append(" -------\n");
        int i = 0;
        for (ClosedRule rule : this.rules) {
            buffer.append("   rule ");
            buffer.append(i);
            buffer.append(":  ");
            buffer.append(rule.toString());
            buffer.append("support :  ");
            buffer.append(rule.getRelativeSupport(databaseSize));
            buffer.append(" (");
            buffer.append(rule.getAbsoluteSupport());
            buffer.append("/");
            buffer.append(databaseSize);
            buffer.append(") ");
            buffer.append("confidence :  ");
            buffer.append(rule.getConfidence());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    public void addRule(ClosedRule rule) {
        this.rules.add(rule);
    }

    public int getRulesCount() {
        return this.rules.size();
    }

    public List<ClosedRule> getRules() {
        return this.rules;
    }
}

