/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.closedrules;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;

public class ClosedRule {
    private Itemset itemset1;
    private Itemset itemset2;
    private int transactionCount;
    private double confidence;

    public ClosedRule(Itemset itemset1, Itemset itemset2, int transactionCount, double confidence) {
        this.itemset1 = itemset1;
        this.itemset2 = itemset2;
        this.transactionCount = transactionCount;
        this.confidence = confidence;
    }

    public double getRelativeSupport(int objectCount) {
        return (double)this.transactionCount / (double)objectCount;
    }

    public int getAbsoluteSupport() {
        return this.transactionCount;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return String.valueOf(this.itemset1.toString()) + " ==> " + this.itemset2.toString();
    }

    public Itemset getItemset1() {
        return this.itemset1;
    }

    public Itemset getItemset2() {
        return this.itemset2;
    }
}

