/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.closedrules;

import ca.pfv.spmf.algorithms.associationrules.closedrules.ClosedRule;
import ca.pfv.spmf.algorithms.associationrules.closedrules.ClosedRules;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AlgoClosedRules {
    private Itemsets closedItemsets;
    private double minconf;
    private ClosedRules rules;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    private int ruleCount;
    BufferedWriter writer = null;

    public ClosedRules runAlgorithm(Itemsets closedItemsets, double minconf, String outputFile) throws IOException {
        this.closedItemsets = closedItemsets;
        if (outputFile == null) {
            this.writer = null;
            this.rules = new ClosedRules("Closed association rules");
        } else {
            this.rules = null;
            this.writer = new BufferedWriter(new FileWriter(outputFile));
        }
        this.startTimestamp = System.currentTimeMillis();
        this.minconf = minconf;
        int k = 2;
        while (k < closedItemsets.getLevels().size()) {
            for (Itemset lk : closedItemsets.getLevels().get(k)) {
                HashSet<Itemset> H1 = new HashSet<Itemset>();
                int[] nArray = lk.getItems();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer item = nArray[n2];
                    Itemset itemset = new Itemset(item);
                    H1.add(itemset);
                    ++n2;
                }
                HashSet<Itemset> H1_for_recursion = new HashSet<Itemset>();
                for (Itemset hm_P_1 : H1) {
                    Itemset itemset_Lk_minus_hm_P_1 = lk.cloneItemSetMinusAnItemset(hm_P_1);
                    int supLkMinus_hm_P_1 = this.calculateSupport(itemset_Lk_minus_hm_P_1);
                    int supLk = this.calculateSupport(lk);
                    double conf = (double)supLk / (double)supLkMinus_hm_P_1;
                    if (!(conf >= minconf)) continue;
                    ClosedRule rule = new ClosedRule(itemset_Lk_minus_hm_P_1, hm_P_1, lk.getAbsoluteSupport(), conf);
                    this.save(rule);
                    H1_for_recursion.add(hm_P_1);
                }
                this.apGenrules(k, 1, lk, H1_for_recursion);
            }
            ++k;
        }
        this.endTimeStamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.rules;
    }

    private void apGenrules(int k, int m, Itemset lk, Set<Itemset> Hm) throws IOException {
        if (k > m + 1) {
            Set<Itemset> Hm_plus_1 = this.generateCandidateSizeK(Hm);
            HashSet<Itemset> Hm_plus_1_for_recursion = new HashSet<Itemset>();
            for (Itemset hm_P_1 : Hm_plus_1) {
                Itemset itemset_Lk_minus_hm_P_1 = lk.cloneItemSetMinusAnItemset(hm_P_1);
                int supLkMinus_hm_P_1 = this.calculateSupport(itemset_Lk_minus_hm_P_1);
                int supLk = this.calculateSupport(lk);
                double conf = (double)supLk / (double)supLkMinus_hm_P_1;
                if (!(conf >= this.minconf)) continue;
                ClosedRule rule = new ClosedRule(itemset_Lk_minus_hm_P_1, hm_P_1, lk.getAbsoluteSupport(), conf);
                this.save(rule);
                Hm_plus_1_for_recursion.add(hm_P_1);
            }
            this.apGenrules(k, m + 1, lk, Hm_plus_1_for_recursion);
        }
    }

    private int calculateSupport(Itemset itemsetToTest) {
        for (List<Itemset> list : this.closedItemsets.getLevels()) {
            if (list.size() == 0 || list.get(0).size() < itemsetToTest.size()) continue;
            for (Itemset itemset : list) {
                if (!itemset.containsAll(itemsetToTest)) continue;
                return itemset.getAbsoluteSupport();
            }
        }
        return 0;
    }

    protected Set<Itemset> generateCandidateSizeK(Set<Itemset> levelK_1) {
        HashSet<Itemset> candidates = new HashSet<Itemset>();
        for (Itemset itemset1 : levelK_1) {
            for (Itemset itemset2 : levelK_1) {
                Integer missing = itemset1.allTheSameExceptLastItem(itemset2);
                if (missing == null) continue;
                int[] newItemset = new int[itemset1.size() + 1];
                System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                Itemset candidate = new Itemset(newItemset);
                if (!this.allSubsetsOfSizeK_1AreFrequent(candidate, levelK_1)) continue;
                candidates.add(candidate);
            }
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(Itemset candidate, Set<Itemset> levelK_1) {
        if (candidate.size() == 1) {
            return true;
        }
        int[] nArray = candidate.getItems();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer item = nArray[n2];
            Itemset subset = candidate.cloneItemSetMinusOneItem(item);
            boolean found = false;
            for (Itemset itemset : levelK_1) {
                if (!itemset.isEqualTo(subset)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void save(ClosedRule rule) throws IOException {
        ++this.ruleCount;
        if (this.writer != null) {
            int i;
            StringBuffer buffer = new StringBuffer();
            if (rule.getItemset1().size() == 0) {
                buffer.append("__");
            } else {
                i = 0;
                while (i < rule.getItemset1().size()) {
                    buffer.append(rule.getItemset1().get(i));
                    if (i != rule.getItemset1().size() - 1) {
                        buffer.append(" ");
                    }
                    ++i;
                }
            }
            buffer.append(" ==> ");
            i = 0;
            while (i < rule.getItemset2().size()) {
                buffer.append(rule.getItemset2().get(i));
                if (i != rule.getItemset2().size() - 1) {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append(" #SUP: ");
            buffer.append(rule.getAbsoluteSupport());
            buffer.append(" #CONF: ");
            buffer.append(rule.getConfidence());
            this.writer.write(buffer.toString());
            this.writer.newLine();
            this.writer.flush();
        } else {
            this.rules.addRule(rule);
        }
    }

    String doubleToString(double value) {
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(value);
    }

    public void printStatistics() {
        System.out.println("============= CLOSED ASSOCIATION RULE GENERATION - STATS =============");
        System.out.println(" Number of association rules generated : " + this.ruleCount);
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

