# P2R

A set of modules allowing you to export
prolog predicates as RDF just by declaring
mappings, and access them through a SPARQL 
end-point.

Yves Raimond (c) 2007
Centre for Digital Music, Queen Mary, 
University of London

Samer Abdallah (c) 2010, 2014
Department of Computer Science, UCL

## Installation & running

 1. Get ClioPatria from here:
 http://cliopatria.swi-prolog.org/home
 and set it up as per instructions.

 2. Copy or link this p2r directory into the cpacks directory of
 your working ClioPatria server.

 3. Register the cpack by doing  (at the Prolog prompt)

		?- cpack_configure(p2r).

 4. In your code, do

		:- use_module(entailment(p2r)).

    Register any prefixes you need with rdf_register_prefix/2, declare any
    macros with uripattern:def(_,_), and write your mapping rules.

 5. Use the triples:

    a) Select p2r\_entailment on ClioPatria's SPARQL/SeRQL page...

    b) ...or call p2r\_entailment:rdf/3 directly (not recommended)

    c) ...or dump all the p2r\_entailment:rdf/3 triples into the main rdf database, using, eg

			forall(p2r_entailment:rdf(A,B,C), rdf_assert(A,B,C,p2r)).

	  Asserting the triples into a named graph (p2r) makes it easy
	  to delete them all and re-import when things change.


## Pattern language

Resources URIs and literals are expressed using a pattern language.
See the README in the lib directory.

## Example mappings

Suppose you have a predicate widget/3 which holds a database of
widget identifiers, names, and weights, and another predicate 
connectable/2 which describes which widgets can be connected
to each other. Suppose also that the widgets are kept in a cabinet
with pidgeon holes arranged in a matrix, and that the location of
each widget is given by the predicate widget\_location/3.
We could expose this as RDF using the following mappings:

	:- rdf_register_prefix(eg,'http://www.example.org/').
	uripattern:def(loc(X,Y),num(X)/num(Y)).

	rdf(eg:widgets/enc(ID), rdf:type, eg:schema/'Widget') <== widget(ID,_,_).

	widget(ID,Name,Weight) ==>
		rdf(eg:widget/enc(ID), rdf:label, literal(Name)),
		rdf(eg:widget/enc(ID), eg:weight, literal(type(xsd:double,Weight)).

	rdf(eg:widget/enc(ID1), eg:connectsTo, eg:widget/enc(ID2) <= connectable(ID1,ID2).

	rdf(eg:widget/enc(ID), eg:location, eg:storage/loc(X,Y)) <= 
		widget_location(ID,X,Y).

Note that URI patterns MUST be written into the rdf/3 terms in the head
of the rule (ie, the consequent part of the implication, rather than the
antecedent, no matter which way round the rule is written, using <== or ==>).
Otherwise, it is your responsibilty to construct or analyse any URIs. Of course,
you can use the uripattern module to help you do this.
