# Part of DML (Digital Music Laboratory)
# Copyright 2014-2015 Samer Abdallah, University of London
 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

# -*- coding: utf-8 -*-
__author__="samer"

from rdflib import Namespace, BNode, Literal, XSD

cla_ns   = Namespace("http://dml.org/cla#")
tl_ns    = Namespace("http://purl.org/NET/c4dm/timeline.owl#")
event_ns = Namespace("http://purl.org/NET/c4dm/event.owl#")
af_ns    = Namespace("http://purl.org/ontology/af/")

def parse_xsd_duration(string): 
    return float(string[2:len(string)-1])

def event_time_prop(graph,ev,pred):
    return parse_xsd_duration(graph.value(graph.value(ev,event_ns.time), pred))

