/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.dataset_converter;

import ca.pfv.spmf.tools.dataset_converter.Formats;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public class SequenceDatabaseConverter {
    String input;
    String output;
    int lineCount = 0;
    BufferedWriter writer;

    public void convert(String input, String output, Formats inputFileformat, int lineCount) throws IOException {
        this.input = input;
        this.output = output;
        this.lineCount = lineCount;
        this.writer = new BufferedWriter(new FileWriter(output));
        if (inputFileformat.equals((Object)Formats.IBMGenerator)) {
            this.convertIBMGenerator();
        } else if (inputFileformat.equals((Object)Formats.Kosarak)) {
            this.convertKosarak();
        } else if (inputFileformat.equals((Object)Formats.CSV_INTEGER)) {
            this.convertCSV();
        } else if (inputFileformat.equals((Object)Formats.BMS)) {
            this.convertBMS();
        } else if (inputFileformat.equals((Object)Formats.Snake)) {
            this.convertSnake();
        }
        this.writer.flush();
        this.writer.close();
    }

    private void convertSnake() {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int count = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.length() >= 11) {
                    int i = 0;
                    while (i < thisLine.length()) {
                        int character = thisLine.toCharArray()[i] - 65;
                        this.writer.write(String.valueOf(character) + " -1 ");
                        ++i;
                    }
                    this.writer.write("-2");
                }
                if (++count == this.lineCount) break;
                this.writer.newLine();
            }
            myInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertBMS() {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int lastId = 0;
            int count = 0;
            while ((thisLine = myInput.readLine()) != null) {
                String[] split = thisLine.split(" ");
                int id = Integer.parseInt(split[0]);
                int val = Integer.parseInt(split[1]);
                if (lastId != id) {
                    if (lastId != 0) {
                        ++count;
                        this.writer.write("-2");
                        this.writer.newLine();
                    }
                    lastId = id;
                }
                if (count == this.lineCount) break;
                this.writer.write(String.valueOf(val) + " -1 ");
            }
            myInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertCSV() throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(this.input));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int count = 0;
                while ((thisLine = myInput.readLine()) != null) {
                    String[] split;
                    String[] stringArray = split = thisLine.split(",");
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        Integer item = Integer.parseInt(value);
                        this.writer.write(item + " -1 ");
                        ++n2;
                    }
                    this.writer.write("-2");
                    if (++count == this.lineCount) {
                        break;
                    }
                    this.writer.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    private void convertKosarak() throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(this.input));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int count = 0;
                while ((thisLine = myInput.readLine()) != null) {
                    String[] split;
                    String[] stringArray = split = thisLine.split(" ");
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        Integer item = Integer.parseInt(value);
                        this.writer.write(item + " -1 ");
                        ++n2;
                    }
                    this.writer.write("-2");
                    if (++count == this.lineCount) {
                        break;
                    }
                    this.writer.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    private void convertIBMGenerator() {
        DataInputStream myInput = null;
        try {
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new DataInputStream(fin);
            boolean lastMinus1 = false;
            int count = 0;
            while (myInput.available() != 0) {
                int value = this.INT_little_endian_TO_big_endian(myInput.readInt());
                if (value == -1) {
                    this.writer.write("-1 ");
                    lastMinus1 = true;
                    continue;
                }
                if (value == -2) {
                    if (!lastMinus1) {
                        this.writer.write("-1 ");
                    }
                    this.writer.write("-2 ");
                    if (++count == this.lineCount) break;
                    this.writer.newLine();
                    continue;
                }
                this.writer.write(String.valueOf(value) + " ");
                lastMinus1 = false;
            }
            myInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    int INT_little_endian_TO_big_endian(int i) {
        return ((i & 0xFF) << 24) + ((i & 0xFF00) << 8) + ((i & 0xFF0000) >> 8) + (i >> 24 & 0xFF);
    }
}

