/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.associationrules.IGB.AlgoIGB;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.AlgoZart;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.TZTableClosed;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.rule_itemset_array_integer_with_count.Rules;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestIGB_saveToMemory {
    public static void main(String[] args) throws IOException {
        System.out.println("STEP 1 : EXECUTING THE ZART ALGORITHM TO FIND CLOSED ITEMSETS AND MINIMUM GENERATORS");
        String input = MainTestIGB_saveToMemory.fileToPath("contextIGB.txt");
        String output = null;
        TransactionDatabase database = new TransactionDatabase();
        try {
            database.loadFile(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AlgoZart zart = new AlgoZart();
        double minsup = 0.5;
        TZTableClosed results = zart.runAlgorithm(database, minsup);
        zart.printStatistics();
        System.out.println("STEP 2 : RUNNING THE IGB ALGORITHM");
        double minconf = 0.61;
        AlgoIGB algoIGB = new AlgoIGB();
        Rules rules = algoIGB.runAlgorithm(results, database.getTransactions().size(), minconf, output);
        algoIGB.printStatistics();
        rules.printRules(database.getTransactions().size());
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestIGB_saveToMemory.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

