/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.patterns.itemset_set_integers_with_tids;

import ca.pfv.spmf.patterns.AbstractItemset;
import java.util.HashSet;
import java.util.Set;

public class Itemset
extends AbstractItemset {
    public Set<Integer> itemset;
    public Set<Integer> tidset;

    public Itemset() {
        this.itemset = new HashSet<Integer>();
        this.tidset = new HashSet<Integer>();
    }

    public Itemset(Set<Integer> itemset, Set<Integer> tidset) {
        this.itemset = itemset;
        this.tidset = tidset;
    }

    public Itemset(Set<Integer> itemset) {
        this.itemset = itemset;
        this.tidset = null;
    }

    @Override
    public String toString() {
        StringBuffer r = new StringBuffer();
        for (Integer attribute : this.itemset) {
            r.append(attribute.toString());
            r.append(' ');
        }
        return r.toString();
    }

    @Override
    public double getRelativeSupport(int nbObject) {
        return (double)this.tidset.size() / (double)nbObject;
    }

    @Override
    public int getAbsoluteSupport() {
        return this.tidset.size();
    }

    @Override
    public int size() {
        return this.itemset.size();
    }

    @Override
    public boolean contains(Integer item) {
        return this.itemset.contains(item);
    }

    public Set<Integer> getItems() {
        return this.itemset;
    }

    public Itemset union(Itemset itemset) {
        HashSet<Integer> unionItemset = new HashSet<Integer>(this.getItems());
        Itemset union = new Itemset(unionItemset);
        union.getItems().addAll(itemset.getItems());
        return union;
    }

    public void addItem(Integer item) {
        this.getItems().add(item);
    }

    public void setTidset(Set<Integer> tidset) {
        this.tidset = tidset;
    }

    public Set<Integer> getTidset() {
        return this.tidset;
    }
}

