/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui;

import ca.pfv.spmf.algorithms.associationrules.IGB.AlgoIGB;
import ca.pfv.spmf.algorithms.associationrules.Indirect.AlgoINDIRECT;
import ca.pfv.spmf.algorithms.associationrules.MNRRules.AlgoMNRRules;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.AlgoTNR;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.AlgoTopKRules;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Database;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AlgoAgrawalFaster94;
import ca.pfv.spmf.algorithms.associationrules.closedrules.AlgoClosedRules;
import ca.pfv.spmf.algorithms.associationrules.closedrules.ClosedRules;
import ca.pfv.spmf.algorithms.associationrules.fhsar.AlgoFHSAR;
import ca.pfv.spmf.algorithms.clustering.hierarchical_clustering.AlgoHierarchicalClustering;
import ca.pfv.spmf.algorithms.clustering.kmeans.AlgoKMeans;
import ca.pfv.spmf.algorithms.frequentpatterns.MSApriori.AlgoMSApriori;
import ca.pfv.spmf.algorithms.frequentpatterns.apriori.AlgoApriori;
import ca.pfv.spmf.algorithms.frequentpatterns.aprioriTID.AlgoAprioriTID;
import ca.pfv.spmf.algorithms.frequentpatterns.aprioriTIDClose.AlgoAprioriTIDClose;
import ca.pfv.spmf.algorithms.frequentpatterns.apriori_HT.AlgoAprioriHT;
import ca.pfv.spmf.algorithms.frequentpatterns.apriori_close.AlgoAprioriClose;
import ca.pfv.spmf.algorithms.frequentpatterns.apriori_inverse.AlgoAprioriInverse;
import ca.pfv.spmf.algorithms.frequentpatterns.apriori_rare.AlgoAprioriRare;
import ca.pfv.spmf.algorithms.frequentpatterns.cfpgrowth.AlgoCFPGrowth;
import ca.pfv.spmf.algorithms.frequentpatterns.dci_closed_optimized.AlgoDCI_Closed_Optimized;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm.AlgoCharm;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm.AlgoCharmMFI;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm.AlgoEclat;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm_bitset.AlgoCharm_Bitset_saveToFile;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm_bitset.AlgoEclat_Bitset_saveToFile;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.AlgoFPGrowth;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings.AlgoFPGrowth_Strings;
import ca.pfv.spmf.algorithms.frequentpatterns.hmine.AlgoHMine;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoFHM;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoHUIMiner;
import ca.pfv.spmf.algorithms.frequentpatterns.pascal.AlgoPASCAL;
import ca.pfv.spmf.algorithms.frequentpatterns.relim.AlgoRelim;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.AlgoTwoPhase;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemsetsTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.UtilityTransactionDatabaseTP;
import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.AlgoUApriori;
import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.UncertainTransactionDatabase;
import ca.pfv.spmf.algorithms.frequentpatterns.vme.AlgoVME;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.AlgoZart;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.TFTableFrequent;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.TZTableClosed;
import ca.pfv.spmf.algorithms.sequential_rules.cmdeogun.AlgoCMDeogun;
import ca.pfv.spmf.algorithms.sequential_rules.cmrules.AlgoCMRules;
import ca.pfv.spmf.algorithms.sequential_rules.rulegen.AlgoRuleGen;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.AlgoRULEGROWTH;
import ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns.AlgoTNS;
import ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns.AlgoTopSeqRules;
import ca.pfv.spmf.algorithms.sequential_rules.trulegrowth.AlgoTRuleGrowth;
import ca.pfv.spmf.algorithms.sequential_rules.trulegrowth_with_strings.AlgoTRuleGrowth_withStrings;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.AlgoBIDEPlus;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.AlgoMaxSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.AlgoPrefixSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.AlgoTSP_nonClosed;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.AlgoBIDEPlus_withStrings;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.AlgoPrefixSpan_with_Strings;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.AlgoCM_ClaSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.AlgoClaSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.creators.IdListCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.creators.IdListCreatorStandard_Map;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.AlgoCloSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoFournierViger08;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoPrefixSpanMDSPM;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.AlgoDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.AlgoSeqDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.AlgoGoKrimp;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.DataReader;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.AlgoGSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.AlgoPrefixSpan_AGP;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.creators.AbstractionCreator_Qualitative;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.AlgoCMSPADE;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.AlgoSPADE;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.AlgoSPAM_AGP;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.candidatePatternsGeneration.CandidateGenerator_Qualitative;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.creators.IdListCreator_FatBitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.AlgoCMSPAM;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.AlgoSPAM;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.AlgoTKS;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.AlgoVMSP;
import ca.pfv.spmf.gui.PathsManager;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets;
import ca.pfv.spmf.test.MainTestApriori_saveToFile;
import ca.pfv.spmf.tools.dataset_converter.Formats;
import ca.pfv.spmf.tools.dataset_converter.SequenceDatabaseConverter;
import ca.pfv.spmf.tools.dataset_converter.TransactionDatabaseConverter;
import ca.pfv.spmf.tools.dataset_generator.SequenceDatabaseGenerator;
import ca.pfv.spmf.tools.dataset_generator.TransactionDatabaseGenerator;
import ca.pfv.spmf.tools.dataset_stats.SequenceStatsGenerator;
import ca.pfv.spmf.tools.resultConverter.ResultConverter;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class MainWindow
extends JFrame {
    public static String SPMF_VERSION = "0.96c";
    private String inputFile = null;
    private String outputFile = null;
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField textFieldParam1;
    private JTextField textFieldParam2;
    private JTextField textFieldParam3;
    private JTextField textFieldParam4;
    private JTextField textFieldParam5;
    private JTextField textFieldParam6;
    private JLabel labelParam1;
    private JLabel labelParam2;
    private JLabel labelParam3;
    private JLabel labelParam4;
    private JLabel labelParam5;
    private JLabel labelParam6;
    private JLabel lbHelp1;
    private JLabel lbHelp2;
    private JLabel lbHelp3;
    private JLabel lbHelp4;
    private JLabel lbHelp5;
    private JLabel lbHelp6;
    private JTextField textFieldInput;
    private JTextField textFieldOutput;
    private JComboBox<String> comboBox;
    private JTextArea textArea;
    private JButton buttonRun;
    private JCheckBox checkboxOpenOutput;
    private JButton buttonExample;
    private JLabel lblSetOutputFile;
    private JButton buttonOutput;
    private JButton buttonInput;
    private JLabel lblChooseInputFile;

    public static void main(String[] args) {
        if (args.length != 0) {
            MainWindow.processCommandLineArguments(args);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainWindow frame = new MainWindow();
                        frame.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public MainWindow() {
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                System.exit(0);
            }
        });
        this.setTitle("SPMF v" + SPMF_VERSION);
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 644, 564);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.comboBox = new JComboBox(new Vector());
        this.comboBox.setMaximumRowCount(20);
        this.comboBox.addItem("");
        this.comboBox.addItem("  ---- SEQUENTIAL PATTERN MINING ----");
        this.comboBox.addItem("BIDE+");
        this.comboBox.addItem("BIDE+_with_strings");
        this.comboBox.addItem("ClaSP");
        this.comboBox.addItem("CloSpan");
        this.comboBox.addItem("CM-SPADE");
        this.comboBox.addItem("CM-SPAM");
        this.comboBox.addItem("CM-ClaSP");
        this.comboBox.addItem("Fournier08-Closed+time");
        this.comboBox.addItem("GoKrimp");
        this.comboBox.addItem("GSP");
        this.comboBox.addItem("HirateYamana");
        this.comboBox.addItem("MaxSP");
        this.comboBox.addItem("PrefixSpan");
        this.comboBox.addItem("PrefixSpan_AGP");
        this.comboBox.addItem("PrefixSpan_PostProcessingClosed");
        this.comboBox.addItem("PrefixSpan_with_strings");
        this.comboBox.addItem("SPADE");
        this.comboBox.addItem("SPADE_Parallelized");
        this.comboBox.addItem("SPAM");
        this.comboBox.addItem("SPAM_AGP");
        this.comboBox.addItem("SPAM_PostProcessingClosed");
        this.comboBox.addItem("SeqDim_(PrefixSpan+Apriori)");
        this.comboBox.addItem("SeqDim_(PrefixSpan+Apriori)+time");
        this.comboBox.addItem("SeqDim_(BIDE+AprioriClose)");
        this.comboBox.addItem("SeqDim_(BIDE+AprioriClose)+time");
        this.comboBox.addItem("SeqDim_(BIDE+Charm)");
        this.comboBox.addItem("SeqDim_(BIDE+Charm)+time");
        this.comboBox.addItem("TKS");
        this.comboBox.addItem("TSP_nonClosed");
        this.comboBox.addItem("VMSP");
        this.comboBox.addItem("  ---- SEQUENTIAL RULE MINING ----");
        this.comboBox.addItem("CMRules");
        this.comboBox.addItem("CMDeo");
        this.comboBox.addItem("RuleGen");
        this.comboBox.addItem("RuleGrowth");
        this.comboBox.addItem("TRuleGrowth");
        this.comboBox.addItem("TRuleGrowth_with_strings");
        this.comboBox.addItem("TopSeqRules");
        this.comboBox.addItem("TNS");
        this.comboBox.addItem("  ---- ITEMSET MINING----");
        this.comboBox.addItem("Apriori");
        this.comboBox.addItem("Apriori_with_hash_tree");
        this.comboBox.addItem("Apriori_TID");
        this.comboBox.addItem("Apriori_TID_bitset");
        this.comboBox.addItem("Apriori_TIDClose");
        this.comboBox.addItem("AprioriClose");
        this.comboBox.addItem("AprioriRare");
        this.comboBox.addItem("AprioriInverse");
        this.comboBox.addItem("CFPGrowth++");
        this.comboBox.addItem("Charm");
        this.comboBox.addItem("Charm_bitset");
        this.comboBox.addItem("Charm_MFI");
        this.comboBox.addItem("DCI_Closed");
        this.comboBox.addItem("Eclat");
        this.comboBox.addItem("Eclat_bitset");
        this.comboBox.addItem("FHM");
        this.comboBox.addItem("FPGrowth_itemsets");
        this.comboBox.addItem("FPGrowth_itemsets_with_strings");
        this.comboBox.addItem("HMine");
        this.comboBox.addItem("HUI-Miner");
        this.comboBox.addItem("MSApriori");
        this.comboBox.addItem("Pascal");
        this.comboBox.addItem("Relim");
        this.comboBox.addItem("Two-Phase");
        this.comboBox.addItem("UApriori");
        this.comboBox.addItem("VME");
        this.comboBox.addItem("Zart");
        this.comboBox.addItem("  ---- ASSOCIATION RULE MINING ----");
        this.comboBox.addItem("Apriori_association_rules");
        this.comboBox.addItem("Closed_association_rules");
        this.comboBox.addItem("FHSAR");
        this.comboBox.addItem("FPGrowth_association_rules");
        this.comboBox.addItem("FPGrowth_association_rules_with_lift");
        this.comboBox.addItem("CFPGrowth++_association_rules");
        this.comboBox.addItem("CFPGrowth++_association_rules_with_lift");
        this.comboBox.addItem("IGB");
        this.comboBox.addItem("Indirect_association_rules");
        this.comboBox.addItem("MNR");
        this.comboBox.addItem("Sporadic_association_rules");
        this.comboBox.addItem("TopKRules");
        this.comboBox.addItem("TNR");
        this.comboBox.addItem("  ---- CLUSTERING ----");
        this.comboBox.addItem("Hierarchical_clustering");
        this.comboBox.addItem("KMeans");
        this.comboBox.addItem("  ---- DATASET TOOLS ----");
        this.comboBox.addItem("Calculate_stats_for_a_sequence_database");
        this.comboBox.addItem("Convert_a_sequence_database_to_SPMF_format");
        this.comboBox.addItem("Convert_a_transaction_database_to_SPMF_format");
        this.comboBox.addItem("Generate_a_sequence_database");
        this.comboBox.addItem("Generate_a_sequence_database_with_timestamps");
        this.comboBox.addItem("Generate_a_transaction_database");
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainWindow.this.updateUserInterfaceAfterAlgorithmSelection(evt.getItem().toString(), evt.getStateChange() == 1);
            }
        });
        this.comboBox.setBounds(263, 74, 306, 20);
        this.contentPane.add(this.comboBox);
        this.buttonRun = new JButton("Run algorithm");
        this.buttonRun.setEnabled(false);
        this.buttonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.processRunAlgorithmCommandFromGUI();
            }
        });
        this.buttonRun.setBounds(277, 340, 119, 23);
        this.contentPane.add(this.buttonRun);
        JLabel lblChooseAnAlgorithm = new JLabel("Choose an algorithm:");
        lblChooseAnAlgorithm.setBounds(22, 73, 204, 20);
        this.contentPane.add(lblChooseAnAlgorithm);
        JLabel lblNewLabel = new JLabel("New label");
        lblNewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                MainWindow.this.openWebPage("http://www.philippe-fournier-viger.com/spmf/");
            }
        });
        lblNewLabel.setIcon(new ImageIcon(MainWindow.class.getResource("spmf.png")));
        lblNewLabel.setBounds(0, 0, 186, 62);
        this.contentPane.add(lblNewLabel);
        this.textFieldParam1 = new JTextField();
        this.textFieldParam1.setBounds(263, 164, 157, 20);
        this.contentPane.add(this.textFieldParam1);
        this.textFieldParam1.setColumns(10);
        this.buttonInput = new JButton("...");
        this.buttonInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.askUserToChooseInputFile();
            }
        });
        this.buttonInput.setBounds(430, 104, 32, 23);
        this.contentPane.add(this.buttonInput);
        this.buttonOutput = new JButton("...");
        this.buttonOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.askUserToChooseOutputFile();
            }
        });
        this.buttonOutput.setBounds(430, 133, 32, 23);
        this.contentPane.add(this.buttonOutput);
        this.labelParam1 = new JLabel("Parameter 1:");
        this.labelParam1.setBounds(22, 167, 204, 14);
        this.contentPane.add(this.labelParam1);
        this.labelParam2 = new JLabel("Parameter 2:");
        this.labelParam2.setBounds(22, 192, 204, 14);
        this.contentPane.add(this.labelParam2);
        this.labelParam3 = new JLabel("Parameter 3:");
        this.labelParam3.setBounds(22, 217, 204, 14);
        this.contentPane.add(this.labelParam3);
        this.labelParam4 = new JLabel("Parameter 4:");
        this.labelParam4.setBounds(22, 239, 231, 14);
        this.contentPane.add(this.labelParam4);
        this.labelParam5 = new JLabel("Parameter 5:");
        this.labelParam5.setBounds(22, 264, 156, 14);
        this.contentPane.add(this.labelParam5);
        this.labelParam6 = new JLabel("Parameter 6:");
        this.labelParam6.setBounds(22, 289, 156, 14);
        this.contentPane.add(this.labelParam6);
        this.textFieldParam2 = new JTextField();
        this.textFieldParam2.setColumns(10);
        this.textFieldParam2.setBounds(263, 189, 157, 20);
        this.contentPane.add(this.textFieldParam2);
        this.textFieldParam3 = new JTextField();
        this.textFieldParam3.setColumns(10);
        this.textFieldParam3.setBounds(263, 214, 157, 20);
        this.contentPane.add(this.textFieldParam3);
        this.textFieldParam4 = new JTextField();
        this.textFieldParam4.setColumns(10);
        this.textFieldParam4.setBounds(263, 236, 157, 20);
        this.contentPane.add(this.textFieldParam4);
        this.textFieldParam5 = new JTextField();
        this.textFieldParam5.setColumns(10);
        this.textFieldParam5.setBounds(263, 261, 157, 20);
        this.contentPane.add(this.textFieldParam5);
        this.textFieldParam6 = new JTextField();
        this.textFieldParam6.setColumns(10);
        this.textFieldParam6.setBounds(263, 286, 157, 20);
        this.contentPane.add(this.textFieldParam6);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(10, 377, 618, 148);
        this.contentPane.add(scrollPane);
        this.textArea = new JTextArea();
        scrollPane.setViewportView(this.textArea);
        System.setOut(new PrintStream(new TextAreaOutputStream(this.textArea)));
        this.textFieldInput = new JTextField();
        this.textFieldInput.setEditable(false);
        this.textFieldInput.setBounds(263, 105, 157, 20);
        this.contentPane.add(this.textFieldInput);
        this.textFieldInput.setColumns(10);
        this.textFieldOutput = new JTextField();
        this.textFieldOutput.setEditable(false);
        this.textFieldOutput.setColumns(10);
        this.textFieldOutput.setBounds(263, 134, 157, 20);
        this.contentPane.add(this.textFieldOutput);
        this.checkboxOpenOutput = new JCheckBox("Open output file when the algorithm terminates");
        this.checkboxOpenOutput.setSelected(true);
        this.checkboxOpenOutput.setBounds(22, 310, 358, 23);
        this.contentPane.add(this.checkboxOpenOutput);
        this.buttonExample = new JButton("?");
        this.buttonExample.setEnabled(false);
        this.buttonExample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String choice = (String)MainWindow.this.comboBox.getSelectedItem();
                MainWindow.this.openHelpWebPageForAlgorithm(choice);
            }
        });
        this.buttonExample.setBounds(579, 73, 49, 23);
        this.contentPane.add(this.buttonExample);
        this.lblChooseInputFile = new JLabel("Choose input file");
        this.lblChooseInputFile.setBounds(22, 108, 97, 14);
        this.contentPane.add(this.lblChooseInputFile);
        this.lblSetOutputFile = new JLabel("Set output file");
        this.lblSetOutputFile.setBounds(22, 137, 97, 14);
        this.contentPane.add(this.lblSetOutputFile);
        this.lbHelp1 = new JLabel("help1");
        this.lbHelp1.setBounds(430, 167, 157, 14);
        this.contentPane.add(this.lbHelp1);
        this.lbHelp2 = new JLabel("help2");
        this.lbHelp2.setBounds(430, 192, 157, 14);
        this.contentPane.add(this.lbHelp2);
        this.lbHelp3 = new JLabel("help3");
        this.lbHelp3.setBounds(430, 217, 157, 14);
        this.contentPane.add(this.lbHelp3);
        this.lbHelp4 = new JLabel("help4");
        this.lbHelp4.setBounds(430, 239, 157, 14);
        this.contentPane.add(this.lbHelp4);
        this.lbHelp5 = new JLabel("help5");
        this.lbHelp5.setBounds(430, 264, 157, 14);
        this.contentPane.add(this.lbHelp5);
        this.lbHelp6 = new JLabel("help6");
        this.lbHelp6.setBounds(430, 289, 157, 14);
        this.contentPane.add(this.lbHelp6);
        this.hideAllParams();
    }

    private void updateUserInterfaceAfterAlgorithmSelection(String algorithmName, boolean isSelected) {
        if (isSelected) {
            this.buttonRun.setEnabled(true);
            this.buttonExample.setEnabled(true);
            if ("SPAM".equals(algorithmName) || "PrefixSpan".equals(algorithmName) || "CM-SPAM".equals(algorithmName) || "VMSP".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.5 or 50%)");
                this.setParam(this.textFieldParam2, "Max pattern length:", this.labelParam2, "(e.g. 4 items)");
            } else if ("HirateYamana".equals(algorithmName) || "Fournier08-Closed+time".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.5 or 50%)");
                this.setParam(this.textFieldParam2, "Min time interval:", this.labelParam2, "(e.g. 0 itemsets)");
                this.setParam(this.textFieldParam3, "Max time interval:", this.labelParam3, "(e.g. 2 itemsets)");
                this.setParam(this.textFieldParam4, "Min whole time interval:", this.labelParam4, "(e.g. 0 itemsets)");
                this.setParam(this.textFieldParam5, "Max whole time interval:", this.labelParam5, "(e.g. 2 itemsets)");
            } else if ("SeqDim_(PrefixSpan+Apriori)".equals(algorithmName) || "SeqDim_(BIDE+AprioriClose)".equals(algorithmName) || "SeqDim_(BIDE+Charm)".equals(algorithmName) || "PrefixSpan_with_strings".equals(algorithmName) || "BIDE+".equals(algorithmName) || "BIDE+_with_strings".equals(algorithmName) || "PrefixSpan_AGP".equals(algorithmName) || "PrefixSpan_PostProcessingClosed".equals(algorithmName) || "GSP".equals(algorithmName) || "SPADE".equals(algorithmName) || "CM-SPADE".equals(algorithmName) || "CM-ClaSP".equals(algorithmName) || "SPADE_Parallelized".equals(algorithmName) || "SPAM_AGP".equals(algorithmName) || "SPAM_PostProcessingClosed".equals(algorithmName) || "ClaSP".equals(algorithmName) || "CloSpan".equals(algorithmName) || "MaxSP".equals(algorithmName) || "FPGrowth_itemsets".equals(algorithmName) || "FPGrowth_itemsets_with_strings".equals(algorithmName) || "Apriori".equals(algorithmName) || "Apriori_TID_bitset".equals(algorithmName) || "Apriori_TID".equals(algorithmName) || "Apriori_TIDClose".equals(algorithmName) || "AprioriClose".equals(algorithmName) || "AprioriRare".equals(algorithmName) || "Eclat".equals(algorithmName) || "Charm".equals(algorithmName) || "Charm_MFI".equals(algorithmName) || "Charm_bitset".equals(algorithmName) || "Relim".equals(algorithmName) || "Eclat_bitset".equals(algorithmName) || "Pascal".equals(algorithmName) || "Zart".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.4 or 40%)");
            } else if ("Apriori_with_hash_tree".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.4 or 40%)");
                this.setParam(this.textFieldParam2, "Hash-tree branch count:", this.labelParam2, "(default: 30)");
            } else if ("SeqDim_(PrefixSpan+Apriori)+time".equals(algorithmName) || "SeqDim_(BIDE+AprioriClose)+time".equals(algorithmName) || "SeqDim_(BIDE+Charm)+time".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g.  0.5  or 50 %)");
                this.setParam(this.textFieldParam2, "Choose minInterval:", this.labelParam2, "(e.g.  1)");
                this.setParam(this.textFieldParam3, "Choose maxInterval:", this.labelParam3, "(e.g.  5)");
                this.setParam(this.textFieldParam4, "Choose minWholeInterval:", this.labelParam4, "(e.g.  1)");
                this.setParam(this.textFieldParam5, "Choose maxWholeInterval:", this.labelParam5, "(e.g.  5)");
            } else if ("HMine".equals(algorithmName) || "DCI_Closed".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (integer):", this.labelParam1, "(e.g. 2)");
            } else if ("VME".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose threshold (%):", this.labelParam1, "(e.g. 0.15 or 15%)");
            } else if ("AprioriInverse".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.001 or 0.1%)");
                this.setParam(this.textFieldParam2, "Choose maxsup (%):", this.labelParam2, "(e.g. 0.06 or 6%)");
            } else if ("UApriori".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose expected support (%):", this.labelParam1, "(e.g. 0.10)");
            } else if ("FPGrowth_association_rules".equals(algorithmName) || "Apriori_association_rules".equals(algorithmName) || "RuleGrowth".equals(algorithmName) || "CMRules".equals(algorithmName) || "CMDeo".equals(algorithmName) || "IGB".equals(algorithmName) || "Closed_association_rules".equals(algorithmName) || "MNR".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.5 or 50%)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.6 or 60%)");
            } else if ("Sporadic_association_rules".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.1 or 10%)");
                this.setParam(this.textFieldParam2, "Choose maxsup (%):", this.labelParam2, "(e.g. 0.6 or 60%)");
                this.setParam(this.textFieldParam3, "Choose minconf (%):", this.labelParam2, "(e.g. 0.6 or 60%)");
            } else if ("Indirect_association_rules".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.6 or 60%)");
                this.setParam(this.textFieldParam2, "Choose ts (%):", this.labelParam2, "(e.g. 0.5 or 50%)");
                this.setParam(this.textFieldParam3, "Choose minconf (%):", this.labelParam2, "(e.g. 0.1 or 10%)");
            } else if ("RuleGen".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (integer):", this.labelParam1, "(e.g. 3)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.6 or 60%)");
            } else if ("KMeans".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose K:", this.labelParam1, "(e.g. 3)");
            } else if ("Hierarchical_clustering".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose max distance:", this.labelParam1, "(e.g. 4)");
            } else if ("FPGrowth_association_rules_with_lift".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.5 or 50%)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.6 or 60%)");
                this.setParam(this.textFieldParam3, "Choose minlift:", this.labelParam3, "(e.g. 0.2)");
            } else if ("CFPGrowth++_association_rules_with_lift".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "MIS file name:", this.labelParam1, "(e.g. MIS.txt)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.6 or 60%)");
                this.setParam(this.textFieldParam3, "Choose minlift:", this.labelParam3, "(e.g. 0.2)");
            } else if ("CFPGrowth++_association_rules".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "MIS file name:", this.labelParam1, "(e.g. MIS.txt)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.6 or 60%)");
            } else if ("TopSeqRules".equals(algorithmName) || "TopKRules".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose k:", this.labelParam1, "(e.g. 3)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.8 or 80%)");
            } else if ("TKS".equals(algorithmName) || "TSP_nonClosed".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose k:", this.labelParam1, "(e.g. 5)");
            } else if ("TNR".equals(algorithmName) || "TNS".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose k:", this.labelParam1, "(e.g. 10)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.5 or 50%)");
                this.setParam(this.textFieldParam3, "Choose delta:", this.labelParam3, "(e.g. 2)");
            } else if ("Two-Phase".equals(algorithmName) || "HUI-Miner".equals(algorithmName) || "FHM".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minutility:", this.labelParam1, "(e.g. 30)");
            } else if ("FHSAR".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.5 or 50%)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.6 or 60%)");
                this.setParam(this.textFieldParam3, "SAR file name:", this.labelParam3, "(e.g. sar.txt)");
            } else if ("GoKrimp".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Label file name (optional:", this.labelParam1, "(e.g. test_goKrimp.lab)");
            } else if ("MSApriori".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose beta:", this.labelParam1, "(e.g. 0.4 or 40%)");
                this.setParam(this.textFieldParam2, "Choose LS:", this.labelParam2, "(e.g. 0.2 or 20%)");
            } else if ("CFPGrowth++".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "MIS file name:", this.labelParam1, "(e.g. MIS.txt)");
            } else if ("TRuleGrowth".equals(algorithmName) || "TRuleGrowth_with_strings".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose minsup (%):", this.labelParam1, "(e.g. 0.7 or 70%)");
                this.setParam(this.textFieldParam2, "Choose minconf (%):", this.labelParam2, "(e.g. 0.8 or 80%)");
                this.setParam(this.textFieldParam3, "Choose window_size:", this.labelParam3, "(e.g. 3)");
            } else if ("Convert_a_sequence_database_to_SPMF_format".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose input format:", this.labelParam1, "(e.g. CSV_INTEGER)");
                this.setParam(this.textFieldParam2, "Choose sequence count:", this.labelParam2, "(e.g. 5)");
            } else if ("Convert_a_transaction_database_to_SPMF_format".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose input format:", this.labelParam1, "(e.g. CSV_INTEGER)");
                this.setParam(this.textFieldParam2, "Choose sequence count:", this.labelParam2, "(e.g. 5)");
            } else if ("Generate_a_sequence_database".equals(algorithmName) || "Generate_a_sequence_database_with_timestamps".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose sequence count:", this.labelParam1, "(e.g. 100)");
                this.setParam(this.textFieldParam2, "Choose max. distinct items:", this.labelParam2, "(e.g. 1000)");
                this.setParam(this.textFieldParam3, "Choose item count by itemset:", this.labelParam3, "(e.g. 3)");
                this.setParam(this.textFieldParam4, "Choose itemset count per sequence:", this.labelParam4, "(e.g. 7)");
                this.lblChooseInputFile.setVisible(false);
                this.buttonInput.setVisible(false);
                this.textFieldInput.setVisible(false);
            } else if ("Generate_a_transaction_database".equals(algorithmName)) {
                this.hideAllParams();
                this.setParam(this.textFieldParam1, "Choose transaction count:", this.labelParam1, "(e.g. 100)");
                this.setParam(this.textFieldParam2, "Choose max. distinct items:", this.labelParam2, "(e.g. 1000)");
                this.setParam(this.textFieldParam3, "Max. item count per transaction:", this.labelParam3, "(e.g. 10)");
                this.lblChooseInputFile.setVisible(false);
                this.buttonInput.setVisible(false);
                this.textFieldInput.setVisible(false);
            } else if ("Calculate_stats_for_a_sequence_database".equals(algorithmName)) {
                this.hideAllParams();
                this.lblSetOutputFile.setVisible(false);
                this.buttonOutput.setVisible(false);
                this.textFieldOutput.setVisible(false);
                this.checkboxOpenOutput.setVisible(false);
            } else {
                if (!this.isVisible()) {
                    System.out.println("There is no algorithm with this name.  To fix this problem, you may check the command syntax in the SPMF documentation and/or verify if there is a new version of SPMF on the SPMF website.");
                }
                this.hideAllParams();
                this.buttonRun.setEnabled(false);
                this.buttonExample.setEnabled(false);
            }
        } else {
            this.hideAllParams();
            this.buttonRun.setEnabled(false);
            this.buttonExample.setEnabled(false);
        }
    }

    private void setParam(JTextField textfield, String name, JLabel label, String helpText) {
        label.setText(name);
        textfield.setEnabled(true);
        textfield.setVisible(true);
        label.setVisible(true);
        if (textfield == this.textFieldParam1) {
            this.lbHelp1.setText(helpText);
            this.lbHelp1.setVisible(true);
        } else if (textfield == this.textFieldParam2) {
            this.lbHelp2.setText(helpText);
            this.lbHelp2.setVisible(true);
        } else if (textfield == this.textFieldParam3) {
            this.lbHelp3.setText(helpText);
            this.lbHelp3.setVisible(true);
        } else if (textfield == this.textFieldParam4) {
            this.lbHelp4.setText(helpText);
            this.lbHelp4.setVisible(true);
        } else if (textfield == this.textFieldParam5) {
            this.lbHelp5.setText(helpText);
            this.lbHelp5.setVisible(true);
        } else if (textfield == this.textFieldParam6) {
            this.lbHelp6.setText(helpText);
            this.lbHelp6.setVisible(true);
        }
    }

    private static double getParamAsDouble(String value) {
        if (value.contains("%")) {
            value = value.substring(0, value.length() - 1);
            return Double.parseDouble(value) / 100.0;
        }
        return Double.parseDouble(value);
    }

    private static int getParamAsInteger(String value) {
        return Integer.parseInt(value);
    }

    private static String getParamAsString(String value) {
        return value;
    }

    private void hideAllParams() {
        this.labelParam1.setVisible(false);
        this.labelParam2.setVisible(false);
        this.labelParam3.setVisible(false);
        this.labelParam4.setVisible(false);
        this.labelParam5.setVisible(false);
        this.labelParam6.setVisible(false);
        this.lbHelp1.setVisible(false);
        this.lbHelp2.setVisible(false);
        this.lbHelp3.setVisible(false);
        this.lbHelp4.setVisible(false);
        this.lbHelp5.setVisible(false);
        this.lbHelp6.setVisible(false);
        this.textFieldParam1.setVisible(false);
        this.textFieldParam2.setVisible(false);
        this.textFieldParam3.setVisible(false);
        this.textFieldParam4.setVisible(false);
        this.textFieldParam5.setVisible(false);
        this.textFieldParam6.setVisible(false);
        this.lblSetOutputFile.setVisible(true);
        this.buttonOutput.setVisible(true);
        this.textFieldOutput.setVisible(true);
        this.lblChooseInputFile.setVisible(true);
        this.buttonInput.setVisible(true);
        this.textFieldInput.setVisible(true);
        this.checkboxOpenOutput.setVisible(true);
    }

    private void openWebPage(String url) {
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private static boolean runAlgorithm(String algorithmName, String inputFile, String outputFile, String[] parameters) {
        try {
            String format;
            String misFile;
            Object database;
            Object abstractionCreator;
            Object algo;
            Object sequenceDatabase;
            Map<Integer, String> mapItemAttributeValue = null;
            String originalOutputFile = null;
            String originalInputFile = null;
            if (inputFile != null && (inputFile.endsWith(".arff") || inputFile.endsWith(".ARFF"))) {
                TransactionDatabaseConverter converter = new TransactionDatabaseConverter();
                System.out.println("Converting ARFF to SPMF format.");
                originalOutputFile = outputFile;
                originalInputFile = inputFile;
                inputFile = String.valueOf(inputFile) + ".tmp";
                outputFile = String.valueOf(outputFile) + ".tmp";
                mapItemAttributeValue = converter.convertARFFandReturnMap(originalInputFile, inputFile, Integer.MAX_VALUE);
                System.out.println("Conversion completed.");
            }
            if ("PrefixSpan".equals(algorithmName)) {
                sequenceDatabase = new ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase();
                ((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase).loadFile(inputFile);
                int minsup = (int)(MainWindow.getParamAsDouble(parameters[0]) * (double)((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase).size());
                AlgoPrefixSpan algo2 = new AlgoPrefixSpan();
                if (!"".equals(parameters[1])) {
                    algo2.setMaximumPatternLength(MainWindow.getParamAsInteger(parameters[1]));
                }
                algo2.runAlgorithm((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase, outputFile, minsup);
                algo2.printStatistics(((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase).size());
            } else if ("PrefixSpan_with_strings".equals(algorithmName)) {
                sequenceDatabase = new ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase();
                ((ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase)sequenceDatabase).loadFile(inputFile);
                AlgoPrefixSpan_with_Strings algo3 = new AlgoPrefixSpan_with_Strings();
                int minsup = (int)(MainWindow.getParamAsDouble(parameters[0]) * (double)((ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase)sequenceDatabase).size());
                algo3.runAlgorithm((ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase)sequenceDatabase, outputFile, minsup);
                algo3.printStatistics(((ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase)sequenceDatabase).size());
            } else if ("SeqDim_(PrefixSpan+Apriori)".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
                contextMDDatabase.loadFile(inputFile);
                AlgoDim algoDim = new AlgoDim(false, false);
                AlgoSeqDim algoSeqDim = new AlgoSeqDim();
                AlgoPrefixSpanMDSPM prefixSpan = new AlgoPrefixSpanMDSPM(minsup);
                algoSeqDim.runAlgorithm(contextMDDatabase, prefixSpan, algoDim, false, outputFile);
                algoSeqDim.printStatistics(contextMDDatabase.size());
            } else if ("HirateYamana".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minInterval = MainWindow.getParamAsDouble(parameters[1]);
                double maxInterval = MainWindow.getParamAsDouble(parameters[2]);
                double minWholeInterval = MainWindow.getParamAsDouble(parameters[3]);
                double maxWholeInterval = MainWindow.getParamAsDouble(parameters[4]);
                ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.SequenceDatabase database2 = new ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.SequenceDatabase();
                database2.loadFile(inputFile);
                AlgoFournierViger08 algo4 = new AlgoFournierViger08(minsup, minInterval, maxInterval, minWholeInterval, maxWholeInterval, null, false, false);
                algo4.runAlgorithm(database2, outputFile);
                algo4.printStatistics();
            } else if ("SeqDim_(PrefixSpan+Apriori)+time".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minInterval = MainWindow.getParamAsDouble(parameters[1]);
                double maxInterval = MainWindow.getParamAsDouble(parameters[2]);
                double minWholeInterval = MainWindow.getParamAsDouble(parameters[3]);
                double maxWholeInterval = MainWindow.getParamAsDouble(parameters[4]);
                MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
                contextMDDatabase.loadFile(inputFile);
                AlgoDim algoDim = new AlgoDim(false, false);
                AlgoSeqDim algoSeqDim2 = new AlgoSeqDim();
                AlgoFournierViger08 algoPrefixSpanHirateClustering = new AlgoFournierViger08(minsup, minInterval, maxInterval, minWholeInterval, maxWholeInterval, null, false, false);
                algoSeqDim2.runAlgorithm(contextMDDatabase, algoPrefixSpanHirateClustering, algoDim, false, outputFile);
                algoSeqDim2.printStatistics(contextMDDatabase.size());
            } else if ("SeqDim_(BIDE+AprioriClose)+time".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minInterval = MainWindow.getParamAsDouble(parameters[1]);
                double maxInterval = MainWindow.getParamAsDouble(parameters[2]);
                double minWholeInterval = MainWindow.getParamAsDouble(parameters[3]);
                double maxWholeInterval = MainWindow.getParamAsDouble(parameters[4]);
                MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
                contextMDDatabase.loadFile(inputFile);
                AlgoDim algoDim = new AlgoDim(true, false);
                AlgoSeqDim algoSeqDim2 = new AlgoSeqDim();
                AlgoFournierViger08 algoPrefixSpanHirateClustering = new AlgoFournierViger08(minsup, minInterval, maxInterval, minWholeInterval, maxWholeInterval, null, true, true);
                algoSeqDim2.runAlgorithm(contextMDDatabase, algoPrefixSpanHirateClustering, algoDim, true, outputFile);
                algoSeqDim2.printStatistics(contextMDDatabase.size());
            } else if ("SeqDim_(BIDE+Charm)+time".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minInterval = MainWindow.getParamAsDouble(parameters[1]);
                double maxInterval = MainWindow.getParamAsDouble(parameters[2]);
                double minWholeInterval = MainWindow.getParamAsDouble(parameters[3]);
                double maxWholeInterval = MainWindow.getParamAsDouble(parameters[4]);
                MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
                contextMDDatabase.loadFile(inputFile);
                AlgoDim algoDim = new AlgoDim(false, true);
                AlgoSeqDim algoSeqDim2 = new AlgoSeqDim();
                AlgoFournierViger08 algoPrefixSpanHirateClustering = new AlgoFournierViger08(minsup, minInterval, maxInterval, minWholeInterval, maxWholeInterval, null, true, true);
                algoSeqDim2.runAlgorithm(contextMDDatabase, algoPrefixSpanHirateClustering, algoDim, true, outputFile);
                algoSeqDim2.printStatistics(contextMDDatabase.size());
            } else if ("SeqDim_(BIDE+AprioriClose)".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
                contextMDDatabase.loadFile(inputFile);
                AlgoDim algoDim = new AlgoDim(true, false);
                AlgoSeqDim algoSeqDim = new AlgoSeqDim();
                ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoBIDEPlus bideplus = new ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoBIDEPlus(minsup);
                algoSeqDim.runAlgorithm(contextMDDatabase, bideplus, algoDim, true, outputFile);
                algoSeqDim.printStatistics(contextMDDatabase.size());
            } else if ("SeqDim_(BIDE+Charm)".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
                contextMDDatabase.loadFile(inputFile);
                AlgoDim algoDim = new AlgoDim(false, true);
                AlgoSeqDim algoSeqDim = new AlgoSeqDim();
                ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoBIDEPlus bideplus = new ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoBIDEPlus(minsup);
                algoSeqDim.runAlgorithm(contextMDDatabase, bideplus, algoDim, true, outputFile);
                algoSeqDim.printStatistics(contextMDDatabase.size());
            } else if ("SPAM".equals(algorithmName)) {
                algo = new AlgoSPAM();
                if (!"".equals(parameters[1])) {
                    ((AlgoSPAM)algo).setMaximumPatternLength(MainWindow.getParamAsInteger(parameters[1]));
                }
                ((AlgoSPAM)algo).runAlgorithm(inputFile, outputFile, MainWindow.getParamAsDouble(parameters[0]));
                ((AlgoSPAM)algo).printStatistics();
            } else if ("CM-SPAM".equals(algorithmName)) {
                algo = new AlgoCMSPAM();
                if (!"".equals(parameters[1])) {
                    ((AlgoCMSPAM)algo).setMaximumPatternLength(MainWindow.getParamAsInteger(parameters[1]));
                }
                ((AlgoCMSPAM)algo).runAlgorithm(inputFile, outputFile, MainWindow.getParamAsDouble(parameters[0]));
                ((AlgoCMSPAM)algo).printStatistics();
            } else if ("VMSP".equals(algorithmName)) {
                algo = new AlgoVMSP();
                if (!"".equals(parameters[1])) {
                    ((AlgoVMSP)algo).setMaximumPatternLength(MainWindow.getParamAsInteger(parameters[1]));
                }
                ((AlgoVMSP)algo).runAlgorithm(inputFile, outputFile, MainWindow.getParamAsDouble(parameters[0]));
                ((AlgoVMSP)algo).printStatistics();
            } else if ("MaxSP".equals(algorithmName)) {
                sequenceDatabase = new ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase();
                ((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase).loadFile(inputFile);
                AlgoMaxSP algo5 = new AlgoMaxSP();
                algo5.runAlgorithm((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase, outputFile, MainWindow.getParamAsInteger(parameters[1]));
                algo5.printStatistics(((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase).size());
            } else if ("GSP".equals(algorithmName)) {
                abstractionCreator = ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.creators.AbstractionCreator_Qualitative.getInstance();
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                AlgoGSP algo6 = new AlgoGSP(minSupport, 0.0, 2.147483647E9, 0.0, (ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.creators.AbstractionCreator)abstractionCreator);
                SequenceDatabase sd = new SequenceDatabase((ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.creators.AbstractionCreator)abstractionCreator);
                sd.loadFile(inputFile, minSupport);
                algo6.runAlgorithm(sd, true, false, outputFile);
                System.out.println(algo6.printStatistics());
            } else if ("PrefixSpan_AGP".equals(algorithmName)) {
                abstractionCreator = AbstractionCreator_Qualitative.getInstance();
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                AlgoPrefixSpan_AGP algo7 = new AlgoPrefixSpan_AGP(minSupport, (AbstractionCreator)abstractionCreator);
                ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.SequenceDatabase((AbstractionCreator)abstractionCreator);
                sd.loadFile(inputFile, minSupport);
                algo7.runAlgorithm(sd, true, false, outputFile);
                System.out.println(algo7.printStatistics());
            } else if ("SPADE".equals(algorithmName)) {
                abstractionCreator = ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator_Qualitative.getInstance();
                ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.creators.IdListCreator idListCreator = IdListCreator_FatBitmap.getInstance();
                CandidateGenerator_Qualitative candidateGenerator = CandidateGenerator_Qualitative.getInstance();
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                AlgoSPADE algo8 = new AlgoSPADE(minSupport, true, (ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator)abstractionCreator);
                ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase((ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator)abstractionCreator, idListCreator);
                sd.loadFile(inputFile, minSupport);
                algo8.runAlgorithm(sd, candidateGenerator, true, false, outputFile);
                System.out.println(algo8.printStatistics());
            } else if ("SPADE_Parallelized".equals(algorithmName)) {
                abstractionCreator = ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator_Qualitative.getInstance();
                ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.creators.IdListCreator idListCreator = IdListCreator_FatBitmap.getInstance();
                CandidateGenerator_Qualitative candidateGenerator = CandidateGenerator_Qualitative.getInstance();
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                AlgoSPADE algo9 = new AlgoSPADE(minSupport, true, (ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator)abstractionCreator);
                ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase((ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator)abstractionCreator, idListCreator);
                sd.loadFile(inputFile, minSupport);
                algo9.runAlgorithmParallelized(sd, candidateGenerator, true, false, outputFile);
                System.out.println(algo9.printStatistics());
            } else if ("CM-SPADE".equals(algorithmName)) {
                abstractionCreator = ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator_Qualitative.getInstance();
                ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.creators.IdListCreator idListCreator = IdListCreator_FatBitmap.getInstance();
                CandidateGenerator_Qualitative candidateGenerator = CandidateGenerator_Qualitative.getInstance();
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                AlgoCMSPADE algo10 = new AlgoCMSPADE(minSupport, true, (ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator)abstractionCreator);
                ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase((ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator)abstractionCreator, idListCreator);
                sd.loadFile(inputFile, minSupport);
                algo10.runAlgorithm(sd, candidateGenerator, true, false, outputFile);
                System.out.println(algo10.printStatistics());
            } else if ("SPAM_AGP".equals(algorithmName)) {
                abstractionCreator = ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator_Qualitative.getInstance();
                ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.creators.IdListCreator idListCreator = IdListCreator_FatBitmap.getInstance();
                CandidateGenerator_Qualitative candidateGenerator = CandidateGenerator_Qualitative.getInstance();
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                AlgoSPAM_AGP algo11 = new AlgoSPAM_AGP(minSupport);
                ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase((ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator)abstractionCreator, idListCreator);
                sd.loadFile(inputFile, minSupport);
                algo11.runAlgorithm(sd, true, false, outputFile);
                System.out.println(algo11.printStatistics());
            } else if ("SPAM_PostProcessingClosed".equals(algorithmName)) {
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator_Qualitative abstractionCreator2 = ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator_Qualitative.getInstance();
                IdListCreator idListCreator = IdListCreatorStandard_Map.getInstance();
                ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database.SequenceDatabase(abstractionCreator2, idListCreator);
                double relativeMinSup = sd.loadFile(inputFile, minSupport);
                AlgoClaSP algo12 = new AlgoClaSP(relativeMinSup, abstractionCreator2, true, false);
                algo12.runAlgorithm(sd, true, false, outputFile);
                System.out.println(algo12.printStatistics());
            } else if ("ClaSP".equals(algorithmName)) {
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator_Qualitative abstractionCreator3 = ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator_Qualitative.getInstance();
                IdListCreator idListCreator = IdListCreatorStandard_Map.getInstance();
                ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database.SequenceDatabase(abstractionCreator3, idListCreator);
                double relativeMinSup = sd.loadFile(inputFile, minSupport);
                AlgoClaSP algo13 = new AlgoClaSP(relativeMinSup, abstractionCreator3, true, true);
                algo13.runAlgorithm(sd, true, false, outputFile);
                System.out.println(algo13.printStatistics());
            } else if ("CM-ClaSP".equals(algorithmName)) {
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator_Qualitative abstractionCreator4 = ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator_Qualitative.getInstance();
                IdListCreator idListCreator = IdListCreatorStandard_Map.getInstance();
                ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database.SequenceDatabase(abstractionCreator4, idListCreator);
                double relativeMinSup = sd.loadFile(inputFile, minSupport);
                AlgoCM_ClaSP algo14 = new AlgoCM_ClaSP(relativeMinSup, abstractionCreator4, true, true);
                algo14.runAlgorithm(sd, true, false, outputFile);
                System.out.println(algo14.printStatistics());
            } else if ("PrefixSpan_PostProcessingClosed".equals(algorithmName)) {
                abstractionCreator = ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.AbstractionCreator_Qualitative.getInstance();
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                AlgoCloSpan algo15 = new AlgoCloSpan(minSupport, (ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.AbstractionCreator)abstractionCreator, true, false);
                ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.SequenceDatabase();
                sd.loadFile(inputFile, minSupport);
                algo15.runAlgorithm(sd, true, false, outputFile);
                System.out.println(algo15.printStatistics());
            } else if ("CloSpan".equals(algorithmName)) {
                abstractionCreator = ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.AbstractionCreator_Qualitative.getInstance();
                double minSupport = MainWindow.getParamAsDouble(parameters[0]);
                AlgoCloSpan algo16 = new AlgoCloSpan(minSupport, (ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.AbstractionCreator)abstractionCreator, true, true);
                ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.SequenceDatabase sd = new ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.SequenceDatabase();
                sd.loadFile(inputFile, minSupport);
                algo16.runAlgorithm(sd, true, false, outputFile);
                System.out.println(algo16.printStatistics());
            } else if ("BIDE+".equals(algorithmName)) {
                sequenceDatabase = new ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase();
                ((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase).loadFile(inputFile);
                int minsup = (int)(MainWindow.getParamAsDouble(parameters[0]) * (double)((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase).size());
                AlgoBIDEPlus algo17 = new AlgoBIDEPlus();
                algo17.runAlgorithm((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase, outputFile, minsup);
                algo17.printStatistics(((ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase)sequenceDatabase).size());
            } else if ("BIDE+_with_strings".equals(algorithmName)) {
                sequenceDatabase = new ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase();
                ((ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase)sequenceDatabase).loadFile(inputFile);
                int minsup = (int)(MainWindow.getParamAsDouble(parameters[0]) * (double)((ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase)sequenceDatabase).size());
                AlgoBIDEPlus_withStrings algo18 = new AlgoBIDEPlus_withStrings();
                algo18.runAlgorithm((ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase)sequenceDatabase, outputFile, minsup);
                algo18.printStatistics(((ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase)sequenceDatabase).size());
            } else if ("RuleGrowth".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                AlgoRULEGROWTH algo19 = new AlgoRULEGROWTH();
                algo19.runAlgorithm(minsup, minconf, inputFile, outputFile);
                algo19.printStats();
            } else if ("TRuleGrowth".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                int window = MainWindow.getParamAsInteger(parameters[2]);
                AlgoTRuleGrowth algo20 = new AlgoTRuleGrowth();
                algo20.runAlgorithm(minsup, minconf, inputFile, outputFile, window);
                algo20.printStats();
            } else if ("TRuleGrowth_with_strings".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                int window = MainWindow.getParamAsInteger(parameters[2]);
                AlgoTRuleGrowth_withStrings algo21 = new AlgoTRuleGrowth_withStrings();
                algo21.runAlgorithm(minsup, minconf, inputFile, outputFile, window);
                algo21.printStats();
            } else if ("CMRules".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                AlgoCMRules algo22 = new AlgoCMRules();
                algo22.runAlgorithm(inputFile, outputFile, minsup, minconf);
                algo22.printStats();
            } else if ("CMDeo".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                AlgoCMDeogun algo23 = new AlgoCMDeogun();
                algo23.runAlgorithm(inputFile, outputFile, minsup, minconf);
                algo23.printStats();
            } else if ("RuleGen".equals(algorithmName)) {
                int minsup = MainWindow.getParamAsInteger(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                AlgoRuleGen rulegen = new AlgoRuleGen();
                rulegen.runAlgorithm(minsup, minconf, inputFile, outputFile);
                rulegen.printStats();
            } else if ("TopSeqRules".equals(algorithmName)) {
                int k = MainWindow.getParamAsInteger(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase sequenceDatabase2 = new ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase();
                sequenceDatabase2.loadFile(inputFile);
                AlgoTopSeqRules algo24 = new AlgoTopSeqRules();
                algo24.runAlgorithm(k, sequenceDatabase2, minconf);
                algo24.printStats();
                algo24.writeResultTofile(outputFile);
            } else if ("TKS".equals(algorithmName)) {
                int k = MainWindow.getParamAsInteger(parameters[0]);
                AlgoTKS algo25 = new AlgoTKS();
                algo25.runAlgorithm(inputFile, outputFile, k);
                algo25.writeResultTofile(outputFile);
                algo25.printStatistics();
            } else if ("TSP_nonClosed".equals(algorithmName)) {
                int k = MainWindow.getParamAsInteger(parameters[0]);
                ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase sequenceDatabase3 = new ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase();
                sequenceDatabase3.loadFile(inputFile);
                AlgoTSP_nonClosed algo26 = new AlgoTSP_nonClosed();
                algo26.runAlgorithm(sequenceDatabase3, k);
                algo26.writeResultTofile(outputFile);
                algo26.printStatistics(sequenceDatabase3.size());
            } else if ("TopKRules".equals(algorithmName)) {
                database = new Database();
                ((Database)database).loadFile(inputFile);
                int k = MainWindow.getParamAsInteger(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                AlgoTopKRules algo27 = new AlgoTopKRules();
                algo27.runAlgorithm(k, minconf, (Database)database);
                algo27.printStats();
                algo27.writeResultTofile(outputFile);
            } else if ("TNR".equals(algorithmName)) {
                database = new Database();
                ((Database)database).loadFile(inputFile);
                int k = MainWindow.getParamAsInteger(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                int delta = MainWindow.getParamAsInteger(parameters[2]);
                AlgoTNR algo28 = new AlgoTNR();
                algo28.runAlgorithm(k, minconf, (Database)database, delta);
                algo28.printStats();
                algo28.writeResultTofile(outputFile);
            } else if ("TNS".equals(algorithmName)) {
                database = new ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase();
                ((ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase)database).loadFile(inputFile);
                int k = MainWindow.getParamAsInteger(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                int delta = MainWindow.getParamAsInteger(parameters[2]);
                AlgoTNS algo29 = new AlgoTNS();
                algo29.runAlgorithm(k, (ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase)database, minconf, delta);
                algo29.printStats();
                algo29.writeResultTofile(outputFile);
            } else if ("FPGrowth_itemsets".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoFPGrowth algo30 = new AlgoFPGrowth();
                algo30.runAlgorithm(inputFile, outputFile, minsup);
                algo30.printStats();
            } else if ("FPGrowth_itemsets_with_strings".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoFPGrowth_Strings algo31 = new AlgoFPGrowth_Strings();
                algo31.runAlgorithm(inputFile, outputFile, minsup);
                algo31.printStats();
            } else if ("Apriori_association_rules".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                AlgoApriori apriori = new AlgoApriori();
                ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets patterns = apriori.runAlgorithm(minsup, inputFile, null);
                apriori.printStats();
                int databaseSize = apriori.getDatabaseSize();
                AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
                algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf);
                algoAgrawal.printStats();
            } else if ("Sporadic_association_rules".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double maxsup = MainWindow.getParamAsDouble(parameters[1]);
                double minconf = MainWindow.getParamAsDouble(parameters[2]);
                AlgoAprioriInverse apriori = new AlgoAprioriInverse();
                ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets patterns = apriori.runAlgorithm(minsup, maxsup, inputFile, null);
                apriori.printStats();
                int databaseSize = apriori.getDatabaseSize();
                AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
                algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf);
                algoAgrawal.printStats();
            } else if ("Closed_association_rules".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                TransactionDatabase database3 = new TransactionDatabase();
                try {
                    database3.loadFile(inputFile);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                AlgoAprioriTIDClose aclose = new AlgoAprioriTIDClose();
                Itemsets patterns = aclose.runAlgorithm(database3, minsup, null);
                AlgoClosedRules algoAgrawal = new AlgoClosedRules();
                ClosedRules databaseSize = algoAgrawal.runAlgorithm(patterns, minconf, outputFile);
            } else if ("IGB".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                TransactionDatabase database4 = new TransactionDatabase();
                try {
                    database4.loadFile(inputFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AlgoZart zart = new AlgoZart();
                TZTableClosed results = zart.runAlgorithm(database4, minsup);
                zart.printStatistics();
                AlgoIGB algoIGB = new AlgoIGB();
                algoIGB.runAlgorithm(results, database4.getTransactions().size(), minconf, outputFile);
                algoIGB.printStatistics();
            } else if ("Indirect_association_rules".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double ts = MainWindow.getParamAsDouble(parameters[1]);
                double minconf = MainWindow.getParamAsDouble(parameters[2]);
                AlgoINDIRECT indirect = new AlgoINDIRECT();
                indirect.runAlgorithm(inputFile, outputFile, minsup, ts, minconf);
                indirect.printStats();
            } else if ("MNR".equals(algorithmName)) {
                System.out.println("STEP 1: APPLY ZART TO FIND CLOSED ITEMSETS AND GENERATORS");
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                TransactionDatabase database5 = new TransactionDatabase();
                try {
                    database5.loadFile(inputFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AlgoZart zart = new AlgoZart();
                TZTableClosed results = zart.runAlgorithm(database5, minsup);
                zart.printStatistics();
                System.out.println("STEP 2 : CALCULATING MNR ASSOCIATION RULES");
                AlgoMNRRules algoMNR = new AlgoMNRRules();
                algoMNR.runAlgorithm(outputFile, minconf, results, database5.size());
                algoMNR.printStatistics();
            } else if ("FPGrowth_association_rules".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                AlgoFPGrowth fpgrowth = new AlgoFPGrowth();
                ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets patterns = fpgrowth.runAlgorithm(inputFile, null, minsup);
                fpgrowth.printStats();
                int databaseSize = fpgrowth.getDatabaseSize();
                AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
                algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf);
                algoAgrawal.printStats();
            } else if ("FPGrowth_association_rules_with_lift".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                double minlift = MainWindow.getParamAsDouble(parameters[2]);
                AlgoFPGrowth fpgrowth = new AlgoFPGrowth();
                ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets patterns = fpgrowth.runAlgorithm(inputFile, null, minsup);
                fpgrowth.printStats();
                int databaseSize = fpgrowth.getDatabaseSize();
                AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
                algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf, minlift);
                algoAgrawal.printStats();
            } else if ("CFPGrowth++_association_rules".equals(algorithmName)) {
                misFile = parameters[0];
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                File file = new File(inputFile);
                String misFileFullPath = file.getParent() == null ? misFile : String.valueOf(file.getParent()) + File.separator + misFile;
                AlgoCFPGrowth cfpgrowth = new AlgoCFPGrowth();
                ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets patterns = cfpgrowth.runAlgorithm(inputFile, null, misFileFullPath);
                cfpgrowth.printStats();
                int databaseSize = cfpgrowth.getDatabaseSize();
                AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
                algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf);
                algoAgrawal.printStats();
            } else if ("CFPGrowth++_association_rules_with_lift".equals(algorithmName)) {
                misFile = parameters[0];
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                double minlift = MainWindow.getParamAsDouble(parameters[2]);
                File file = new File(inputFile);
                String misFileFullPath = file.getParent() == null ? misFile : String.valueOf(file.getParent()) + File.separator + misFile;
                AlgoCFPGrowth cfpgrowth = new AlgoCFPGrowth();
                ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets patterns = cfpgrowth.runAlgorithm(inputFile, null, misFileFullPath);
                cfpgrowth.printStats();
                int databaseSize = cfpgrowth.getDatabaseSize();
                AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
                algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf, minlift);
                algoAgrawal.printStats();
            } else if ("Apriori_TID_bitset".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoAprioriTID apriori = new AlgoAprioriTID();
                apriori.runAlgorithm(inputFile, outputFile, minsup);
                apriori.printStats();
            } else if ("Apriori".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoApriori apriori = new AlgoApriori();
                apriori.runAlgorithm(minsup, inputFile, outputFile);
                apriori.printStats();
            } else if ("Apriori_with_hash_tree".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                int branch_count = MainWindow.getParamAsInteger(parameters[1]);
                AlgoAprioriHT apriori = new AlgoAprioriHT();
                apriori.runAlgorithm(minsup, inputFile, outputFile, branch_count);
                apriori.printStats();
            } else if ("AprioriClose".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoAprioriClose apriori = new AlgoAprioriClose();
                apriori.runAlgorithm(minsup, inputFile, outputFile);
                apriori.printStats();
            } else if ("Apriori_TID".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoAprioriTID apriori = new AlgoAprioriTID();
                apriori.runAlgorithm(inputFile, outputFile, minsup);
                apriori.printStats();
            } else if ("Apriori_TIDClose".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                TransactionDatabase database6 = new TransactionDatabase();
                database6.loadFile(inputFile);
                AlgoAprioriTIDClose apriori = new AlgoAprioriTIDClose();
                apriori.runAlgorithm(database6, minsup, outputFile);
                apriori.printStats();
            } else if ("AprioriRare".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoAprioriRare apriori2 = new AlgoAprioriRare();
                apriori2.runAlgorithm(minsup, inputFile, outputFile);
                apriori2.printStats();
            } else if ("AprioriInverse".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double maxsup = MainWindow.getParamAsDouble(parameters[1]);
                AlgoAprioriInverse apriori = new AlgoAprioriInverse();
                apriori.runAlgorithm(minsup, maxsup, inputFile, outputFile);
                apriori.printStats();
            } else if ("MSApriori".equals(algorithmName)) {
                double beta = MainWindow.getParamAsDouble(parameters[0]);
                double ls = MainWindow.getParamAsDouble(parameters[1]);
                AlgoMSApriori apriori = new AlgoMSApriori();
                apriori.runAlgorithm(inputFile, outputFile, beta, ls);
                apriori.printStats();
            } else if ("CFPGrowth++".equals(algorithmName)) {
                misFile = parameters[0];
                File file = new File(inputFile);
                String misFileFullPath = file.getParent() == null ? misFile : String.valueOf(file.getParent()) + File.separator + misFile;
                AlgoCFPGrowth algo32 = new AlgoCFPGrowth();
                algo32.runAlgorithm(inputFile, outputFile, misFileFullPath);
                algo32.printStats();
            } else if ("FHSAR".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                double minconf = MainWindow.getParamAsDouble(parameters[1]);
                String sarFile = parameters[2];
                File file = new File(inputFile);
                String sarFileFullPath = file.getParent() == null ? sarFile : String.valueOf(file.getParent()) + File.separator + sarFile;
                AlgoFHSAR algorithm = new AlgoFHSAR();
                algorithm.runAlgorithm(inputFile, sarFileFullPath, outputFile, minsup, minconf);
                algorithm.printStats();
            } else if ("GoKrimp".equals(algorithmName)) {
                File file;
                String labelFilePath = parameters[0];
                labelFilePath = labelFilePath == null ? "" : ((file = new File(inputFile)).getParent() == null ? parameters[0] : String.valueOf(file.getParent()) + File.separator + parameters[0]);
                DataReader d = new DataReader();
                AlgoGoKrimp g = d.readData_SPMF(inputFile, labelFilePath);
                g.setOutputFilePath(outputFile);
                g.gokrimp();
            } else if ("VME".equals(algorithmName)) {
                double threshold = MainWindow.getParamAsDouble(parameters[0]);
                AlgoVME algo33 = new AlgoVME();
                algo33.runAlgorithm(inputFile, outputFile, threshold);
                algo33.printStats();
            } else if ("KMeans".equals(algorithmName)) {
                int k = MainWindow.getParamAsInteger(parameters[0]);
                AlgoKMeans algoKMeans = new AlgoKMeans();
                algoKMeans.runAlgorithm(inputFile, k);
                algoKMeans.printStatistics();
                algoKMeans.saveToFile(outputFile);
            } else if ("Hierarchical_clustering".equals(algorithmName)) {
                int maxDistance = MainWindow.getParamAsInteger(parameters[0]);
                AlgoHierarchicalClustering algo34 = new AlgoHierarchicalClustering();
                algo34.runAlgorithm(inputFile, maxDistance);
                algo34.printStatistics();
                algo34.saveToFile(outputFile);
            } else if ("UApriori".equals(algorithmName)) {
                double expectedsup = MainWindow.getParamAsDouble(parameters[0]);
                UncertainTransactionDatabase context = new UncertainTransactionDatabase();
                context.loadFile(inputFile);
                AlgoUApriori apriori = new AlgoUApriori(context);
                apriori.runAlgorithm(expectedsup, outputFile);
                apriori.printStats();
            } else if ("HMine".equals(algorithmName)) {
                int minsup = MainWindow.getParamAsInteger(parameters[0]);
                AlgoHMine algorithm = new AlgoHMine();
                algorithm.runAlgorithm(inputFile, outputFile, minsup);
                algorithm.printStatistics();
            } else if ("DCI_Closed".equals(algorithmName)) {
                int minsup = MainWindow.getParamAsInteger(parameters[0]);
                AlgoDCI_Closed_Optimized algorithm = new AlgoDCI_Closed_Optimized();
                algorithm.runAlgorithm(inputFile, outputFile, minsup);
            } else if ("Charm_bitset".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoCharm_Bitset_saveToFile algo35 = new AlgoCharm_Bitset_saveToFile();
                algo35.runAlgorithm(inputFile, outputFile, minsup, 100000);
                algo35.printStats();
            } else if ("Charm_MFI".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                TransactionDatabase database7 = new TransactionDatabase();
                try {
                    database7.loadFile(inputFile);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                AlgoCharm charm = new AlgoCharm();
                charm.runAlgorithm(null, database7, 100000, minsup, false);
                AlgoCharmMFI charmMFI = new AlgoCharmMFI();
                charmMFI.runAlgorithm(outputFile, charm.getClosedItemsets());
                charmMFI.printStats(database7.size());
            } else if ("Charm".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                TransactionDatabase database8 = new TransactionDatabase();
                try {
                    database8.loadFile(inputFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                AlgoCharm algo36 = new AlgoCharm();
                algo36.runAlgorithm(outputFile, database8, 100000, minsup, false);
                algo36.printStats();
            } else if ("Eclat".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                TransactionDatabase database9 = new TransactionDatabase();
                try {
                    database9.loadFile(inputFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                AlgoEclat algo37 = new AlgoEclat();
                algo37.runAlgorithm(outputFile, database9, minsup, false);
                algo37.printStats();
            } else if ("Relim".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoRelim algo38 = new AlgoRelim();
                algo38.runAlgorithm(minsup, inputFile, outputFile);
                algo38.printStatistics();
            } else if ("Eclat_bitset".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoEclat_Bitset_saveToFile algo39 = new AlgoEclat_Bitset_saveToFile();
                algo39.runAlgorithm(inputFile, outputFile, minsup);
                algo39.printStats();
            } else if ("Two-Phase".equals(algorithmName)) {
                int minutil = MainWindow.getParamAsInteger(parameters[0]);
                UtilityTransactionDatabaseTP database10 = new UtilityTransactionDatabaseTP();
                database10.loadFile(inputFile);
                AlgoTwoPhase twoPhase = new AlgoTwoPhase();
                ItemsetsTP highUtilityItemsets = twoPhase.runAlgorithm(database10, minutil);
                highUtilityItemsets.saveResultsToFile(outputFile, database10.getTransactions().size());
                twoPhase.printStats();
            } else if ("HUI-Miner".equals(algorithmName)) {
                int minutil = MainWindow.getParamAsInteger(parameters[0]);
                AlgoHUIMiner huiminer = new AlgoHUIMiner();
                huiminer.runAlgorithm(inputFile, outputFile, minutil);
                huiminer.printStats();
            } else if ("FHM".equals(algorithmName)) {
                int minutil = MainWindow.getParamAsInteger(parameters[0]);
                AlgoFHM fhm = new AlgoFHM();
                fhm.runAlgorithm(inputFile, outputFile, minutil);
                fhm.printStats();
            } else if ("Zart".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                TransactionDatabase context = new TransactionDatabase();
                context.loadFile(inputFile);
                AlgoZart zart = new AlgoZart();
                TZTableClosed results = zart.runAlgorithm(context, minsup);
                TFTableFrequent frequents = zart.getTableFrequent();
                zart.printStatistics();
                zart.saveResultsToFile(outputFile);
            } else if ("Pascal".equals(algorithmName)) {
                double minsup = MainWindow.getParamAsDouble(parameters[0]);
                AlgoPASCAL algo40 = new AlgoPASCAL();
                algo40.runAlgorithm(minsup, inputFile, outputFile);
                algo40.printStats();
            } else if ("Convert_a_sequence_database_to_SPMF_format".equals(algorithmName)) {
                format = MainWindow.getParamAsString(parameters[0]);
                int seqCount = MainWindow.getParamAsInteger(parameters[1]);
                long startTime = System.currentTimeMillis();
                SequenceDatabaseConverter converter = new SequenceDatabaseConverter();
                converter.convert(inputFile, outputFile, Formats.valueOf(format), seqCount);
                long endTIme = System.currentTimeMillis();
                System.out.println("Sequence database converted.  Time spent for conversion = " + (endTIme - startTime) + " ms.");
            } else if ("Convert_a_transaction_database_to_SPMF_format".equals(algorithmName)) {
                format = MainWindow.getParamAsString(parameters[0]);
                int transactionCount = MainWindow.getParamAsInteger(parameters[1]);
                long startTime = System.currentTimeMillis();
                TransactionDatabaseConverter converter = new TransactionDatabaseConverter();
                converter.convert(inputFile, outputFile, Formats.valueOf(format), transactionCount);
                long endTIme = System.currentTimeMillis();
                System.out.println("Transaction database converted.  Time spent for conversion = " + (endTIme - startTime) + " ms.");
            } else if ("Generate_a_sequence_database".equals(algorithmName)) {
                int p1 = MainWindow.getParamAsInteger(parameters[0]);
                int p2 = MainWindow.getParamAsInteger(parameters[1]);
                int p3 = MainWindow.getParamAsInteger(parameters[2]);
                int p4 = MainWindow.getParamAsInteger(parameters[3]);
                SequenceDatabaseGenerator generator = new SequenceDatabaseGenerator();
                generator.generateDatabase(p1, p2, p3, p4, outputFile, false);
                System.out.println("Sequence database generated.  ");
            } else if ("Generate_a_sequence_database_with_timestamps".equals(algorithmName)) {
                int p1 = MainWindow.getParamAsInteger(parameters[0]);
                int p2 = MainWindow.getParamAsInteger(parameters[1]);
                int p3 = MainWindow.getParamAsInteger(parameters[2]);
                int p4 = MainWindow.getParamAsInteger(parameters[3]);
                SequenceDatabaseGenerator generator = new SequenceDatabaseGenerator();
                generator.generateDatabase(p1, p2, p3, p4, outputFile, true);
                System.out.println("Sequence database generated.  ");
            } else if ("Generate_a_transaction_database".equals(algorithmName)) {
                int p1 = MainWindow.getParamAsInteger(parameters[0]);
                int p2 = MainWindow.getParamAsInteger(parameters[1]);
                int p3 = MainWindow.getParamAsInteger(parameters[2]);
                TransactionDatabaseGenerator generator = new TransactionDatabaseGenerator();
                generator.generateDatabase(p1, p2, p3, outputFile);
                System.out.println("Transaction database generated.  ");
            } else if ("Calculate_stats_for_a_sequence_database".equals(algorithmName)) {
                try {
                    sequenceDatabase = new SequenceStatsGenerator();
                    ((SequenceStatsGenerator)sequenceDatabase).getStats(inputFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (mapItemAttributeValue != null) {
                ResultConverter converter = new ResultConverter();
                System.out.println("Post-processing to show result in terms of ARFF attribute values.");
                converter.convert(mapItemAttributeValue, outputFile, originalOutputFile);
                System.out.println("Post-processing completed.");
                File file = new File(outputFile);
                file.delete();
                File file2 = new File(inputFile);
                file2.delete();
                outputFile = originalOutputFile;
                inputFile = originalInputFile;
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Error. Please check the parameters of the algorithm.  The format for numbers is incorrect. \n\n ERROR MESSAGE = " + e.toString(), "Error", 0);
            return false;
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, "An error while trying to run the algorithm. \n ERROR MESSAGE = " + e.toString(), "Error", 0);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void processCommandLineArguments(String[] args) {
        if ("version".equals(args[0])) {
            System.out.println(" \n-- SPMF version " + SPMF_VERSION + " --\n");
        } else if ("help".equals(args[0])) {
            System.out.println("\n\nFor help, please check the documentation section of the SPMF website: http://philippe-fournier-viger.com/spmf/ \n\n");
        } else if ("run".equals(args[0])) {
            String algoName = args[1];
            String input = args[2];
            String output = args[3];
            String[] parameters = new String[args.length - 4];
            if (args.length > 4) {
                System.arraycopy(args, 4, parameters, 0, args.length - 4);
            }
            MainWindow.runAlgorithm(algoName, input, output, parameters);
        } else if ("test".equals(args[0])) {
            String testName = args[1];
            try {
                Class<?> testClass = Class.forName("ca.pfv.spmf.tests." + testName);
                Method mainMethod = testClass.getMethod("main", String[].class);
                Object params = null;
                mainMethod.invoke(null, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\n\n Command not recognized.\n For help, please check the documentation section of the SPMF website: http://philippe-fournier-viger.com/spmf/ \n \n");
        }
    }

    private void openHelpWebPageForAlgorithm(String choice) {
        if ("PrefixSpan".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#examplePrefixSpan");
        } else if ("HirateYamana".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example11");
        } else if ("PrefixSpan_with_strings".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#examplePrefixSpan");
        } else if ("SeqDim_(PrefixSpan+Apriori)".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#exampleMDSPM1");
        } else if ("SeqDim_(BIDE+AprioriClose)".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#exampleMDSPM1");
        } else if ("SeqDim_(BIDE+Charm)".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#exampleMDSPM1");
        } else if ("SeqDim_(PrefixSpan+Apriori)+time".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example14");
        } else if ("SeqDim_(BIDE+AprioriClose)+time".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example14");
        } else if ("SeqDim_(BIDE+Charm)+time".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example14");
        } else if ("SPAM".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#spam");
        } else if ("BIDE+".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#exampleBIDE");
        } else if ("BIDE+_with_strings".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#exampleBIDE");
        } else if ("RuleGrowth".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#rulegrowth");
        } else if ("TRuleGrowth".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#trulegrowth");
        } else if ("TRuleGrowth_with_strings".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#trulegrowth");
        } else if ("CMRules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cmrules");
        } else if ("CMDeo".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cmdeo");
        } else if ("Sporadic_association_rules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example19");
        } else if ("Closed_association_rules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example20");
        } else if ("IGB".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example7");
        } else if ("MNR".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example21");
        } else if ("Indirect_association_rules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#indirect");
        } else if ("RuleGen".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#rulegen");
        } else if ("TopSeqRules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#topseqrules");
        } else if ("TopKRules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#topkrules");
        } else if ("TNR".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#tnr");
        } else if ("FPGrowth_itemsets".equals(choice) || "FPGrowth_itemsets_with_strings".equals("choice")) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#growth");
        } else if ("Apriori_association_rules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#allassociationrules");
        } else if ("FPGrowth_association_rules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#allassociationrules");
        } else if ("FPGrowth_association_rules_with_lift".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#lift");
        } else if ("CFPGrowth++_association_rules".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cfpgrowth_ar");
        } else if ("CFPGrowth++_association_rules_with_lift".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cfpgrowth_ar");
        } else if ("Apriori".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example1");
        } else if ("Apriori_with_hash_tree".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example1");
        } else if ("AprioriClose".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example2");
        } else if ("Apriori_TID".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example2");
        } else if ("Apriori_TIDClose".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example2");
        } else if ("AprioriRare".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example17");
        } else if ("AprioriInverse".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example18");
        } else if ("VME".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#erasable");
        } else if ("UApriori".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#uapriori");
        } else if ("MSApriori".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#msapriori");
        } else if ("CFPGrowth++".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cfpgrowth");
        } else if ("Apriori_TID_bitset".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#aprioritid");
        } else if ("HMine".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#hmine");
        } else if ("DCI_Closed".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#dciclosed");
        } else if ("Charm".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#e2");
        } else if ("Charm_MFI".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#e3");
        } else if ("Charm_bitset".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#e2");
        } else if ("Eclat".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#e1");
        } else if ("Eclat_bitset".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#e1");
        } else if ("Relim".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#c23");
        } else if ("Zart".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#zart");
        } else if ("Pascal".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#pascal");
        } else if ("Two-Phase".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#twophase");
        } else if ("HUI-Miner".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#huiminer");
        } else if ("FHM".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#fhm");
        } else if ("FHSAR".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#FHSAR");
        } else if ("KMeans".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example8");
        } else if ("Hierarchical_clustering".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example10");
        } else if ("Convert_a_sequence_database_to_SPMF_format".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#convseq");
        } else if ("Convert_a_transaction_database_to_SPMF_format".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#convtdb");
        } else if ("Generate_a_sequence_database".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#genseq");
        } else if ("Generate_a_sequence_database_with_timestamps".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#genseqt");
        } else if ("Generate_a_transaction_database".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#gentrans");
        } else if ("Calculate_stats_for_a_sequence_database".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#statsseq");
        } else if ("TNS".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#tns");
        } else if ("TNR".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#tnr");
        } else if ("CM-SPAM".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cmspam");
        } else if ("CM-SPADE".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cmspade");
        } else if ("CM-ClaSP".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cmclasp");
        } else if ("MaxSP".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#maxsp");
        } else if ("VMSP".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#vmsp");
        } else if ("TKS".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#tks");
        } else if ("TSP_nonClosed".equals(choice)) {
            this.openWebPage("http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#tsp");
        }
    }

    private void askUserToChooseInputFile() {
        try {
            URL main;
            String previousPath = PathsManager.getInstance().getInputFilePath();
            Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
            JFileChooser fc = new JFileChooser((File)path);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.textFieldInput.setText(file.getName());
                this.inputFile = file.getPath();
            }
            if (fc.getSelectedFile() != null) {
                PathsManager.getInstance().setInputFilePath(fc.getSelectedFile().getParent());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while opening the input file dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    private void askUserToChooseOutputFile() {
        try {
            URL main;
            String previousPath = PathsManager.getInstance().getOutputFilePath();
            Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
            JFileChooser fc = path != null ? new JFileChooser(((File)path).getAbsolutePath()) : new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.textFieldOutput.setText(file.getName());
                this.outputFile = file.getPath();
                if (fc.getSelectedFile() != null) {
                    PathsManager.getInstance().setOutputFilePath(fc.getSelectedFile().getParent());
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while opening the output file dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    private void processRunAlgorithmCommandFromGUI() {
        Desktop desktop;
        String choice = (String)this.comboBox.getSelectedItem();
        String[] parameters = new String[]{this.textFieldParam1.getText(), this.textFieldParam2.getText(), this.textFieldParam3.getText(), this.textFieldParam4.getText(), this.textFieldParam5.getText(), this.textFieldParam6.getText()};
        this.textArea.setText("");
        boolean succeed = MainWindow.runAlgorithm(choice, this.inputFile, this.outputFile, parameters);
        if (succeed && this.checkboxOpenOutput.isSelected() && this.lblSetOutputFile.isVisible() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
            try {
                desktop.open(new File(this.outputFile));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "The output file failed to open with the default application. \n This error occurs if there is no default application on your system for opening the output file or the application failed to start. \n\nTo fix the problem, consider changing the extension of the output file to .txt.\n\n ERROR MESSAGE = " + e.toString(), "Error", 0);
            }
            catch (SecurityException e) {
                JOptionPane.showMessageDialog(null, "A security error occured while trying to open the output file. ERROR MESSAGE = " + e.toString(), "Error", 0);
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(null, "An error occured while opening the output file. ERROR MESSAGE = " + e.toString(), "Error", 0);
            }
        }
    }

    private static class SwingAction
    extends AbstractAction {
        public SwingAction() {
            this.putValue("Name", "SwingAction");
            this.putValue("ShortDescription", "Some short description");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    static class TextAreaOutputStream
    extends OutputStream {
        JTextArea textArea;

        public TextAreaOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void flush() {
            this.textArea.repaint();
        }

        @Override
        public void write(int b) {
            this.textArea.append(new String(new byte[]{(byte)b}));
        }
    }
}

