/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.datastructures.kdtree;

import ca.pfv.spmf.datastructures.kdtree.KDNode;
import ca.pfv.spmf.datastructures.kdtree.KNNPoint;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import java.util.Random;

public class KDTree {
    private int nodeCount = 0;
    private KDNode root = null;
    int dimensionCount = 0;
    private static Random random = new Random(System.currentTimeMillis());
    double[] nearestNeighboor = null;
    double minDist = 0.0;
    RedBlackTree<KNNPoint> resultKNN = null;
    int k = 0;

    public int size() {
        return this.nodeCount;
    }

    public void buildtree(double[][] points) {
        if (points.length == 0) {
            return;
        }
        this.dimensionCount = points[0].length;
        this.root = this.generateNode(0, points, 0, points.length - 1);
    }

    private KDNode generateNode(int currentD, double[][] points, int left, int right) {
        if (right < left) {
            return null;
        }
        ++this.nodeCount;
        if (right == left) {
            return new KDNode(points[left], currentD);
        }
        int m = (right - left) / 2;
        double[] medianNode = this.randomizedSelect(points, m, left, right, currentD);
        KDNode node = new KDNode(medianNode, currentD);
        if (++currentD == this.dimensionCount) {
            currentD = 0;
        }
        node.below = this.generateNode(currentD, points, left, left + m - 1);
        node.above = this.generateNode(currentD, points, left + m + 1, right);
        return node;
    }

    private double[] randomizedSelect(double[][] points, int i, int left, int right, int currentD) {
        int p = left;
        int r = right;
        while (p != r) {
            int q = this.randomizedPartition(points, p, r, currentD);
            int k = q - p + 1;
            if (i == k - 1) {
                return points[q];
            }
            if (i < k) {
                r = q - 1;
                continue;
            }
            i -= k;
            p = q + 1;
        }
        return points[p];
    }

    private int randomizedPartition(double[][] points, int p, int r, int currentD) {
        int i = 0;
        i = p < r ? p + random.nextInt(r - p) : r + random.nextInt(p - r);
        this.swap(points, r, i);
        return this.partition(points, p, r, currentD);
    }

    private int partition(double[][] points, int p, int r, int currentD) {
        double[] x = points[r];
        int i = p - 1;
        int j = p;
        while (j <= r - 1) {
            if (points[j][currentD] <= x[currentD]) {
                this.swap(points, ++i, j);
            }
            ++j;
        }
        this.swap(points, i + 1, r);
        return i + 1;
    }

    private void swap(double[][] array, int i, int j) {
        double[] valueI = array[i];
        array[i] = array[j];
        array[j] = valueI;
    }

    public double[] nearest(double[] targetPoint) {
        if (this.root == null) {
            return null;
        }
        this.findParent(targetPoint, this.root, 0);
        this.nearest(this.root, targetPoint);
        return this.nearestNeighboor;
    }

    private void findParent(double[] target, KDNode node, int d) {
        if (target[d] < node.values[d]) {
            if (++d == this.dimensionCount) {
                d = 0;
            }
            if (node.below == null) {
                this.nearestNeighboor = node.values;
                this.minDist = this.distance(node.values, target);
                return;
            }
            this.findParent(target, node.below, d);
        }
        if (++d == this.dimensionCount) {
            d = 0;
        }
        if (node.above == null) {
            this.nearestNeighboor = node.values;
            this.minDist = this.distance(node.values, target);
            return;
        }
        this.findParent(target, node.above, d);
    }

    private void nearest(KDNode node, double[] targetPoint) {
        double perpendicularyDistance;
        int dMinus1;
        double d = this.distance(node.values, targetPoint);
        if (d < this.minDist) {
            this.minDist = d;
            this.nearestNeighboor = node.values;
        }
        if ((dMinus1 = node.d - 1) < 0) {
            dMinus1 = this.dimensionCount - 1;
        }
        if ((perpendicularyDistance = Math.abs(node.values[node.d] - targetPoint[dMinus1])) < this.minDist) {
            if (node.above != null) {
                this.nearest(node.above, targetPoint);
            }
            if (node.below != null) {
                this.nearest(node.below, targetPoint);
            }
        } else if (targetPoint[dMinus1] < node.values[node.d]) {
            if (node.below != null) {
                this.nearest(node.below, targetPoint);
            }
        } else if (node.above != null) {
            this.nearest(node.above, targetPoint);
        }
    }

    private double distance(double[] node1, double[] node2) {
        double sum = 0.0;
        int i = 0;
        while (i < node1.length) {
            sum += Math.pow(node1[i] - node2[i], 2.0);
            ++i;
        }
        return Math.sqrt(sum);
    }

    public RedBlackTree<KNNPoint> knearest(double[] targetPoint, int k) {
        this.k = k;
        this.resultKNN = new RedBlackTree();
        if (this.root == null) {
            return null;
        }
        this.findParent_knn(targetPoint, this.root, 0);
        this.nearest_knn(this.root, targetPoint);
        return this.resultKNN;
    }

    private void findParent_knn(double[] target, KDNode node, int d) {
        if (target[d] < node.values[d]) {
            if (++d == this.dimensionCount) {
                d = 0;
            }
            if (node.below == null) {
                this.tryToSave(node, target);
                return;
            }
            this.tryToSave(node.below, target);
            this.findParent_knn(target, node.below, d);
        }
        if (++d == this.dimensionCount) {
            d = 0;
        }
        if (node.above == null) {
            this.tryToSave(node, target);
            return;
        }
        this.tryToSave(node.above, target);
        this.findParent_knn(target, node.above, d);
    }

    private void tryToSave(KDNode node, double[] target) {
        if (node == null) {
            return;
        }
        double distance = this.distance(target, node.values);
        if (this.resultKNN.size() == this.k && this.resultKNN.maximum().distance < distance) {
            return;
        }
        KNNPoint point = new KNNPoint(node.values, distance);
        if (this.resultKNN.contains(point)) {
            return;
        }
        this.resultKNN.add(point);
        if (this.resultKNN.size() > this.k) {
            this.resultKNN.popMaximum();
        }
    }

    private void nearest_knn(KDNode node, double[] targetPoint) {
        double perpendicularDistance;
        this.tryToSave(node, targetPoint);
        int dMinus1 = node.d - 1;
        if (dMinus1 < 0) {
            dMinus1 = this.dimensionCount - 1;
        }
        if ((perpendicularDistance = Math.abs(node.values[node.d] - targetPoint[dMinus1])) < this.resultKNN.maximum().distance) {
            if (node.above != null) {
                this.nearest_knn(node.above, targetPoint);
            }
            if (node.below != null) {
                this.nearest_knn(node.below, targetPoint);
            }
        } else if (targetPoint[dMinus1] < node.values[node.d]) {
            if (node.below != null) {
                this.nearest_knn(node.below, targetPoint);
            }
        } else if (node.above != null) {
            this.nearest_knn(node.above, targetPoint);
        }
    }

    private String toString(double[] values) {
        StringBuffer buffer = new StringBuffer();
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Double element = dArray[n2];
            buffer.append(" " + element);
            ++n2;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.toString(this.root, " ");
    }

    private String toString(KDNode node, String indent) {
        if (node == null) {
            return "";
        }
        String newIndent1 = String.valueOf(indent) + "   |";
        String newIndent2 = String.valueOf(indent) + "   |";
        return String.valueOf(this.toString(node.values)) + " (" + node.d + ") \n" + indent + this.toString(node.above, newIndent1) + "\n" + indent + this.toString(node.below, newIndent2);
    }
}

