/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sort;

public class Sort {
    public static void insertionSort(int[] a) {
        int j = 1;
        while (j < a.length) {
            int key = a[j];
            int i = j - 1;
            while (i >= 0 && a[i] > key) {
                a[i + 1] = a[i];
                --i;
            }
            a[i + 1] = key;
            ++j;
        }
    }

    public static void mergeSort(int[] a) {
        Sort.mergeSort(a, 0, a.length - 1);
    }

    private static void mergeSort(int[] a, int p, int r) {
        if (p < r) {
            int q = (p + r) / 2;
            Sort.mergeSort(a, p, q);
            Sort.mergeSort(a, q + 1, r);
            Sort.merge(a, p, q, r);
        }
    }

    private static void merge(int[] a, int p, int q, int r) {
        int n1 = q - p + 1;
        int n2 = r - q;
        int[] tabL = new int[n1 + 1];
        int[] tabR = new int[n2 + 1];
        int i = 0;
        while (i < n1) {
            tabL[i] = a[p + i];
            ++i;
        }
        int j = 0;
        while (j < n2) {
            tabR[j] = a[q + j + 1];
            ++j;
        }
        tabL[n1] = Integer.MAX_VALUE;
        tabR[n2] = Integer.MAX_VALUE;
        i = 0;
        int j2 = 0;
        int k = p;
        while (k < r + 1) {
            a[k] = tabL[i] <= tabR[j2] ? tabL[i++] : tabR[j2++];
            ++k;
        }
    }

    public static void bubbleSort(int[] a) {
        int i = 0;
        while (i < a.length) {
            int j = a.length - 1;
            while (j >= i + 1) {
                if (a[j] < a[j - 1]) {
                    int temp = a[j];
                    a[j] = a[j - 1];
                    a[j - 1] = temp;
                }
                --j;
            }
            ++i;
        }
    }

    public static void quicksort(int[] a) {
        Sort.quicksort(a, 0, a.length - 1);
    }

    private static void quicksort(int[] a, int p, int r) {
        if (p < r) {
            int q = Sort.partition(a, p, r);
            Sort.quicksort(a, p, q - 1);
            Sort.quicksort(a, q + 1, r);
        }
    }

    static int partition(int[] a, int p, int r) {
        int x = a[r];
        int i = p - 1;
        int j = p;
        while (j <= r - 1) {
            if (a[j] <= x) {
                Sort.swap(a, ++i, j);
            }
            ++j;
        }
        Sort.swap(a, i + 1, r);
        return i + 1;
    }

    private static void swap(int[] array, int i, int j) {
        int valueI = array[i];
        array[i] = array[j];
        array[j] = valueI;
    }
}

