/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import java.util.ArrayList;
import java.util.List;

class Prefix {
    final List<Itemset> itemsets = new ArrayList<Itemset>();

    public void addItemset(Itemset itemset) {
        this.itemsets.add(itemset);
    }

    public Prefix cloneSequence() {
        Prefix sequence = new Prefix();
        for (Itemset itemset : this.itemsets) {
            sequence.addItemset(itemset.cloneItemSet());
        }
        return sequence;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuffer r = new StringBuffer("");
        for (Itemset itemset : this.itemsets) {
            r.append('(');
            for (Integer item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append(')');
        }
        return r.append("    ").toString();
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    public Itemset get(int index) {
        return this.itemsets.get(index);
    }

    public Integer getIthItem(int i) {
        int j = 0;
        while (j < this.itemsets.size()) {
            if (i < this.itemsets.get(j).size()) {
                return this.itemsets.get(j).get(i);
            }
            i -= this.itemsets.get(j).size();
            ++j;
        }
        return null;
    }

    public int size() {
        return this.itemsets.size();
    }

    public int getItemOccurencesTotalCount() {
        int count = 0;
        for (Itemset itemset : this.itemsets) {
            count += itemset.size();
        }
        return count;
    }

    public boolean containsItem(Integer item) {
        for (Itemset itemset : this.itemsets) {
            if (!itemset.getItems().contains(item)) continue;
            return true;
        }
        return false;
    }
}

