/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.EquivalenceClass;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.FrequentPatternEnumeration;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.FrequentPatternEnumerationFacade;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.candidatePatternsGeneration.CandidateGenerator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.Saver;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.SaverIntoFile;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.SaverIntoMemory;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AlgoCMSPADE {
    private int intersectionCounter = 0;
    protected double minSupRelative;
    public double minSupAbsolute;
    protected boolean dfs;
    Saver saver = null;
    public long start;
    public long end;
    protected List<EquivalenceClass> frequentItems;
    private AbstractionCreator abstractionCreator;
    private int numberOfFrequentPatterns;

    public AlgoCMSPADE(double support, boolean dfs, AbstractionCreator abstractionCreator) {
        this.minSupRelative = support;
        this.abstractionCreator = abstractionCreator;
        this.dfs = dfs;
    }

    public void runAlgorithm(SequenceDatabase database, CandidateGenerator candidateGenerator, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.saver = outputFilePath == null ? new SaverIntoMemory() : new SaverIntoFile(outputFilePath);
        this.minSupAbsolute = (int)Math.ceil(this.minSupRelative * (double)database.size());
        if (this.minSupAbsolute == 0.0) {
            this.minSupAbsolute = 1.0;
        }
        MemoryLogger.getInstance().reset();
        this.start = System.currentTimeMillis();
        this.runSPADE(database, candidateGenerator, (long)this.minSupAbsolute, this.dfs, keepPatterns, verbose);
        this.end = System.currentTimeMillis();
        this.saver.finish();
    }

    public void runAlgorithmParallelized(SequenceDatabase database, CandidateGenerator candidateGenerator, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.saver = outputFilePath == null ? new SaverIntoMemory() : new SaverIntoFile(outputFilePath);
        this.minSupAbsolute = (int)Math.ceil(this.minSupRelative * (double)database.size());
        if (this.minSupAbsolute == 0.0) {
            this.minSupAbsolute = 1.0;
        }
        MemoryLogger.getInstance().reset();
        System.out.println("=====" + this.minSupAbsolute);
        this.start = System.currentTimeMillis();
        this.runSPADEFromSize2PatternsParallelized2(database, candidateGenerator, (long)this.minSupAbsolute, this.dfs, keepPatterns, verbose);
        this.end = System.currentTimeMillis();
        this.saver.finish();
    }

    protected void runSPADE(SequenceDatabase database, CandidateGenerator candidateGenerator, long minSupportCount, boolean dfs, boolean keepPatterns, boolean verbose) {
        this.frequentItems = database.frequentItems();
        Collection<Pattern> size1sequences = this.getPatterns(this.frequentItems);
        if (keepPatterns) {
            for (Pattern atom : size1sequences) {
                this.saver.savePattern(atom);
            }
        }
        HashMap<Integer, Map<Integer, Integer>> coocMapAfter = new HashMap<Integer, Map<Integer, Integer>>(1000);
        HashMap<Integer, Map<Integer, Integer>> coocMapEquals = new HashMap<Integer, Map<Integer, Integer>>(1000);
        for (Sequence seq : database.getSequences()) {
            HashSet<Integer> alreadySeenA = new HashSet<Integer>();
            HashMap alreadySeenB_equals = new HashMap();
            int i = 0;
            while (i < seq.getItemsets().size()) {
                Itemset itemsetA = seq.get(i);
                int j = 0;
                while (j < itemsetA.size()) {
                    Integer itemA = (Integer)itemsetA.get(j).getId();
                    boolean alreadyDoneForItemA = false;
                    HashSet<Integer> equalSet = (HashSet<Integer>)alreadySeenB_equals.get(itemA);
                    if (equalSet == null) {
                        equalSet = new HashSet<Integer>();
                        alreadySeenB_equals.put(itemA, equalSet);
                    }
                    if (alreadySeenA.contains(itemA)) {
                        alreadyDoneForItemA = true;
                    }
                    HashMap<Integer, Integer> mapCoocItemEquals = (HashMap<Integer, Integer>)coocMapEquals.get(itemA);
                    HashMap<Integer, Integer> mapCoocItemAfter = null;
                    if (!alreadyDoneForItemA) {
                        mapCoocItemAfter = (HashMap<Integer, Integer>)coocMapAfter.get(itemA);
                    }
                    int k = j + 1;
                    while (k < itemsetA.size()) {
                        Integer itemB = (Integer)itemsetA.get(k).getId();
                        if (!equalSet.contains(itemB)) {
                            Integer frequency;
                            if (mapCoocItemEquals == null) {
                                mapCoocItemEquals = new HashMap<Integer, Integer>();
                                coocMapEquals.put(itemA, mapCoocItemEquals);
                            }
                            if ((frequency = (Integer)mapCoocItemEquals.get(itemB)) == null) {
                                mapCoocItemEquals.put(itemB, 1);
                            } else {
                                mapCoocItemEquals.put(itemB, frequency + 1);
                            }
                            equalSet.add(itemB);
                        }
                        ++k;
                    }
                    HashSet<Integer> alreadySeenB_after = new HashSet<Integer>();
                    if (!alreadyDoneForItemA) {
                        int k2 = i + 1;
                        while (k2 < seq.getItemsets().size()) {
                            Itemset itemsetB = seq.get(k2);
                            int m = 0;
                            while (m < itemsetB.size()) {
                                Integer itemB = (Integer)itemsetB.get(m).getId();
                                if (!alreadySeenB_after.contains(itemB)) {
                                    Integer frequency;
                                    if (mapCoocItemAfter == null) {
                                        mapCoocItemAfter = new HashMap<Integer, Integer>();
                                        coocMapAfter.put(itemA, mapCoocItemAfter);
                                    }
                                    if ((frequency = (Integer)mapCoocItemAfter.get(itemB)) == null) {
                                        mapCoocItemAfter.put(itemB, 1);
                                    } else {
                                        mapCoocItemAfter.put(itemB, frequency + 1);
                                    }
                                    alreadySeenB_after.add(itemB);
                                }
                                ++m;
                            }
                            ++k2;
                        }
                        alreadySeenA.add(itemA);
                    }
                    ++j;
                }
                ++i;
            }
        }
        database = null;
        EquivalenceClass rootClass = new EquivalenceClass(null);
        for (EquivalenceClass atom : this.frequentItems) {
            rootClass.addClassMember(atom);
        }
        FrequentPatternEnumeration frequentPatternEnumeration = new FrequentPatternEnumeration(candidateGenerator, this.minSupAbsolute, this.saver);
        frequentPatternEnumeration.setFrequentPatterns(this.frequentItems.size());
        frequentPatternEnumeration.execute(rootClass, dfs, keepPatterns, verbose, coocMapAfter, coocMapEquals);
        this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
        this.intersectionCounter = FrequentPatternEnumeration.INTERSECTION_COUNTER;
        MemoryLogger.getInstance().checkMemory();
    }

    private Collection<Pattern> getPatterns(List<EquivalenceClass> equivalenceClasses) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (EquivalenceClass equivalenceClass : equivalenceClasses) {
            Pattern frequentPattern = equivalenceClass.getClassIdentifier();
            patterns.add(frequentPattern);
        }
        return patterns;
    }

    public String printStatistics() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("=============  CM-SPADE -- Algorithm - STATISTICS =============\n Total time ~ ");
        sb.append(this.getRunningTime());
        sb.append(" ms\n");
        sb.append(" Frequent sequences count : ");
        sb.append(this.numberOfFrequentPatterns);
        sb.append('\n');
        sb.append(" Join count : ");
        sb.append(this.intersectionCounter);
        sb.append('\n');
        sb.append(" Max memory (mb):");
        sb.append(MemoryLogger.getInstance().getMaxMemory());
        sb.append('\n');
        sb.append(this.saver.print());
        sb.append("\n===================================================\n");
        return sb.toString();
    }

    public int getIntersectionCounter() {
        return this.intersectionCounter;
    }

    public int getNumberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public long getRunningTime() {
        return this.end - this.start;
    }

    public double getAbsoluteMinimumSupport() {
        return this.minSupAbsolute;
    }

    public void clear() {
        this.frequentItems.clear();
        this.abstractionCreator = null;
        if (this.saver != null) {
            this.saver.clear();
            this.saver = null;
        }
    }

    protected void runSPADEFromSize2PatternsParallelized(SequenceDatabase database, CandidateGenerator candidateGenerator, long minSupportCount, boolean dfs, boolean keepPatterns, boolean verbose) {
        Future future;
        this.frequentItems = database.frequentItems();
        Collection<Pattern> size1Patterns = this.getPatterns(this.frequentItems);
        this.saver.savePatterns(size1Patterns);
        List<EquivalenceClass> size2EquivalenceClass = database.getSize2FrecuentSequences(this.minSupAbsolute);
        Collection<Pattern> size2Sequences = this.getPatterns(size2EquivalenceClass);
        this.saver.savePatterns(size2Sequences);
        size2EquivalenceClass = null;
        database = null;
        FrequentPatternEnumeration frequentPatternEnumeration = new FrequentPatternEnumeration(candidateGenerator, this.minSupAbsolute, this.saver);
        frequentPatternEnumeration.setFrequentPatterns(size1Patterns.size() + size2Sequences.size());
        size1Patterns = null;
        size2Sequences = null;
        Runtime runtime = Runtime.getRuntime();
        int numberOfAvailableProcessors = runtime.availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(numberOfAvailableProcessors);
        ArrayList<Future> set = new ArrayList<Future>();
        while (this.frequentItems.size() > 0) {
            EquivalenceClass frequentItem = this.frequentItems.get(this.frequentItems.size() - 1);
            if (verbose) {
                System.out.println("Exploring " + frequentItem);
            }
            FrequentPatternEnumerationFacade callable = new FrequentPatternEnumerationFacade(frequentPatternEnumeration, frequentItem, dfs, keepPatterns, verbose, this.saver);
            future = pool.submit(callable);
            set.add(future);
            this.frequentItems.remove(this.frequentItems.size() - 1);
            MemoryLogger.getInstance().checkMemory();
        }
        try {
            int cont = 1;
            System.err.println("There are " + set.size() + " equivalence classes and " + numberOfAvailableProcessors + " available processors");
            while (!set.isEmpty()) {
                int i = 0;
                while (i < set.size()) {
                    future = (Future)set.get(i);
                    if (future.isDone()) {
                        System.err.println(String.valueOf(cont++) + ":this thread is done.");
                        set.remove(i);
                        --i;
                    }
                    ++i;
                }
            }
            this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
            MemoryLogger.getInstance().checkMemory();
            pool.shutdown();
            pool.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (Exception e) {
            System.err.println("Problems with the concurrency!!");
            e.printStackTrace();
        }
    }

    protected void runSPADEFromSize2PatternsParallelized2(SequenceDatabase database, CandidateGenerator candidateGenerator, long minSupportCount, boolean dfs, boolean keepPatterns, boolean verbose) {
        this.frequentItems = database.frequentItems();
        Collection<Pattern> size1Sequences = this.getPatterns(this.frequentItems);
        this.saver.savePatterns(size1Sequences);
        List<EquivalenceClass> size2EquivalenceClasses = database.getSize2FrecuentSequences(this.minSupAbsolute);
        Collection<Pattern> size2Sequences = this.getPatterns(size2EquivalenceClasses);
        this.saver.savePatterns(size2Sequences);
        this.numberOfFrequentPatterns = size1Sequences.size() + size2Sequences.size();
        size2EquivalenceClasses = null;
        database = null;
        Runtime runtime = Runtime.getRuntime();
        ExecutorService pool = Executors.newFixedThreadPool(runtime.availableProcessors());
        LinkedHashSet<Future<Void>> set = new LinkedHashSet<Future<Void>>();
        ArrayList<FrequentPatternEnumeration> enumerates = new ArrayList<FrequentPatternEnumeration>();
        while (this.frequentItems.size() > 0) {
            EquivalenceClass frequentAtom = this.frequentItems.get(this.frequentItems.size() - 1);
            if (verbose) {
                System.out.println("Exploring " + frequentAtom);
            }
            FrequentPatternEnumeration frequentPatternEnumeration = new FrequentPatternEnumeration(candidateGenerator, this.minSupAbsolute, this.saver);
            enumerates.add(frequentPatternEnumeration);
            FrequentPatternEnumerationFacade callable = new FrequentPatternEnumerationFacade(frequentPatternEnumeration, frequentAtom, dfs, keepPatterns, verbose, this.saver);
            Future<Void> future = pool.submit(callable);
            set.add(future);
            this.frequentItems.remove(this.frequentItems.size() - 1);
            MemoryLogger.getInstance().checkMemory();
        }
        try {
            pool.shutdown();
            pool.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (Exception e) {
            System.err.println("Problems with the concurrency!!");
        }
        FrequentPatternEnumeration fpe = new FrequentPatternEnumeration(candidateGenerator, this.minSupAbsolute, this.saver);
        this.numberOfFrequentPatterns += fpe.getFrequentPatterns();
        MemoryLogger.getInstance().checkMemory();
    }
}

