/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Item;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class Itemset {
    private List<Item> items = new ArrayList<Item>();
    private long timestamp = 0L;

    public Itemset(Item item, long timestamp) {
        this.addItem(item);
        this.setTimestamp(timestamp);
    }

    public Itemset(Collection<Item> collection, long timestamp) {
        for (Item item : collection) {
            this.addItem(item);
        }
        this.setTimestamp(timestamp);
    }

    public Itemset(Item[] collection, long timestamp) {
        Item[] itemArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            this.addItem(item);
            ++n2;
        }
        this.setTimestamp(timestamp);
    }

    public Itemset() {
    }

    public void addItem(Item value) {
        this.items.add(value);
    }

    public void addItem(int i, Item value) {
        this.items.set(i, value);
    }

    public void removeItem(Item value) {
        this.items.remove(value);
    }

    public Item removeItem(int i) {
        return this.items.remove(i);
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Item get(int index) {
        return this.items.get(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Item attribute : this.items) {
            sb.append(attribute.toString());
            sb.append(' ');
        }
        return sb.toString();
    }

    public Itemset cloneItemset() {
        Itemset itemset = new Itemset();
        itemset.timestamp = this.timestamp;
        itemset.getItems().addAll(this.items);
        return itemset;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int size() {
        return this.items.size();
    }

    Itemset cloneItemSetMinusItems(Map<Item, BitSet> mapSequenceID) {
        Itemset itemset = new Itemset();
        itemset.timestamp = this.timestamp;
        for (Item item : this.items) {
            if (mapSequenceID.get(item) == null) continue;
            itemset.addItem(item);
        }
        return itemset;
    }

    public boolean equals(Object arg) {
        Itemset param = (Itemset)arg;
        if (param.size() != this.size()) {
            return false;
        }
        int i = 0;
        while (i < this.items.size()) {
            if (!this.items.get(i).equals(param.items.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (this.items != null ? this.items.hashCode() : 0);
        return hash;
    }
}

