/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.itemComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Itemset {
    private List<Item> items = new ArrayList<Item>();
    private long timestamp = 0L;

    public Itemset(Item item, long timestamp) {
        this.addItem(item);
        this.setTimestamp(timestamp);
    }

    public Itemset(Collection<Item> collection, long timestamp) {
        for (Item item : collection) {
            this.addItem(item);
        }
        this.setTimestamp(timestamp);
    }

    public Itemset(Item[] collection, long timestamp) {
        Item[] itemArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            this.addItem(item);
            ++n2;
        }
        this.setTimestamp(timestamp);
    }

    public Itemset() {
    }

    public void addItem(Item value) {
        this.items.add(value);
    }

    public void addItem(int index, Item value) {
        this.items.set(index, value);
    }

    public boolean removeItem(Item item) {
        return this.items.remove(item);
    }

    public Item removeItem(int index) {
        return this.items.remove(index);
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Item get(int index) {
        return this.items.get(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Item item : this.items) {
            sb.append(item.toString());
            sb.append(' ');
        }
        return sb.toString();
    }

    public Itemset cloneItemset() {
        Itemset itemset = new Itemset();
        itemset.setTimestamp(this.timestamp);
        itemset.getItems().addAll(this.items);
        return itemset;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int size() {
        return this.items.size();
    }

    int binarySearch(Item item) {
        return Collections.binarySearch(this.items, item, new itemComparator());
    }

    int linealSearch(Item item) {
        int i = 0;
        while (i < this.items.size()) {
            Item currentItem = this.items.get(i);
            int compareOutput = currentItem.compareTo(item);
            if (compareOutput == 0) {
                return i;
            }
            if (compareOutput < 0) break;
            ++i;
        }
        return -1;
    }
}

