/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.CandidateGeneration;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.SupportCounting;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Sequences;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.patterns.Pattern;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoGSP {
    protected double minSupRelative;
    protected double minGap;
    protected double maxGap;
    protected double windowSize;
    protected double minSupAbsolute;
    protected Sequences patterns;
    protected long start;
    protected long end;
    protected List<Pattern> frequentItems;
    private AbstractionCreator abstractionCreator;
    private boolean isSorted;
    private int numberOfFrequentPatterns;
    BufferedWriter writer = null;

    public AlgoGSP(double minSupRelative, double mingap, double maxgap, double windowSize, AbstractionCreator abstractionCreator) {
        this.minSupRelative = minSupRelative;
        this.minGap = mingap;
        this.maxGap = maxgap;
        this.windowSize = windowSize;
        this.abstractionCreator = abstractionCreator;
        this.isSorted = false;
    }

    public Sequences runAlgorithm(SequenceDatabase database, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.patterns = new Sequences("FREQUENT SEQUENTIAL PATTERNS");
        this.writer = outputFilePath == null ? null : new BufferedWriter(new FileWriter(outputFilePath));
        this.minSupAbsolute = (int)Math.ceil(this.minSupRelative * (double)database.size());
        if (this.minSupAbsolute == 0.0) {
            this.minSupAbsolute = 1.0;
        }
        CandidateGeneration candidateGenerator = new CandidateGeneration();
        SupportCounting supportCounter = new SupportCounting(database, this.abstractionCreator);
        MemoryLogger.getInstance().reset();
        this.start = System.currentTimeMillis();
        this.runGsp(database, candidateGenerator, supportCounter, keepPatterns, verbose);
        this.end = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    protected void runGsp(SequenceDatabase database, CandidateGeneration candidateGenerator, SupportCounting supportCounter, boolean keepPatterns, boolean verbose) throws IOException {
        int level;
        this.frequentItems = database.frequentItems();
        this.patterns.addSequences(this.frequentItems, 1);
        Set<Pattern> frequentSet = new LinkedHashSet<Pattern>(this.frequentItems.size());
        frequentSet.addAll(this.frequentItems);
        Map<Item, Set<Pattern>> indexationMap = new HashMap<Item, Set<Pattern>>();
        this.numberOfFrequentPatterns += this.frequentItems.size();
        int k = 1;
        while (frequentSet != null && !frequentSet.isEmpty()) {
            ++k;
            if (verbose) {
                System.out.println("k=" + k);
                System.out.println("generating candidates...");
            }
            List<Pattern> candidateSet = candidateGenerator.generateCandidates(frequentSet, this.abstractionCreator, indexationMap, k, this.minSupAbsolute);
            frequentSet = null;
            if (candidateSet == null) break;
            if (verbose) {
                System.out.println(String.valueOf(candidateSet.size()) + "  Candidates have been created!");
                System.out.println("checking frequency...");
            }
            MemoryLogger.getInstance().checkMemory();
            frequentSet = supportCounter.countSupport(candidateSet, k, this.minSupAbsolute);
            if (verbose) {
                System.out.println(String.valueOf(frequentSet.size()) + " frequent patterns\n");
            }
            MemoryLogger.getInstance().checkMemory();
            this.numberOfFrequentPatterns += frequentSet.size();
            indexationMap = supportCounter.getIndexationMap();
            this.patterns.addSequences(new ArrayList<Pattern>(frequentSet), k);
            level = k - 1;
            if (!keepPatterns) {
                if (frequentSet.isEmpty()) continue;
                this.patterns.delete(level);
                continue;
            }
            if (this.writer == null || frequentSet.isEmpty()) continue;
            for (Pattern seq : this.patterns.getLevel(level)) {
                this.writer.write(seq.toStringToFile());
                this.writer.newLine();
            }
            this.patterns.delete(level);
        }
        if (keepPatterns && this.writer != null) {
            level = this.patterns.getLevelCount();
            for (Pattern seq : this.patterns.getLevel(level)) {
                this.writer.write(seq.toStringToFile());
                this.writer.newLine();
            }
            this.patterns.delete(level);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public String printStatistics() {
        if (!this.isSorted) {
            this.patterns.sort();
            this.isSorted = true;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        sb.append(this.runningTime());
        sb.append(" ms\n");
        sb.append(" Frequent sequences count : ");
        sb.append(this.numberOfFrequentPatterns);
        sb.append('\n');
        sb.append(" Max memory (mb):");
        sb.append(MemoryLogger.getInstance().getMaxMemory());
        sb.append('\n');
        if (this.writer == null) {
            sb.append(this.patterns.toString());
        }
        sb.append("===================================================\n");
        return sb.toString();
    }

    public String printedOutputToSaveInFile() {
        if (!this.isSorted) {
            this.patterns.sort();
            this.isSorted = true;
        }
        StringBuilder output = new StringBuilder();
        output.append(this.patterns.toStringToFile());
        return output.toString();
    }

    public int getNumberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public String getPatterns() {
        String output = null;
        if (this.writer == null) {
            output = this.patterns.toString();
        }
        return output;
    }

    public long runningTime() {
        return this.end - this.start;
    }

    public double getMinSupAbsolut() {
        return this.minSupAbsolute;
    }

    public void clear() {
        this.patterns.clear();
        this.frequentItems.clear();
        this.abstractionCreator = null;
    }
}

