/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.tries;

import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.abstracciones.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.patterns.PatternCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.IDList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.tries.TrieNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class Trie
implements Comparable<Trie> {
    private List<TrieNode> nodes;
    private IDList idList;
    private BitSet appearingIn = new BitSet();
    private int support = -1;
    private int sumSequencesIDs = -1;
    static int intId = 1;
    private int id;

    public Trie(List<TrieNode> nodes, IDList idList) {
        this.nodes = nodes;
        this.idList = idList;
        this.id = intId++;
    }

    public Trie(List<TrieNode> nodes) {
        this.nodes = nodes;
        this.id = intId++;
    }

    public Trie() {
        this.nodes = new ArrayList<TrieNode>();
        this.id = intId++;
    }

    public Trie getChild(int index) {
        return this.nodes.get(index).getChild();
    }

    public void setChild(int index, Trie child) {
        this.nodes.get(index).setChild(child);
    }

    public IDList getIdList() {
        return this.idList;
    }

    public void setIdList(IDList idList) {
        this.idList = idList;
    }

    public List<TrieNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<TrieNode> nodes) {
        this.nodes = nodes;
    }

    public boolean remove(int index) {
        if (this.levelSize() == 0 || index >= this.levelSize()) {
            return false;
        }
        this.getChild(index).removeAll();
        return true;
    }

    public ItemAbstractionPair getPair(int index) {
        return this.nodes.get(index).getPair();
    }

    public TrieNode getNode(int index) {
        return this.nodes.get(index);
    }

    public void setNode(int index, TrieNode node) {
        this.nodes.set(index, node);
    }

    public int levelSize() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public void removeAll() {
        if (this.levelSize() == 0) {
            return;
        }
        for (TrieNode node : this.nodes) {
            Trie currentChild = node.getChild();
            if (currentChild != null) {
                currentChild.removeAll();
            }
            node.setChild(null);
            node.setPair(null);
        }
        this.setIdList(null);
        this.nodes.clear();
    }

    public void mergeWithTrie(TrieNode trie) {
        if (this.levelSize() == 0 && this.nodes == null) {
            this.nodes = new ArrayList<TrieNode>(1);
        }
        this.nodes.add(trie);
    }

    public void sort() {
        Collections.sort(this.nodes);
    }

    public BitSet getAppearingIn() {
        return this.appearingIn;
    }

    public void setAppearingIn(BitSet appearingIn) {
        this.appearingIn = appearingIn;
    }

    public String toString() {
        if (this.nodes == null) {
            return "";
        }
        StringBuilder result = new StringBuilder("ID=" + this.id + "[");
        if (!this.nodes.isEmpty()) {
            for (TrieNode node : this.nodes) {
                result.append(node.getPair()).append(',');
            }
            result.deleteCharAt(result.length() - 1);
        } else {
            result.append("NULL");
        }
        result.append(']');
        return result.toString();
    }

    public int getSupport() {
        if (this.support < 0) {
            this.support = this.appearingIn.cardinality();
        }
        return this.support;
    }

    public void setSupport(int support) {
        this.support = support;
    }

    public int getSumIdSequences() {
        if (this.sumSequencesIDs < 0) {
            this.sumSequencesIDs = this.calculateSumIdSequences();
        }
        return this.sumSequencesIDs;
    }

    public void setSumIdSequences(int sumIdSequences) {
        this.sumSequencesIDs = sumIdSequences;
    }

    private int calculateSumIdSequences() {
        int acum = 0;
        int i = this.appearingIn.nextSetBit(0);
        while (i >= 0) {
            acum += i;
            i = this.appearingIn.nextSetBit(i + 1);
        }
        return acum;
    }

    public List<Map.Entry<Pattern, Trie>> preorderTraversal(Pattern p) {
        ArrayList<Map.Entry<Pattern, Trie>> result = new ArrayList<Map.Entry<Pattern, Trie>>();
        if (this.nodes != null) {
            for (TrieNode node : this.nodes) {
                List<Map.Entry<Pattern, Trie>> patternsFromChild;
                Pattern newPattern = PatternCreator.getInstance().concatenate(p, node.getPair());
                Trie child = node.getChild();
                AbstractMap.SimpleEntry<Pattern, Trie> newEntry = new AbstractMap.SimpleEntry<Pattern, Trie>(newPattern, child);
                result.add(newEntry);
                if (child == null || (patternsFromChild = child.preorderTraversal(newPattern)) == null) continue;
                result.addAll(patternsFromChild);
            }
            return result;
        }
        return null;
    }

    public void display(DefaultTreeModel model, MutableTreeNode p) {
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.size()) {
                TrieNode node = this.nodes.get(i);
                Trie child = node.getChild();
                DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(String.valueOf(node.getPair().toString()) + " (" + child.getSupport() + ")");
                model.insertNodeInto(currentNode, p, i);
                child.display(model, currentNode);
                ++i;
            }
        }
    }

    @Override
    public int compareTo(Trie t) {
        return new Integer(this.id).compareTo(t.id);
    }
}

