/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists;

import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.IDList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.Position;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.tries.Trie;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IDListStandard_Map
implements IDList {
    private Map<Integer, List<Position>> sequencePositionsEntries;
    BitSet sequences;
    private static Map<Integer, Integer> originalSizeOfSequences = new HashMap<Integer, Integer>();
    private int totalElementsAfterPrefixes = 0;

    public IDListStandard_Map() {
        this.sequencePositionsEntries = new HashMap<Integer, List<Position>>();
    }

    public IDListStandard_Map(Map<Integer, List<Position>> sequencePositionsEntries) {
        this.sequencePositionsEntries = sequencePositionsEntries;
        this.sequences = new BitSet(sequencePositionsEntries.size());
    }

    @Override
    public IDList join(IDList idList, boolean equals, int minSupport) {
        HashMap<Integer, List<Position>> intersection = new HashMap<Integer, List<Position>>(((IDListStandard_Map)idList).getSequencePositionsEntries().size());
        BitSet newSequences = new BitSet(idList.getSupport());
        IDListStandard_Map idStandard = (IDListStandard_Map)idList;
        int[] newTotalElementsAfterPrefixes = new int[1];
        Map<Integer, List<Position>> idListMap = idStandard.getSequencePositionsEntries();
        Set<Map.Entry<Integer, List<Position>>> entries = idListMap.entrySet();
        for (Map.Entry<Integer, List<Position>> entry : entries) {
            int sid = entry.getKey();
            List<Position> positionAppearancesInSequence = entry.getValue();
            List<Position> positionAppearances = equals ? this.equalOperation(sid, positionAppearancesInSequence, newTotalElementsAfterPrefixes) : this.laterOperation(sid, positionAppearancesInSequence, newTotalElementsAfterPrefixes);
            if (positionAppearances == null) continue;
            intersection.put(entry.getKey(), positionAppearances);
            newSequences.set(sid);
        }
        IDListStandard_Map output = new IDListStandard_Map(intersection);
        output.sequences = newSequences;
        output.setTotalElementsAfterPrefixes(newTotalElementsAfterPrefixes[0]);
        return output;
    }

    public Map<Integer, List<Position>> getSequencePositionsEntries() {
        return this.sequencePositionsEntries;
    }

    private List<Position> laterOperation(Integer sid, List<Position> positionAppearancesInSequence, int[] dif) {
        List<Position> positionItemsAppearancesInSequenceOfMyIdList = this.sequencePositionsEntries.get(sid);
        if (positionItemsAppearancesInSequenceOfMyIdList == null || positionItemsAppearancesInSequenceOfMyIdList.isEmpty()) {
            return null;
        }
        ArrayList<Position> result = new ArrayList<Position>();
        int index = -1;
        int i = 0;
        while (i < positionAppearancesInSequence.size() && index < 0) {
            int eid = positionAppearancesInSequence.get(i).getItemsetIndex();
            if (positionItemsAppearancesInSequenceOfMyIdList.get(0).getItemsetIndex() < eid) {
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            i = index;
            while (i < positionAppearancesInSequence.size()) {
                Position pos = positionAppearancesInSequence.get(i);
                result.add(pos);
                dif[0] = dif[0] + (originalSizeOfSequences.get(sid) - pos.getItemIndex());
                ++i;
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private List<Position> equalOperation(Integer key, List<Position> positionItemsAppearancesInSequence, int[] dif) {
        List<Position> listToSearch;
        List<Position> listToExplore;
        List<Position> positionItemsAppearancesInSequenceOfMyIdList = this.sequencePositionsEntries.get(key);
        if (positionItemsAppearancesInSequenceOfMyIdList == null || positionItemsAppearancesInSequenceOfMyIdList.isEmpty()) {
            return null;
        }
        ArrayList<Position> result = new ArrayList<Position>();
        int beginningIndex = 0;
        if (positionItemsAppearancesInSequenceOfMyIdList.size() <= positionItemsAppearancesInSequence.size()) {
            listToExplore = positionItemsAppearancesInSequenceOfMyIdList;
            listToSearch = positionItemsAppearancesInSequence;
        } else {
            listToExplore = positionItemsAppearancesInSequence;
            listToSearch = positionItemsAppearancesInSequenceOfMyIdList;
        }
        block0: for (Position eid : listToExplore) {
            int i = beginningIndex;
            while (i < listToSearch.size()) {
                Position currentPosition = listToSearch.get(i);
                int comparison = currentPosition.getItemsetIndex().compareTo(eid.getItemsetIndex());
                if (comparison >= 0) {
                    if (comparison != 0) continue block0;
                    if (eid.getItemIndex() > currentPosition.getItemIndex()) {
                        result.add(eid);
                        dif[0] = dif[0] + (originalSizeOfSequences.get(key) - eid.getItemIndex());
                    } else {
                        result.add(currentPosition);
                        dif[0] = dif[0] + (originalSizeOfSequences.get(key) - currentPosition.getItemIndex());
                    }
                    beginningIndex = i + 1;
                    continue block0;
                }
                ++i;
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public int getSupport() {
        return this.sequences.cardinality();
    }

    public void addAppearance(Integer sequence, Position positionItem) {
        List<Position> eids = this.sequencePositionsEntries.get(sequence);
        if (eids == null) {
            eids = new ArrayList<Position>();
        }
        if (!eids.contains(positionItem)) {
            eids.add(positionItem);
            this.sequencePositionsEntries.put(sequence, eids);
            this.sequences.set(sequence);
        }
    }

    public void addAppearancesInSequence(Integer sid, List<Position> itemsets) {
        List<Position> positionItemsAppearancesInSequenceOfMyIdList = this.sequencePositionsEntries.get(sid);
        if (positionItemsAppearancesInSequenceOfMyIdList == null) {
            positionItemsAppearancesInSequenceOfMyIdList = itemsets;
        }
        this.sequencePositionsEntries.put(sid, positionItemsAppearancesInSequenceOfMyIdList);
        this.sequences.set(sid);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        Set<Map.Entry<Integer, List<Position>>> entries = this.sequencePositionsEntries.entrySet();
        for (Map.Entry<Integer, List<Position>> entry : entries) {
            result.append("\t").append(entry.getKey()).append(" {");
            List<Position> eids = entry.getValue();
            for (Position i : eids) {
                result.append(i.getItemsetIndex()).append(",");
            }
            result.deleteCharAt(result.length() - 1);
            result.append("}\n");
        }
        return result.toString();
    }

    @Override
    public void setAppearingIn(Trie trie) {
        trie.setAppearingIn((BitSet)this.sequences.clone());
    }

    @Override
    public void clear() {
        this.sequencePositionsEntries.clear();
        this.sequences.clear();
    }

    public static void sclear() {
        if (originalSizeOfSequences != null) {
            originalSizeOfSequences.clear();
            originalSizeOfSequences = null;
        }
    }

    @Override
    public Map<Integer, List<Position>> appearingInMap() {
        return this.sequencePositionsEntries;
    }

    @Override
    public int getTotalElementsAfterPrefixes() {
        return this.totalElementsAfterPrefixes;
    }

    @Override
    public void setTotalElementsAfterPrefixes(int i) {
        this.totalElementsAfterPrefixes = i;
    }

    @Override
    public void SetOriginalSequenceLengths(Map<Integer, Integer> map) {
        originalSizeOfSequences = map;
    }

    @Override
    public void setAppearingIn(Pattern pattern) {
        pattern.setAppearingIn((BitSet)this.sequences.clone());
    }
}

