/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures;

import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.abstracciones.Abstraction_Qualitative;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.abstracciones.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.patterns.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Sequences {
    public List<List<Pattern>> levels = new ArrayList<List<Pattern>>();
    public int numberOfFrequentSequences = 0;
    private String name;

    public Sequences(String name) {
        this.levels.add(new ArrayList());
        this.name = name;
    }

    public String toString() {
        StringBuilder r = new StringBuilder(200);
        r.append(this.name);
        int levelCount = 0;
        for (List<Pattern> level : this.levels) {
            r.append("\n***Level ").append(levelCount).append("***\n\n");
            for (Pattern sequence : level) {
                r.append(sequence.toString());
                r.append('\n');
            }
            ++levelCount;
        }
        return r.toString();
    }

    public String toStringToFile() {
        StringBuilder r = new StringBuilder(200);
        int levelCount = 0;
        if (this.levels != null) {
            for (List<Pattern> level : this.levels) {
                r.append("\n***Level ").append(levelCount).append("***\n\n");
                for (Pattern sequence : level) {
                    r.append(sequence.toStringToFile());
                    r.append('\n');
                }
                ++levelCount;
            }
        }
        return r.toString();
    }

    public void addSequence(Pattern sequence, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(sequence);
        ++this.numberOfFrequentSequences;
    }

    public List<Pattern> getLevel(int index) {
        return this.levels.get(index);
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    public List<List<Pattern>> getLevels() {
        return this.levels;
    }

    public int size() {
        int total = 0;
        for (List<Pattern> level : this.levels) {
            total += level.size();
        }
        return total;
    }

    public void sort() {
        for (List<Pattern> nivel : this.levels) {
            Collections.sort(nivel, new patternComparator());
        }
    }

    public void clear() {
        for (List<Pattern> nivel : this.levels) {
            nivel.clear();
        }
        this.levels.clear();
        this.levels = null;
    }

    private static class patternComparator
    implements Comparator<Pattern> {
        @Override
        public int compare(Pattern p1, Pattern p2) {
            int i = 0;
            while (i < p1.size()) {
                ItemAbstractionPair par1 = p1.getIthElement(i);
                ItemAbstractionPair par2 = p2.getIthElement(i);
                int comparacion = par1.getItem().compareTo(par2.getItem());
                if (comparacion != 0) {
                    return comparacion;
                }
                Abstraction_Qualitative abs1 = (Abstraction_Qualitative)par1.getAbstraction();
                Abstraction_Qualitative abs2 = (Abstraction_Qualitative)par2.getAbstraction();
                if (abs1.hasEqualRelation() && !abs2.hasEqualRelation()) {
                    return -1;
                }
                if (!abs1.hasEqualRelation() && abs2.hasEqualRelation()) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
    }
}

