/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.SequentialPattern;
import java.util.ArrayList;
import java.util.List;

public class SequentialPatterns {
    private final List<List<SequentialPattern>> levels = new ArrayList<List<SequentialPattern>>();
    private int sequenceCount = 0;
    private final String name;

    public SequentialPatterns(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printSequencesFrequentes(int nbObject) {
        System.out.println(this.toString(nbObject));
    }

    public String toString(int nbObject) {
        StringBuffer r = new StringBuffer(200);
        r.append(" ----------");
        r.append(this.name);
        r.append(" -------\n");
        int levelCount = 0;
        for (List<SequentialPattern> level : this.levels) {
            r.append("  L");
            r.append(levelCount);
            r.append(" \n");
            for (SequentialPattern sequence : level) {
                r.append("  pattern ");
                r.append(sequence.getId());
                r.append(":  ");
                r.append(sequence.toString());
                r.append("support :  ");
                r.append(sequence.getRelativeSupportFormated(nbObject));
                r.append(" (");
                r.append(sequence.getAbsoluteSupport());
                r.append('/');
                r.append(nbObject);
                r.append(") \n");
            }
            ++levelCount;
        }
        r.append(" -------------------------------- Patterns count : ");
        r.append(this.sequenceCount);
        return r.toString();
    }

    void addSequence(SequentialPattern sequence, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(sequence);
        ++this.sequenceCount;
    }

    public List<SequentialPattern> getLevel(int index) {
        return this.levels.get(index);
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    public List<List<SequentialPattern>> getLevels() {
        return this.levels;
    }
}

