/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.SequentialPatterns;
import ca.pfv.spmf.input.sequence_database_list_strings.Sequence;
import ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoPrefixSpan_with_Strings {
    private long startTime;
    private long endTime;
    private int patternCount;
    private int minsuppAbsolute;
    BufferedWriter writer = null;
    private SequentialPatterns patterns = null;

    public SequentialPatterns runAlgorithm(SequenceDatabase database, String outputFilePath, int minsup) throws IOException {
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsuppAbsolute = minsup;
        this.startTime = System.currentTimeMillis();
        this.prefixSpan(database, outputFilePath);
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    private void prefixSpan(SequenceDatabase database, String outputFilePath) throws IOException {
        if (outputFilePath == null) {
            this.writer = null;
            this.patterns = new SequentialPatterns("FREQUENT SEQUENTIAL PATTERNS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        Map<String, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(database);
        ArrayList<PseudoSequence> initialContext = new ArrayList<PseudoSequence>();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppAbsolute);
            if (optimizedSequence.size() == 0) continue;
            initialContext.add(new PseudoSequence(optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppAbsolute) continue;
            String item = (String)entry.getKey();
            List<PseudoSequence> projectedContext = this.buildProjectedContext(item, initialContext, false);
            SequentialPattern prefix = new SequentialPattern(0);
            prefix.addItemset(new Itemset(item));
            prefix.setSequencesID((Set)entry.getValue());
            this.savePattern(prefix);
            this.recursion(prefix, projectedContext);
        }
    }

    private void savePattern(SequentialPattern prefix) throws IOException {
        ++this.patternCount;
        if (this.writer != null) {
            StringBuffer r = new StringBuffer("");
            for (Itemset itemset : prefix.getItemsets()) {
                for (String item : itemset.getItems()) {
                    String string = item.toString();
                    r.append(string);
                    r.append(' ');
                }
                r.append("-1 ");
            }
            r.append(" #SUP: ");
            r.append(prefix.getSequencesID().size());
            this.writer.write(r.toString());
            this.writer.newLine();
        } else {
            this.patterns.addSequence(prefix, prefix.size());
        }
    }

    private Map<String, Set<Integer>> findSequencesContainingItems(SequenceDatabase contexte) {
        HashMap<String, Set<Integer>> mapSequenceID = new HashMap<String, Set<Integer>>();
        for (Sequence sequence : contexte.getSequences()) {
            for (List<String> itemset : sequence.getItemsets()) {
                for (String item : itemset) {
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private List<PseudoSequence> buildProjectedContext(String item, List<PseudoSequence> database, boolean inSuffix) {
        ArrayList<PseudoSequence> sequenceDatabase = new ArrayList<PseudoSequence>();
        for (PseudoSequence sequence : database) {
            int i = 0;
            while (i < sequence.size()) {
                int index = sequence.indexOf(i, item);
                if (index != -1 && sequence.isPostfix(i) == inSuffix) {
                    PseudoSequence newSequence;
                    if (index != sequence.getSizeOfItemsetAt(i) - 1) {
                        newSequence = new PseudoSequence(sequence, i, index + 1);
                        if (newSequence.size() > 0) {
                            sequenceDatabase.add(newSequence);
                        }
                    } else if (i != sequence.size() - 1 && (newSequence = new PseudoSequence(sequence, i + 1, 0)).size() > 0) {
                        sequenceDatabase.add(newSequence);
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private void recursion(SequentialPattern prefix, List<PseudoSequence> database) throws IOException {
        Set<Pair> pairs = this.findAllFrequentPairs(prefix, database);
        for (Pair pair : pairs) {
            if (pair.getCount() < this.minsuppAbsolute) continue;
            SequentialPattern newPrefix = pair.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, pair.getItem()) : this.appendItemToSequence(prefix, pair.getItem());
            List<PseudoSequence> projectedDB = this.buildProjectedContext(pair.getItem(), database, pair.isPostfix());
            newPrefix.setSequencesID(pair.getSequencesID());
            this.savePattern(newPrefix);
            this.recursion(newPrefix, projectedDB);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    protected Set<Pair> findAllFrequentPairs(SequentialPattern prefix, List<PseudoSequence> sequences) {
        HashMap<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        for (PseudoSequence sequence : sequences) {
            int i = 0;
            while (i < sequence.size()) {
                int j = 0;
                while (j < sequence.getSizeOfItemsetAt(i)) {
                    String item = sequence.getItemAtInItemsetAt(j, i);
                    Pair paire = new Pair(sequence.isPostfix(i), item);
                    Pair oldPaire = (Pair)mapPairs.get(paire);
                    if (oldPaire == null) {
                        mapPairs.put(paire, paire);
                    } else {
                        paire = oldPaire;
                    }
                    paire.getSequencesID().add(sequence.getId());
                    ++j;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapPairs.keySet();
    }

    private SequentialPattern appendItemToSequence(SequentialPattern prefix, String item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item));
        return newPrefix;
    }

    private SequentialPattern appendItemToPrefixOfSequence(SequentialPattern prefix, String item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    public void printStatistics(int size) {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  PREFIXSPAN - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }
}

