/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns;

import ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns.Rule;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import ca.pfv.spmf.input.sequence_database_array_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AlgoTNS {
    long timeStart = 0L;
    long timeEnd = 0L;
    double minConfidence;
    double delta;
    double initialK;
    SequenceDatabase database;
    int minsuppRelative;
    int k = 0;
    RedBlackTree<Rule> kRules;
    RedBlackTree<Rule> candidates;
    int maxCandidateCount = 0;
    Map<Integer, Short>[] arrayMapItemCountFirst;
    Map<Integer, Short>[] arrayMapItemCountLast;
    private int totalremovedCount;
    private int notAdded;

    public RedBlackTree<Rule> runAlgorithm(int k, SequenceDatabase database, double minConfidence, int delta) {
        this.delta = delta;
        this.database = database;
        this.minConfidence = minConfidence;
        this.initialK = k;
        this.k = k + delta;
        MemoryLogger.getInstance().reset();
        this.maxCandidateCount = 0;
        this.totalremovedCount = 0;
        this.notAdded = 0;
        this.minsuppRelative = 1;
        this.arrayMapItemCountFirst = new Map[database.maxItem + 1];
        this.arrayMapItemCountLast = new Map[database.maxItem + 1];
        this.kRules = new RedBlackTree();
        this.candidates = new RedBlackTree();
        this.timeStart = System.currentTimeMillis();
        this.scanDatabase(database);
        this.start();
        this.timeEnd = System.currentTimeMillis();
        this.cleanResult();
        return this.kRules;
    }

    private void cleanResult() {
        while ((double)this.kRules.size() > this.initialK) {
            this.kRules.popMinimum();
        }
        this.minsuppRelative = this.kRules.minimum().getAbsoluteSupport();
    }

    private void start() {
        int itemI = this.database.minItem;
        while (itemI <= this.database.maxItem) {
            Set<Integer> tidsI;
            Map<Integer, Short> occurencesIfirst = this.arrayMapItemCountFirst[itemI];
            if (occurencesIfirst != null && (tidsI = occurencesIfirst.keySet()).size() >= this.minsuppRelative) {
                int itemJ = itemI + 1;
                while (itemJ <= this.database.maxItem) {
                    block22: {
                        Set<Integer> tidsJ;
                        Map<Integer, Short> occurencesJfirst = this.arrayMapItemCountFirst[itemJ];
                        if (occurencesJfirst != null && (tidsJ = occurencesJfirst.keySet()).size() >= this.minsuppRelative) {
                            int supJI;
                            int left;
                            HashSet<Integer> tidsIJ = new HashSet<Integer>();
                            HashSet<Integer> tidsJI = new HashSet<Integer>();
                            Map<Integer, Short> occurencesJlast = this.arrayMapItemCountLast[itemJ];
                            Map<Integer, Short> occurencesIlast = this.arrayMapItemCountLast[itemI];
                            if (tidsI.size() > tidsJ.size()) {
                                left = tidsJ.size();
                                for (Integer tid : occurencesJfirst.keySet()) {
                                    Short occIFirst = occurencesIfirst.get(tid);
                                    if (occIFirst != null) {
                                        Short occJFirst = occurencesJfirst.get(tid);
                                        Short occJLast = occurencesJlast.get(tid);
                                        if (occIFirst < occJLast) {
                                            tidsIJ.add(tid);
                                        }
                                        Short occILast = occurencesIlast.get(tid);
                                        if (occJFirst < occILast) {
                                            tidsJI.add(tid);
                                        }
                                    }
                                    if (--left + tidsIJ.size() >= this.minsuppRelative || left + tidsJI.size() >= this.minsuppRelative) {
                                        continue;
                                    }
                                    break block22;
                                }
                            } else {
                                left = tidsI.size();
                                for (Integer tid : occurencesIfirst.keySet()) {
                                    Short occJFirst = occurencesJfirst.get(tid);
                                    if (occJFirst != null) {
                                        Short occIFirst = occurencesIfirst.get(tid);
                                        Short occILast = occurencesIlast.get(tid);
                                        if (occJFirst < occILast) {
                                            tidsJI.add(tid);
                                        }
                                        Short occJLast = occurencesJlast.get(tid);
                                        if (occIFirst < occJLast) {
                                            tidsIJ.add(tid);
                                        }
                                    }
                                    if (--left + tidsIJ.size() >= this.minsuppRelative || left + tidsJI.size() >= this.minsuppRelative) {
                                        continue;
                                    }
                                    break block22;
                                }
                            }
                            int supIJ = tidsIJ.size();
                            if (supIJ >= this.minsuppRelative) {
                                double confIJ = (double)tidsIJ.size() / (double)occurencesIfirst.size();
                                int[] itemsetI = new int[]{itemI};
                                int[] itemsetJ = new int[]{itemJ};
                                Rule ruleIJ = new Rule(itemsetI, itemsetJ, confIJ, supIJ, tidsI, tidsJ, tidsIJ, occurencesIfirst, occurencesJlast);
                                if (confIJ >= this.minConfidence) {
                                    this.save(ruleIJ, supIJ);
                                }
                                this.registerAsCandidate(true, ruleIJ);
                            }
                            if ((supJI = tidsJI.size()) >= this.minsuppRelative) {
                                int[] itemsetI = new int[]{itemI};
                                int[] itemsetJ = new int[]{itemJ};
                                double confJI = (double)tidsJI.size() / (double)occurencesJfirst.size();
                                Rule ruleJI = new Rule(itemsetJ, itemsetI, confJI, supJI, tidsJ, tidsI, tidsJI, occurencesJfirst, occurencesIlast);
                                if (confJI >= this.minConfidence) {
                                    this.save(ruleJI, supJI);
                                }
                                this.registerAsCandidate(true, ruleJI);
                            }
                        }
                    }
                    ++itemJ;
                }
            }
            ++itemI;
        }
        while (!this.candidates.isEmpty()) {
            Rule rule = this.candidates.popMaximum();
            if (rule.getAbsoluteSupport() < this.minsuppRelative) break;
            if (rule.expandLR) {
                this.expandL(rule);
                this.expandR(rule);
                continue;
            }
            this.expandL(rule);
        }
    }

    private void save(Rule rule, int support) {
        RedBlackTree.Node lowerRuleNode = this.kRules.lowerNode(new Rule(null, null, 0.0, support + 1, null, null, null, null, null));
        HashSet<Rule> rulesToDelete = new HashSet<Rule>();
        while (lowerRuleNode != null && lowerRuleNode.key != null && ((Rule)lowerRuleNode.key).getAbsoluteSupport() == support) {
            if (rule.getConfidence() == ((Rule)lowerRuleNode.key).getConfidence() && this.subsume((Rule)lowerRuleNode.key, rule)) {
                ++this.notAdded;
                return;
            }
            if (rule.getConfidence() == ((Rule)lowerRuleNode.key).getConfidence() && this.subsume(rule, (Rule)lowerRuleNode.key)) {
                rulesToDelete.add((Rule)lowerRuleNode.key);
                ++this.totalremovedCount;
            }
            lowerRuleNode = this.kRules.lowerNode((Rule)lowerRuleNode.key);
        }
        for (Rule ruleX : rulesToDelete) {
            this.kRules.remove(ruleX);
        }
        this.kRules.add(rule);
        if (this.kRules.size() > this.k) {
            if (support > this.minsuppRelative) {
                Rule lower;
                while ((lower = this.kRules.lower(new Rule(null, null, 0.0, this.minsuppRelative + 1, null, null, null, null, null))) != null) {
                    this.kRules.remove(lower);
                    if (this.kRules.size() > this.k) continue;
                }
            }
            this.minsuppRelative = this.kRules.minimum().getAbsoluteSupport();
        }
    }

    private boolean subsume(Rule rule1, Rule rule2) {
        if (rule1.getItemset1().length <= rule2.getItemset1().length && rule1.getItemset2().length >= rule2.getItemset2().length) {
            boolean cond1 = this.containsOrEquals(rule2.getItemset1(), rule1.getItemset1());
            boolean cond2 = this.containsOrEquals(rule1.getItemset2(), rule2.getItemset2());
            return cond1 && cond2;
        }
        return false;
    }

    boolean containsOrEquals(int[] array1, int[] array2) {
        int i = 0;
        while (i < array2.length) {
            block4: {
                int j = 0;
                while (j < array1.length) {
                    if (array1[j] != array2[i]) {
                        if (array1[j] > array2[i]) {
                            return false;
                        }
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private void registerAsCandidate(boolean expandLR, Rule ruleLR) {
        ruleLR.expandLR = expandLR;
        this.candidates.add(ruleLR);
        if (this.candidates.size() >= this.maxCandidateCount) {
            this.maxCandidateCount = this.candidates.size();
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandL(Rule rule) {
        HashMap<Integer, HashSet<Integer>> frequentItemsC = new HashMap<Integer, HashSet<Integer>>();
        int left = rule.tidsIJ.size();
        for (Integer n : rule.tidsIJ) {
            Sequence sequence = this.database.getSequences().get(n);
            Short end = rule.occurencesJlast.get(n);
            int k = 0;
            while (k < end) {
                Integer[] itemset = sequence.get(k);
                int m = 0;
                while (m < itemset.length) {
                    Integer itemC = itemset[m];
                    if (!this.containsLEXPlus(rule.getItemset1(), itemC) && !this.containsLEX(rule.getItemset2(), itemC)) {
                        HashSet<Integer> tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                        if (tidsItemC == null) {
                            if (left < this.minsuppRelative) {
                                break;
                            }
                        } else if (tidsItemC.size() + left < this.minsuppRelative) {
                            tidsItemC.remove(itemC);
                            break;
                        }
                        if (tidsItemC == null) {
                            tidsItemC = new HashSet<Integer>(rule.tidsIJ.size());
                            frequentItemsC.put(itemC, tidsItemC);
                        }
                        tidsItemC.add(n);
                    }
                    ++m;
                }
                ++k;
            }
            --left;
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            Set tidsIC_J = (Set)entry.getValue();
            if (tidsIC_J.size() < this.minsuppRelative) continue;
            Integer itemC = (Integer)entry.getKey();
            HashSet<Integer> tidsIC = new HashSet<Integer>(rule.tidsI.size());
            for (Integer tid : rule.tidsI) {
                if (!this.arrayMapItemCountFirst[itemC].containsKey(tid)) continue;
                tidsIC.add(tid);
            }
            double confIC_J = (double)tidsIC_J.size() / (double)tidsIC.size();
            int[] itemsetIC = new int[rule.getItemset1().length + 1];
            System.arraycopy(rule.getItemset1(), 0, itemsetIC, 0, rule.getItemset1().length);
            itemsetIC[rule.getItemset1().length] = itemC;
            Rule candidate = new Rule(itemsetIC, rule.getItemset2(), confIC_J, tidsIC_J.size(), tidsIC, null, tidsIC_J, null, rule.occurencesJlast);
            if (confIC_J >= this.minConfidence) {
                this.save(candidate, tidsIC_J.size());
            }
            this.registerAsCandidate(false, candidate);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void expandR(Rule rule) {
        frequentItemsC = new HashMap<Integer, HashSet<Integer>>();
        left = rule.tidsIJ.size();
        for (Integer tid : rule.tidsIJ) {
            sequence = this.database.getSequences().get(tid);
            first = rule.occurencesIfirst.get(tid);
            k = first + 1;
            while (k < sequence.size()) {
                itemset = sequence.get(k);
                m = 0;
                while (m < itemset.length) {
                    block10: {
                        block11: {
                            itemC = itemset[m];
                            if (this.containsLEX(rule.getItemset1(), itemC) || this.containsLEXPlus(rule.getItemset2(), itemC)) break block10;
                            tidsItemC = (HashSet<Integer>)frequentItemsC.get(itemC);
                            if (tidsItemC != null) break block11;
                            if (left >= this.minsuppRelative) ** GOTO lbl-1000
                            break block10;
                        }
                        if (tidsItemC.size() + left < this.minsuppRelative) {
                            tidsItemC.remove(itemC);
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (tidsItemC == null) {
                                tidsItemC = new HashSet<Integer>(rule.tidsIJ.size());
                                frequentItemsC.put(itemC, tidsItemC);
                            }
                            tidsItemC.add(tid);
                        }
                    }
                    ++m;
                }
                ++k;
            }
            --left;
        }
        for (Map.Entry entry : frequentItemsC.entrySet()) {
            tidsI_JC = (Set)entry.getValue();
            if (tidsI_JC.size() < this.minsuppRelative) continue;
            itemC = (Integer)entry.getKey();
            tidsJC = new HashSet<Integer>(rule.tidsJ.size());
            occurencesJC = new HashMap<Integer, Short>();
            for (Integer tid : rule.tidsJ) {
                occurenceCLast = this.arrayMapItemCountLast[itemC].get(tid);
                if (occurenceCLast == null) continue;
                tidsJC.add(tid);
                occurenceJlast = rule.occurencesJlast.get(tid);
                if (occurenceCLast < occurenceJlast) {
                    occurencesJC.put(tid, occurenceCLast);
                    continue;
                }
                occurencesJC.put(tid, occurenceJlast);
            }
            confI_JC = (double)tidsI_JC.size() / (double)rule.tidsI.size();
            itemsetJC = new int[rule.getItemset2().length + 1];
            System.arraycopy(rule.getItemset2(), 0, itemsetJC, 0, rule.getItemset2().length);
            itemsetJC[rule.getItemset2().length] = itemC;
            candidate = new Rule(rule.getItemset1(), itemsetJC, confI_JC, tidsI_JC.size(), rule.tidsI, tidsJC, tidsI_JC, rule.occurencesIfirst, occurencesJC);
            if (confI_JC >= this.minConfidence) {
                this.save(candidate, tidsI_JC.size());
            }
            this.registerAsCandidate(true, candidate);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void scanDatabase(SequenceDatabase database) {
        int tid = 0;
        while (tid < database.size()) {
            Sequence sequence = database.getSequences().get(tid);
            short j = 0;
            while (j < sequence.getItemsets().size()) {
                Integer[] itemset = sequence.get(j);
                int i = 0;
                while (i < itemset.length) {
                    Short oldPosition;
                    Integer itemI = itemset[i];
                    if (this.arrayMapItemCountFirst[itemI] == null) {
                        this.arrayMapItemCountFirst[itemI.intValue()] = new HashMap<Integer, Short>();
                        this.arrayMapItemCountLast[itemI.intValue()] = new HashMap<Integer, Short>();
                    }
                    if ((oldPosition = this.arrayMapItemCountFirst[itemI].get(tid)) == null) {
                        this.arrayMapItemCountFirst[itemI].put(tid, j);
                        this.arrayMapItemCountLast[itemI].put(tid, j);
                    } else {
                        this.arrayMapItemCountLast[itemI].put(tid, j);
                    }
                    ++i;
                }
                j = (short)(j + 1);
            }
            ++tid;
        }
    }

    boolean containsLEXPlus(int[] itemset, int item) {
        int i = 0;
        while (i < itemset.length) {
            if (itemset[i] == item) {
                return true;
            }
            if (itemset[i] > item) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean containsLEX(int[] itemset, int item) {
        int i = 0;
        while (i < itemset.length) {
            if (itemset[i] == item) {
                return true;
            }
            if (itemset[i] > item) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        for (Rule rule : this.kRules) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(rule.toString());
            buffer.append(" #SUP: ");
            buffer.append(rule.getAbsoluteSupport());
            buffer.append(" #CONF: ");
            buffer.append(rule.getConfidence());
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.close();
    }

    public void printStats() {
        System.out.println("=============  TNS - STATS ========");
        System.out.println("Minsup : " + this.minsuppRelative);
        System.out.println("Rules count: " + this.kRules.size());
        System.out.println("Max candidates: " + this.maxCandidateCount);
        System.out.println("Sequential rules count: " + this.kRules.size());
        System.out.println("-");
        System.out.println("Total time: " + (double)(this.timeEnd - this.timeStart) / 1000.0 + " s");
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("Rules eliminated by strategy 1: " + this.notAdded);
        System.out.println("Rules eliminated by strategy 2: " + this.totalremovedCount);
    }

    public double getTotalTime() {
        return this.timeEnd - this.timeStart;
    }
}

