/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.uapriori;

import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.ItemUApriori;
import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.ItemsetUApriori;
import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.UncertainTransactionDatabase;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class AlgoUApriori {
    protected UncertainTransactionDatabase database;
    protected int k;
    protected int totalCandidateCount = 0;
    protected int databaseScanCount = 0;
    protected long startTimestamp;
    protected long endTimestamp;
    private int itemsetCount;
    BufferedWriter writer = null;

    public AlgoUApriori(UncertainTransactionDatabase database) {
        this.database = database;
    }

    public void runAlgorithm(double minsupp, String output) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.totalCandidateCount = 0;
        this.databaseScanCount = 0;
        this.itemsetCount = 0;
        this.writer = new BufferedWriter(new FileWriter(output));
        this.k = 1;
        Set<ItemsetUApriori> candidatesSize1 = this.generateCandidateSize1();
        this.totalCandidateCount += candidatesSize1.size();
        this.calculateSupportForEachCandidate(candidatesSize1);
        Set<ItemsetUApriori> level = this.createLevelWithFrequentCandidates(minsupp, candidatesSize1);
        this.k = 2;
        while (!level.isEmpty()) {
            Set<ItemsetUApriori> levelK;
            Set<ItemsetUApriori> candidatesK = this.generateCandidateSizeK(level);
            this.totalCandidateCount += candidatesK.size();
            this.calculateSupportForEachCandidate(candidatesK);
            level = levelK = this.createLevelWithFrequentCandidates(minsupp, candidatesK);
            ++this.k;
        }
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void saveItemsetToFile(ItemsetUApriori itemset) throws IOException {
        this.writer.write(String.valueOf(itemset.toString()) + " Support: " + itemset.getExpectedSupport());
        this.writer.newLine();
        ++this.itemsetCount;
    }

    protected Set<ItemsetUApriori> createLevelWithFrequentCandidates(double minsupp, Set<ItemsetUApriori> candidatesK) throws IOException {
        HashSet<ItemsetUApriori> levelK = new HashSet<ItemsetUApriori>();
        for (ItemsetUApriori candidate : candidatesK) {
            if (!(candidate.getExpectedSupport() >= minsupp)) continue;
            levelK.add(candidate);
            this.saveItemsetToFile(candidate);
        }
        return levelK;
    }

    protected void calculateSupportForEachCandidate(Set<ItemsetUApriori> candidatesK) {
        ++this.databaseScanCount;
        for (ItemsetUApriori transaction : this.database.getTransactions()) {
            block1: for (ItemsetUApriori candidate : candidatesK) {
                double expectedSupport = 0.0;
                for (ItemUApriori item : candidate.getItems()) {
                    boolean found = false;
                    for (ItemUApriori itemT : transaction.getItems()) {
                        if (item.getId() == itemT.getId()) {
                            found = true;
                            if (expectedSupport == 0.0) {
                                expectedSupport = itemT.getProbability();
                                break;
                            }
                            expectedSupport *= itemT.getProbability();
                            break;
                        }
                        if (item.getId() < itemT.getId()) break;
                    }
                    if (!found) continue block1;
                }
                candidate.increaseSupportBy(expectedSupport);
            }
        }
    }

    protected Set<ItemsetUApriori> generateCandidateSize1() {
        HashSet<ItemsetUApriori> candidates = new HashSet<ItemsetUApriori>();
        for (ItemUApriori item : this.database.getAllItems()) {
            ItemsetUApriori itemset = new ItemsetUApriori();
            itemset.addItem(item);
            candidates.add(itemset);
        }
        return candidates;
    }

    protected Set<ItemsetUApriori> generateCandidateSizeK(Set<ItemsetUApriori> levelK_1) {
        HashSet<ItemsetUApriori> candidates = new HashSet<ItemsetUApriori>();
        Object[] itemsets = levelK_1.toArray();
        int i = 0;
        while (i < levelK_1.size()) {
            ItemsetUApriori itemset1 = (ItemsetUApriori)itemsets[i];
            int j = 0;
            while (j < levelK_1.size()) {
                ItemsetUApriori itemset2 = (ItemsetUApriori)itemsets[j];
                ItemUApriori missing = itemset1.allTheSameExceptLastItem(itemset2);
                if (missing != null) {
                    ItemsetUApriori candidate = new ItemsetUApriori();
                    for (ItemUApriori item : itemset1.getItems()) {
                        candidate.addItem(item);
                    }
                    candidate.addItem(missing);
                    if (this.allSubsetsOfSizeK_1AreFrequent(candidate, levelK_1)) {
                        candidates.add(candidate);
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(ItemsetUApriori candidate, Set<ItemsetUApriori> levelK_1) {
        if (candidate.size() == 1) {
            return true;
        }
        for (ItemUApriori item : candidate.getItems()) {
            ItemsetUApriori subset = candidate.cloneItemSetMinusOneItem(item);
            boolean found = false;
            for (ItemsetUApriori itemset : levelK_1) {
                if (!itemset.isEqualTo(subset)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void printStats() {
        System.out.println("=============  U-APRIORI - STATS =============");
        long temps = this.endTimestamp - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Candidates count : " + this.totalCandidateCount);
        System.out.println(" Database scan count : " + this.databaseScanCount);
        System.out.println(" The algorithm stopped at size " + (this.k - 1) + ", because there is no candidate");
        System.out.println(" Uncertain itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }
}

