/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.itemsettree;

import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.AssociationRuleIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.HashTableIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.ItemsetTreeNode;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ItemsetTree
implements Serializable {
    ItemsetTreeNode root = null;
    long startTimestamp;
    long endTimestamp;
    int nodeCount;
    long totalItemCountInNodes;

    public void buildTree(String input) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.root = new ItemsetTreeNode(null, 0);
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int[] itemset = new int[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                itemset[i] = Integer.parseInt(lineSplited[i]);
                ++i;
            }
            this.construct(null, this.root, itemset);
        }
        reader.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void addTransaction(int[] transaction) {
        this.construct(null, this.root, transaction);
    }

    private void construct(ItemsetTreeNode parentOfR, ItemsetTreeNode r, int[] s) {
        int[] sr = r.itemset;
        if (this.same(s, sr)) {
            ++r.support;
            return;
        }
        if (this.ancestorOf(s, sr)) {
            ItemsetTreeNode newNode = new ItemsetTreeNode(s, r.support + 1);
            newNode.childs.add(r);
            parentOfR.childs.remove(r);
            parentOfR.childs.add(newNode);
            return;
        }
        int[] l = this.getLargestCommonAncestor(s, sr);
        if (l != null) {
            ItemsetTreeNode newNode = new ItemsetTreeNode(l, r.support + 1);
            newNode.childs.add(r);
            parentOfR.childs.remove(r);
            parentOfR.childs.add(newNode);
            ItemsetTreeNode newNode2 = new ItemsetTreeNode(s, 1);
            newNode.childs.add(newNode2);
            return;
        }
        int indexLastItemOfR = sr == null ? 0 : sr.length;
        ++r.support;
        for (ItemsetTreeNode ci : r.childs) {
            if (this.same(s, ci.itemset)) {
                ++ci.support;
                return;
            }
            if (this.ancestorOf(s, ci.itemset)) {
                ItemsetTreeNode newNode = new ItemsetTreeNode(s, ci.support + 1);
                newNode.childs.add(ci);
                r.childs.remove(ci);
                r.childs.add(newNode);
                return;
            }
            if (this.ancestorOf(ci.itemset, s)) {
                this.construct(r, ci, s);
                return;
            }
            if (ci.itemset[indexLastItemOfR] != s[indexLastItemOfR]) continue;
            int[] ancestor = this.getLargestCommonAncestor(s, ci.itemset);
            ItemsetTreeNode newNode = new ItemsetTreeNode(ancestor, ci.support + 1);
            r.childs.add(newNode);
            newNode.childs.add(ci);
            r.childs.remove(ci);
            ItemsetTreeNode newNode2 = new ItemsetTreeNode(s, 1);
            newNode.childs.add(newNode2);
            return;
        }
        ItemsetTreeNode newNode = new ItemsetTreeNode(s, 1);
        r.childs.add(newNode);
    }

    private int[] getLargestCommonAncestor(int[] itemset1, int[] itemset2) {
        if (itemset2 == null || itemset1 == null) {
            return null;
        }
        int minI = itemset1.length < itemset2.length ? itemset1.length : itemset2.length;
        int count = 0;
        int i = 0;
        while (i < minI) {
            if (itemset1[i] != itemset2[i]) break;
            ++count;
            ++i;
        }
        if (count > 0 && count < minI) {
            int[] common = new int[count];
            System.arraycopy(itemset1, 0, common, 0, count);
            return common;
        }
        return null;
    }

    private boolean ancestorOf(int[] itemset1, int[] itemset2) {
        if (itemset2 == null) {
            return false;
        }
        if (itemset1 == null) {
            return true;
        }
        if (itemset1.length >= itemset2.length) {
            return false;
        }
        int i = 0;
        while (i < itemset1.length) {
            if (itemset1[i] != itemset2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean same(int[] itemset1, int[] itemset2) {
        if (itemset2 == null || itemset1 == null) {
            return false;
        }
        if (itemset1.length != itemset2.length) {
            return false;
        }
        int i = 0;
        while (i < itemset1.length) {
            if (itemset1[i] != itemset2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void printStatistics() {
        System.out.println("========== ITEMSET TREE CONSTRUCTION - STATS ============");
        System.out.println(" Tree construction time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        this.nodeCount = 0;
        this.totalItemCountInNodes = 0L;
        this.recursiveStats(this.root);
        System.out.println(" Node count: " + this.nodeCount);
        System.out.println(" Sum of items in all node: " + this.totalItemCountInNodes + " avg per node :" + (double)this.totalItemCountInNodes / (double)this.nodeCount);
        System.out.println("=====================================");
    }

    private void recursiveStats(ItemsetTreeNode root) {
        if (root != null && root.itemset != null) {
            ++this.nodeCount;
            this.totalItemCountInNodes += (long)root.itemset.length;
        }
        for (ItemsetTreeNode node : root.childs) {
            this.recursiveStats(node);
        }
    }

    public void printTree() {
        System.out.println(this.root.toString(new StringBuffer(), ""));
    }

    public String toString() {
        return this.root.toString(new StringBuffer(), "");
    }

    public int getSupportOfItemset(int[] s) {
        return this.count(s, this.root);
    }

    private int count(int[] s, ItemsetTreeNode root) {
        int count = 0;
        for (ItemsetTreeNode ci : root.childs) {
            if (ci.itemset[0] > s[0]) continue;
            if (this.includedIn(s, ci.itemset)) {
                count += ci.support;
                continue;
            }
            if (ci.itemset[ci.itemset.length - 1] >= s[s.length - 1]) continue;
            count += this.count(s, ci);
        }
        return count;
    }

    private boolean includedIn(int[] itemset1, int[] itemset2) {
        int count = 0;
        int i = 0;
        while (i < itemset2.length) {
            if (itemset2[i] == itemset1[count] && ++count == itemset1.length) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public HashTableIT getFrequentItemsetSubsuming(int[] is, int minsup) {
        HashTableIT hashTable = this.getFrequentItemsetSubsuming(is);
        List<Itemset>[] listArray = hashTable.table;
        int n = hashTable.table.length;
        int n2 = 0;
        while (n2 < n) {
            List<Itemset> list = listArray[n2];
            if (list != null) {
                Iterator<Itemset> it = list.iterator();
                while (it.hasNext()) {
                    Itemset itemset = it.next();
                    if (itemset.support >= minsup) continue;
                    it.remove();
                }
            }
            ++n2;
        }
        return hashTable;
    }

    public HashTableIT getFrequentItemsetSubsuming(int[] s) {
        HashTableIT hash = new HashTableIT(1000);
        HashSet<Integer> seti = new HashSet<Integer>();
        int i = 0;
        while (i < s.length) {
            seti.add(s[i]);
            ++i;
        }
        this.selectiveMining(s, seti, this.root, hash);
        return hash;
    }

    private void selectiveMining(int[] s, HashSet<Integer> seti, ItemsetTreeNode t, HashTableIT hash) {
        for (ItemsetTreeNode ci : t.childs) {
            if (ci.itemset[0] > s[0]) continue;
            if (this.includedIn(s, ci.itemset)) {
                if (ci.childs.size() == 0) {
                    hash.put(s, ci.support);
                    this.recursiveAdd(s, seti, ci.itemset, ci.support, hash, 0);
                    continue;
                }
                this.selectiveMining(s, seti, ci, hash);
                continue;
            }
            if (ci.itemset[ci.itemset.length - 1] >= s[s.length - 1]) continue;
            this.selectiveMining(s, seti, ci, hash);
        }
    }

    private void recursiveAdd(int[] s, HashSet<Integer> seti, int[] ci, int cisupport, HashTableIT hash, int pos) {
        if (pos >= ci.length) {
            return;
        }
        if (!seti.contains(ci[pos])) {
            int[] newS = new int[s.length + 1];
            int j = 0;
            boolean added = false;
            int[] nArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                Integer item = nArray[n2];
                if (added || item < ci[pos]) {
                    newS[j++] = item;
                } else {
                    newS[j++] = ci[pos];
                    newS[j++] = item;
                    added = true;
                }
                ++n2;
            }
            if (j < s.length + 1) {
                newS[j++] = ci[pos];
            }
            hash.put(newS, cisupport);
            this.recursiveAdd(newS, seti, ci, cisupport, hash, pos + 1);
        }
        this.recursiveAdd(s, seti, ci, cisupport, hash, pos + 1);
    }

    public List<AssociationRuleIT> generateRules(int[] s, int minsup, double minconf) {
        ArrayList<AssociationRuleIT> rules = new ArrayList<AssociationRuleIT>();
        HashSet<Integer> seti = new HashSet<Integer>();
        int i = 0;
        while (i < s.length) {
            seti.add(s[i]);
            ++i;
        }
        int suppS = this.getSupportOfItemset(s);
        HashTableIT frequentItemsets = this.getFrequentItemsetSubsuming(s, minsup);
        List<Itemset>[] listArray = frequentItemsets.table;
        int n = frequentItemsets.table.length;
        int n2 = 0;
        while (n2 < n) {
            List<Itemset> list = listArray[n2];
            if (list != null) {
                for (Itemset c : list) {
                    if (c.size() == s.length) continue;
                    int[] l = new int[c.itemset.length - s.length];
                    int pos = 0;
                    int[] nArray = c.itemset;
                    int n3 = c.itemset.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Integer item = nArray[n4];
                        if (!seti.contains(item)) {
                            l[pos++] = item;
                        }
                        ++n4;
                    }
                    int suppC = this.getSupportOfItemset(c.itemset);
                    double conf = (double)suppC / (double)suppS;
                    if (!(conf >= minconf)) continue;
                    AssociationRuleIT rule = new AssociationRuleIT();
                    rule.itemset1 = s;
                    rule.itemset2 = l;
                    rule.support = suppC;
                    rule.confidence = conf;
                    rules.add(rule);
                }
            }
            ++n2;
        }
        return rules;
    }
}

