/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.FPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FPTree {
    List<Integer> headerList = null;
    Map<Integer, FPNode> mapItemNodes = new HashMap<Integer, FPNode>();
    Map<Integer, FPNode> mapItemLastNode = new HashMap<Integer, FPNode>();
    boolean hasMoreThanOnePath = false;
    FPNode root = new FPNode();

    FPTree() {
    }

    public void addTransaction(List<Integer> transaction) {
        FPNode currentNode = this.root;
        for (Integer item : transaction) {
            FPNode child = currentNode.getChildWithID(item);
            if (child == null) {
                FPNode newNode = new FPNode();
                newNode.itemID = item;
                newNode.parent = currentNode;
                currentNode.childs.add(newNode);
                if (!this.hasMoreThanOnePath && currentNode.childs.size() > 1) {
                    this.hasMoreThanOnePath = true;
                }
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
                continue;
            }
            ++child.counter;
            currentNode = child;
        }
    }

    private void fixNodeLinks(Integer item, FPNode newNode) {
        FPNode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        FPNode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    void addPrefixPath(List<FPNode> prefixPath, Map<Integer, Integer> mapSupportBeta, int relativeMinsupp) {
        int pathCount = prefixPath.get((int)0).counter;
        FPNode currentNode = this.root;
        int i = prefixPath.size() - 1;
        while (i >= 1) {
            FPNode pathItem = prefixPath.get(i);
            if (mapSupportBeta.get(pathItem.itemID) >= relativeMinsupp) {
                FPNode child = currentNode.getChildWithID(pathItem.itemID);
                if (child == null) {
                    FPNode newNode = new FPNode();
                    newNode.itemID = pathItem.itemID;
                    newNode.parent = currentNode;
                    newNode.counter = pathCount;
                    currentNode.childs.add(newNode);
                    if (!this.hasMoreThanOnePath && currentNode.childs.size() > 1) {
                        this.hasMoreThanOnePath = true;
                    }
                    currentNode = newNode;
                    this.fixNodeLinks(pathItem.itemID, newNode);
                } else {
                    child.counter += pathCount;
                    currentNode = child;
                }
            }
            --i;
        }
    }

    void createHeaderList(final Map<Integer, Integer> mapSupport) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                int compare = (Integer)mapSupport.get(id2) - (Integer)mapSupport.get(id1);
                if (compare == 0) {
                    return id1 - id2;
                }
                return compare;
            }
        });
    }
}

