/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import ca.pfv.spmf.algorithms.frequentpatterns.estDec.estTree;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;

public class Algo_estDec {
    estTree tree;
    private long miningTime = 0L;
    double sumTransactionInsertionTime = 0.0;
    private double maxMemory = 0.0;

    public Algo_estDec(double mins) {
        this.tree = new estTree(mins);
    }

    public void processTransactionFromFile(String input) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited = line.split(" ");
            int[] transaction = this.getVector(lineSplited);
            this.processTransaction(transaction);
        }
        reader.close();
    }

    public void performMining_saveResultToFile(String outputPath) throws IOException {
        long startMiningTimeStamp = System.currentTimeMillis();
        this.tree.patternMining_saveToFile(outputPath);
        this.checkMemory();
        this.miningTime = System.currentTimeMillis() - startMiningTimeStamp;
    }

    public Hashtable<List<Integer>, Double> performMining_saveResultToMemory() throws IOException {
        long startMiningTimeStamp = System.currentTimeMillis();
        Hashtable<List<Integer>, Double> patterns = this.tree.patternMining_saveToMemory();
        this.checkMemory();
        this.miningTime = System.currentTimeMillis() - startMiningTimeStamp;
        return patterns;
    }

    public void processTransaction(int[] transaction) {
        double startCTimestamp = System.currentTimeMillis();
        this.tree.updateParams(transaction);
        this.tree.insertItemset(transaction);
        if (this.tree.getK() % 1000 == 0) {
            this.tree.forcePruning(this.tree.root);
        }
        this.sumTransactionInsertionTime += (double)System.currentTimeMillis() - startCTimestamp;
    }

    int[] getVector(String[] line) {
        int[] output = new int[line.length];
        int i = 0;
        while (i < line.length) {
            output[i] = Integer.parseInt(line[i]);
            ++i;
        }
        return output;
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void setDecayRate(double b, double h) {
        this.tree.setDecayRate(b, h);
    }

    public void printStats() {
        System.out.println("=============  ESTDEC - STATS =============");
        System.out.println(" Frequent itemsets count : " + this.tree.patternCount);
        System.out.println(" Maximum memory usage : " + this.maxMemory + " mb");
        System.out.println(" construct time ~ " + this.sumTransactionInsertionTime / (double)this.tree.getK() + " ms");
        System.out.println(" mining time ~ " + this.miningTime + " ms");
        System.out.println("===================================================");
    }
}

