/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm_bitset;

import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm_bitset.HashTable;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm_bitset.ITNode;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm_bitset.ITSearchTree;
import ca.pfv.spmf.patterns.itemset_set_integers_with_tids_bitset.Itemset;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoCharm_Bitset_saveToFile {
    private long startTimestamp;
    private long endTimestamp;
    private int minsupRelative;
    Map<Integer, BitSet> mapItemTIDS = new HashMap<Integer, BitSet>();
    int tidcount;
    BufferedWriter writer = null;
    private int itemsetCount;
    private HashTable hash;

    public void runAlgorithm(String input, String output, double minsup, int hashTableSize) throws IOException {
        String line;
        this.hash = new HashTable(hashTableSize);
        this.itemsetCount = 0;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemTIDS = new HashMap<Integer, BitSet>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.tidcount = 0;
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String stringItem = stringArray[n2];
                int item = Integer.parseInt(stringItem);
                BitSet tids = this.mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new BitSet();
                    this.mapItemTIDS.put(item, tids);
                }
                tids.set(this.tidcount);
                ++n2;
            }
            ++this.tidcount;
        }
        reader.close();
        this.minsupRelative = (int)Math.ceil(minsup * (double)this.tidcount);
        ITSearchTree tree = new ITSearchTree();
        ITNode root = new ITNode(new HashSet<Integer>());
        tree.setRoot(root);
        root.setTidset(null, this.tidcount);
        for (Map.Entry<Integer, BitSet> entry : this.mapItemTIDS.entrySet()) {
            int entryCardinality = entry.getValue().cardinality();
            if (entryCardinality < this.minsupRelative) continue;
            HashSet<Integer> itemset = new HashSet<Integer>();
            itemset.add(entry.getKey());
            ITNode newNode = new ITNode(itemset);
            newNode.setTidset(entry.getValue(), entryCardinality);
            newNode.setParent(root);
            root.getChildNodes().add(newNode);
        }
        this.sortChildren(root);
        while (root.getChildNodes().size() > 0) {
            ITNode child = root.getChildNodes().get(0);
            this.extend(child);
            this.save(child);
            this.delete(child);
        }
        this.saveAllClosedItemsets();
        this.endTimestamp = System.currentTimeMillis();
        this.writer.close();
    }

    private void saveAllClosedItemsets() throws IOException {
        List<Itemset>[] listArray = this.hash.table;
        int n = this.hash.table.length;
        int n2 = 0;
        while (n2 < n) {
            List<Itemset> hashE = listArray[n2];
            if (hashE != null) {
                for (Itemset itemsetObject : hashE) {
                    this.writer.write(String.valueOf(itemsetObject.toString()) + " #SUP: " + itemsetObject.cardinality);
                    this.writer.newLine();
                    ++this.itemsetCount;
                }
            }
            ++n2;
        }
    }

    private void extend(ITNode currNode) throws IOException {
        int i = 0;
        while (i < currNode.getParent().getChildNodes().size()) {
            ITNode brother = currNode.getParent().getChildNodes().get(i);
            if (brother != currNode) {
                ITNode candidate;
                if (currNode.getTidset().equals(brother.getTidset())) {
                    this.replaceInSubtree(currNode, brother.getItemset());
                    this.delete(brother);
                    continue;
                }
                if (this.containsAll(brother, currNode)) {
                    this.replaceInSubtree(currNode, brother.getItemset());
                    ++i;
                    continue;
                }
                if (this.containsAll(currNode, brother)) {
                    candidate = this.getCandidate(currNode, brother);
                    this.delete(brother);
                    if (candidate == null) continue;
                    currNode.getChildNodes().add(candidate);
                    candidate.setParent(currNode);
                    continue;
                }
                if (!currNode.getTidset().equals(brother.getTidset())) {
                    candidate = this.getCandidate(currNode, brother);
                    if (candidate != null) {
                        currNode.getChildNodes().add(candidate);
                        candidate.setParent(currNode);
                    }
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        this.sortChildren(currNode);
        while (currNode.getChildNodes().size() > 0) {
            ITNode child = currNode.getChildNodes().get(0);
            this.extend(child);
            this.save(child);
            this.delete(child);
        }
    }

    private boolean containsAll(ITNode node1, ITNode node2) {
        BitSet newbitset = (BitSet)node2.getTidset().clone();
        newbitset.and(node1.getTidset());
        return newbitset.cardinality() == node2.size();
    }

    private void replaceInSubtree(ITNode currNode, Set<Integer> itemset) {
        HashSet<Integer> union = new HashSet<Integer>(itemset);
        union.addAll(currNode.getItemset());
        currNode.setItemset(union);
        currNode.replaceInChildren(union);
    }

    private ITNode getCandidate(ITNode currNode, ITNode brother) {
        BitSet commonTids = (BitSet)currNode.getTidset().clone();
        commonTids.and(brother.getTidset());
        int cardinality = commonTids.cardinality();
        if (cardinality >= this.minsupRelative) {
            HashSet<Integer> union = new HashSet<Integer>(brother.getItemset());
            union.addAll(currNode.getItemset());
            ITNode node = new ITNode(union);
            node.setTidset(commonTids, cardinality);
            return node;
        }
        return null;
    }

    private void delete(ITNode child) {
        child.getParent().getChildNodes().remove(child);
    }

    private void save(ITNode node) throws IOException {
        if (!this.hash.containsSupersetOf(node.itemsetObject)) {
            this.hash.put(node.itemsetObject);
        }
    }

    private void sortChildren(ITNode node) {
        Collections.sort(node.getChildNodes(), new Comparator<ITNode>(){

            @Override
            public int compare(ITNode o1, ITNode o2) {
                return o1.getTidset().size() - o2.getTidset().size();
            }
        });
    }

    public void printStats() {
        System.out.println("=============  CHARM - STATS =============");
        long temps = this.endTimestamp - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.tidcount);
        System.out.println(" Frequent closed itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }
}

