/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm;

import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm.ITNode;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm.ITSearchTree;
import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_set_integers_with_tids.Itemset;
import ca.pfv.spmf.patterns.itemset_set_integers_with_tids.Itemsets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoEclat {
    private int minsupRelative;
    private TransactionDatabase database;
    private long startTimestamp;
    private long endTime;
    protected Itemsets frequentItemsets;
    BufferedWriter writer = null;
    private int itemsetCount;
    private TriangularMatrix matrix;
    private boolean useTriangularMatrixOptimization;

    public Itemsets runAlgorithm(String output, TransactionDatabase database, double minsupp, boolean useTriangularMatrixOptimization) throws IOException {
        if (output == null) {
            this.writer = null;
            this.frequentItemsets = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.frequentItemsets = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.database = database;
        this.startTimestamp = System.currentTimeMillis();
        this.minsupRelative = (int)Math.ceil(minsupp * (double)database.size());
        this.useTriangularMatrixOptimization = useTriangularMatrixOptimization;
        HashSet<Integer> allTIDS = new HashSet<Integer>();
        int maxItemId = 0;
        HashMap<Integer, HashSet<Integer>> mapItemCount = new HashMap<Integer, HashSet<Integer>>();
        int i = 0;
        while (i < database.size()) {
            allTIDS.add(i);
            for (Integer n : database.getTransactions().get(i)) {
                HashSet<Integer> set = (HashSet<Integer>)mapItemCount.get(n);
                if (set == null) {
                    set = new HashSet<Integer>();
                    mapItemCount.put(n, set);
                    if (n > maxItemId) {
                        maxItemId = n;
                    }
                }
                set.add(i);
            }
            ++i;
        }
        if (useTriangularMatrixOptimization) {
            this.matrix = new TriangularMatrix(maxItemId + 1);
            for (List<Integer> itemset : database.getTransactions()) {
                Object[] array = itemset.toArray();
                int i2 = 0;
                while (i2 < itemset.size()) {
                    Integer itemI = (Integer)array[i2];
                    int j = i2 + 1;
                    while (j < itemset.size()) {
                        Integer itemJ = (Integer)array[j];
                        this.matrix.incrementCount(itemI, itemJ);
                        ++j;
                    }
                    ++i2;
                }
            }
        }
        ITSearchTree tree = new ITSearchTree();
        ITNode iTNode = new ITNode(new Itemset());
        iTNode.setTidset(allTIDS);
        tree.setRoot(iTNode);
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsupRelative) continue;
            Itemset itemset = new Itemset();
            itemset.addItem((Integer)entry.getKey());
            ITNode newNode = new ITNode(itemset);
            newNode.setTidset((Set)entry.getValue());
            newNode.setParent(iTNode);
            iTNode.getChildNodes().add(newNode);
        }
        this.save(iTNode);
        this.sortChildren(iTNode);
        while (iTNode.getChildNodes().size() > 0) {
            ITNode child = iTNode.getChildNodes().get(0);
            this.extend(child);
            this.save(child);
            this.delete(child);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        return this.frequentItemsets;
    }

    private void extend(ITNode currNode) throws IOException {
        for (ITNode brother : currNode.getParent().getChildNodes()) {
            ITNode candidate;
            if (brother == currNode || (candidate = this.getCandidate(currNode, brother)) == null) continue;
            currNode.getChildNodes().add(candidate);
            candidate.setParent(currNode);
        }
        this.sortChildren(currNode);
        while (currNode.getChildNodes().size() > 0) {
            ITNode child = currNode.getChildNodes().get(0);
            this.extend(child);
            this.save(child);
            this.delete(child);
        }
    }

    private ITNode getCandidate(ITNode currNode, ITNode brother) {
        int support;
        if (this.useTriangularMatrixOptimization && currNode.getItemset().size() == 1 && (support = this.matrix.getSupportForItems((Integer)currNode.getItemset().getItems().toArray()[0], (Integer)brother.getItemset().getItems().toArray()[0])) < this.minsupRelative) {
            return null;
        }
        int brotherSize = brother.getTidset().size();
        int currNodeSize = currNode.getTidset().size();
        HashSet<Integer> commonTids = new HashSet<Integer>();
        if (brotherSize < currNodeSize) {
            for (Integer tid : brother.getTidset()) {
                if (currNode.getTidset().contains(tid)) {
                    commonTids.add(tid);
                }
                if (--brotherSize + commonTids.size() >= this.minsupRelative) continue;
                return null;
            }
        } else {
            for (Integer tid : currNode.getTidset()) {
                if (brother.getTidset().contains(tid)) {
                    commonTids.add(tid);
                }
                if (--currNodeSize + commonTids.size() >= this.minsupRelative) continue;
                return null;
            }
        }
        if (commonTids.size() >= this.minsupRelative) {
            Itemset union = currNode.getItemset().union(brother.getItemset());
            ITNode node = new ITNode(union);
            node.setTidset(commonTids);
            return node;
        }
        return null;
    }

    private void delete(ITNode child) {
        child.getParent().getChildNodes().remove(child);
    }

    private void save(ITNode node) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            Itemset itemset = node.getItemset();
            itemset.setTidset(node.getTidset());
            this.frequentItemsets.addItemset(itemset, itemset.size());
        } else {
            this.writer.write(String.valueOf(node.getItemset().toString()) + " #SUP: " + node.getTidset().size());
            this.writer.newLine();
        }
    }

    private void sortChildren(ITNode node) {
        Collections.sort(node.getChildNodes(), new Comparator<ITNode>(){

            @Override
            public int compare(ITNode o1, ITNode o2) {
                return o1.getTidset().size() - o2.getTidset().size();
            }
        });
    }

    public void printStats() {
        System.out.println("=============  ECLAT - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public Itemsets getItemsets() {
        return this.frequentItemsets;
    }
}

