/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm;

import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm.HashTable;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm.ITNode;
import ca.pfv.spmf.algorithms.frequentpatterns.eclat_and_charm.ITSearchTree;
import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_set_integers_with_tids.Itemset;
import ca.pfv.spmf.patterns.itemset_set_integers_with_tids.Itemsets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoCharm {
    private int minsupRelative;
    private TransactionDatabase database;
    private long startTimestamp;
    private long endTimestamp;
    protected Itemsets frequentItemsets;
    BufferedWriter writer = null;
    private int itemsetCount;
    private TriangularMatrix matrix;
    private boolean useTriangularMatrixOptimization;
    private HashTable hash;

    public Itemsets runAlgorithm(String output, TransactionDatabase database, int hashTableSize, double minsuppAbsolute, boolean useTriangularMatrixOptimization) throws IOException {
        this.database = database;
        this.hash = new HashTable(hashTableSize);
        this.minsupRelative = (int)Math.ceil(minsuppAbsolute * (double)database.size());
        this.useTriangularMatrixOptimization = useTriangularMatrixOptimization;
        return this.run(output);
    }

    public Itemsets runAlgorithmWithRelativeMinsup(String output, boolean useTriangularMatrixOptimization, int minsupRelative) throws IOException {
        this.minsupRelative = minsupRelative;
        this.useTriangularMatrixOptimization = useTriangularMatrixOptimization;
        return this.run(output);
    }

    private Itemsets run(String output) throws IOException {
        if (output == null) {
            this.writer = null;
            this.frequentItemsets = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.frequentItemsets = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.startTimestamp = System.currentTimeMillis();
        HashSet<Integer> allTIDS = new HashSet<Integer>();
        int maxItemId = 0;
        HashMap<Integer, HashSet<Integer>> mapItemCount = new HashMap<Integer, HashSet<Integer>>();
        int i = 0;
        while (i < this.database.size()) {
            allTIDS.add(i);
            for (Integer n : this.database.getTransactions().get(i)) {
                HashSet<Integer> set = (HashSet<Integer>)mapItemCount.get(n);
                if (set == null) {
                    set = new HashSet<Integer>();
                    mapItemCount.put(n, set);
                    if (n > maxItemId) {
                        maxItemId = n;
                    }
                }
                set.add(i);
            }
            ++i;
        }
        if (this.useTriangularMatrixOptimization) {
            this.matrix = new TriangularMatrix(maxItemId + 1);
            for (List<Integer> itemset : this.database.getTransactions()) {
                Object[] array = itemset.toArray();
                int i2 = 0;
                while (i2 < itemset.size()) {
                    Integer itemI = (Integer)array[i2];
                    int j = i2 + 1;
                    while (j < itemset.size()) {
                        Integer itemJ = (Integer)array[j];
                        this.matrix.incrementCount(itemI, itemJ);
                        ++j;
                    }
                    ++i2;
                }
            }
        }
        ITSearchTree tree = new ITSearchTree();
        ITNode iTNode = new ITNode(new Itemset());
        iTNode.setTidset(allTIDS);
        tree.setRoot(iTNode);
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsupRelative) continue;
            Itemset itemset = new Itemset();
            itemset.addItem((Integer)entry.getKey());
            ITNode newNode = new ITNode(itemset);
            newNode.setTidset((Set)entry.getValue());
            newNode.setParent(iTNode);
            iTNode.getChildNodes().add(newNode);
        }
        this.sortChildren(iTNode);
        while (iTNode.getChildNodes().size() > 0) {
            ITNode child = iTNode.getChildNodes().get(0);
            this.extend(child);
            this.save(child);
            this.delete(child);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimestamp = System.currentTimeMillis();
        return this.frequentItemsets;
    }

    private void extend(ITNode currNode) throws IOException {
        int i = 0;
        while (i < currNode.getParent().getChildNodes().size()) {
            ITNode brother = currNode.getParent().getChildNodes().get(i);
            if (brother != currNode) {
                ITNode candidate;
                if (currNode.getTidset().equals(brother.getTidset())) {
                    this.replaceInSubtree(currNode, brother.getItemset());
                    this.delete(brother);
                    continue;
                }
                if (brother.getTidset().containsAll(currNode.getTidset())) {
                    this.replaceInSubtree(currNode, brother.getItemset());
                    ++i;
                    continue;
                }
                if (currNode.getTidset().containsAll(brother.getTidset())) {
                    candidate = this.getCandidate(currNode, brother);
                    this.delete(brother);
                    if (candidate == null) continue;
                    currNode.getChildNodes().add(candidate);
                    candidate.setParent(currNode);
                    continue;
                }
                if (!currNode.getTidset().equals(brother.getTidset())) {
                    candidate = this.getCandidate(currNode, brother);
                    if (candidate != null) {
                        currNode.getChildNodes().add(candidate);
                        candidate.setParent(currNode);
                    }
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        this.sortChildren(currNode);
        while (currNode.getChildNodes().size() > 0) {
            ITNode child = currNode.getChildNodes().get(0);
            this.extend(child);
            this.save(child);
            this.delete(child);
        }
    }

    private void replaceInSubtree(ITNode currNode, Itemset itemset) {
        Itemset union = new Itemset();
        union.getItems().addAll(currNode.getItemset().getItems());
        union.getItems().addAll(itemset.getItems());
        currNode.setItemset(union);
        currNode.replaceInChildren(union);
    }

    private ITNode getCandidate(ITNode currNode, ITNode brother) {
        int support;
        if (this.useTriangularMatrixOptimization && currNode.getItemset().size() == 1 && (support = this.matrix.getSupportForItems((Integer)currNode.getItemset().getItems().toArray()[0], (Integer)brother.getItemset().getItems().toArray()[0])) < this.minsupRelative) {
            return null;
        }
        Set<Integer> commonTids = currNode.peformOptimizedTidSetsIntersection(brother, this.minsupRelative);
        if (commonTids == null) {
            return null;
        }
        if (commonTids.size() >= this.minsupRelative) {
            Itemset union = currNode.getItemset().union(brother.getItemset());
            ITNode node = new ITNode(union);
            node.setTidset(commonTids);
            return node;
        }
        return null;
    }

    private void delete(ITNode child) {
        child.getParent().getChildNodes().remove(child);
    }

    private void save(ITNode node) throws IOException {
        Itemset itemset = node.getItemset();
        itemset.setTidset(node.getTidset());
        if (!this.hash.containsSupersetOf(itemset)) {
            ++this.itemsetCount;
            if (this.writer == null) {
                this.frequentItemsets.addItemset(itemset, itemset.size());
            } else {
                this.writer.write(String.valueOf(node.getItemset().toString()) + " #SUP: " + node.getTidset().size());
                this.writer.newLine();
            }
            this.hash.put(itemset);
        }
    }

    private void sortChildren(ITNode node) {
        Collections.sort(node.getChildNodes(), new Comparator<ITNode>(){

            @Override
            public int compare(ITNode o1, ITNode o2) {
                return o1.getTidset().size() - o2.getTidset().size();
            }
        });
    }

    public void printStats() {
        System.out.println("=============  CHARM - STATS =============");
        long temps = this.endTimestamp - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent closed itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public Itemsets getClosedItemsets() {
        return this.frequentItemsets;
    }
}

