/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.cfpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.cfpgrowth.MISNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MISTree {
    List<Integer> headerList = null;
    Map<Integer, MISNode> mapItemNodes = new HashMap<Integer, MISNode>();
    Map<Integer, MISNode> mapItemLastNode = new HashMap<Integer, MISNode>();
    MISNode root = new MISNode();

    MISTree() {
    }

    public void addTransaction(List<Integer> transaction) {
        MISNode currentNode = this.root;
        for (Integer item : transaction) {
            MISNode child = currentNode.getChildWithID(item);
            if (child == null) {
                MISNode newNode = new MISNode();
                newNode.itemID = item;
                newNode.parent = currentNode;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
                continue;
            }
            ++child.counter;
            currentNode = child;
        }
    }

    void addPrefixPath(List<MISNode> prefixPath, Map<Integer, Integer> mapSupportBeta, int minMIS) {
        int pathCount = prefixPath.get((int)0).counter;
        MISNode currentNode = this.root;
        int i = prefixPath.size() - 1;
        while (i >= 1) {
            MISNode pathItem = prefixPath.get(i);
            if (mapSupportBeta.get(pathItem.itemID) >= minMIS) {
                MISNode child = currentNode.getChildWithID(pathItem.itemID);
                if (child == null) {
                    MISNode newNode = new MISNode();
                    newNode.itemID = pathItem.itemID;
                    newNode.parent = currentNode;
                    newNode.counter = pathCount;
                    currentNode.childs.add(newNode);
                    currentNode = newNode;
                    this.fixNodeLinks(pathItem.itemID, newNode);
                } else {
                    child.counter += pathCount;
                    currentNode = child;
                }
            }
            --i;
        }
    }

    private void fixNodeLinks(Integer item, MISNode newNode) {
        MISNode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        MISNode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    void createHeaderList(Comparator<Integer> itemComparator2) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, itemComparator2);
    }

    void deleteFromHeaderList(int item, Comparator<Integer> itemComparator2) {
        int index = Collections.binarySearch(this.headerList, item, itemComparator2);
        this.headerList.remove(index);
    }

    void MISPruning(int item) {
        MISNode headernode = this.mapItemNodes.get(item);
        while (headernode != null) {
            if (headernode.childs.isEmpty()) {
                headernode.parent.childs.remove(headernode);
            } else {
                headernode.parent.childs.remove(headernode);
                headernode.parent.childs.addAll(headernode.childs);
                for (MISNode node : headernode.childs) {
                    node.parent = headernode.parent;
                }
            }
            headernode = headernode.nodeLink;
        }
    }

    /*
     * Unable to fully structure code
     */
    void MISMerge(MISNode treeRoot) {
        if (treeRoot == null) {
            return;
        }
        i = 0;
        while (i < treeRoot.childs.size()) {
            node1 = treeRoot.childs.get(i);
            j = i + 1;
            while (j < treeRoot.childs.size()) {
                block5: {
                    node2 = treeRoot.childs.get(j);
                    if (node2.itemID != node1.itemID) break block5;
                    node1.counter += node2.counter;
                    node1.childs.addAll(node2.childs);
                    treeRoot.childs.remove(j);
                    --j;
                    headernode = this.mapItemNodes.get(node1.itemID);
                    if (headernode != node2) ** GOTO lbl22
                    this.mapItemNodes.put(node2.itemID, node2.nodeLink);
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        headernode = headernode.nodeLink;
lbl22:
                        // 2 sources

                        ** while (headernode.nodeLink != node2)
                    }
lbl23:
                    // 1 sources

                    headernode.nodeLink = headernode.nodeLink.nodeLink;
                }
                ++j;
            }
            ++i;
        }
        for (MISNode node1 : treeRoot.childs) {
            this.MISMerge(node1);
        }
    }

    public void print(MISNode TRoot) {
        if (TRoot.itemID != -1) {
            System.out.print(TRoot.itemID);
        }
        System.out.print(' ');
        for (MISNode node : TRoot.childs) {
            this.print(node);
        }
    }
}

