/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.kmeans;

import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class AlgoKMeans {
    private List<Cluster> clusters = null;
    private static final Random random = new Random(System.currentTimeMillis());
    private long startTimestamp;
    private long endTimestamp;
    private long iterationCount;

    public List<Cluster> runAlgorithm(String inputFile, int k) throws NumberFormatException, IOException {
        Object vector;
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.iterationCount = 0L;
        ArrayList<DoubleArray> vectors = new ArrayList<DoubleArray>();
        double minValue = 2.147483647E9;
        double maxValue = 0.0;
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            vector = new double[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                double value = Double.parseDouble(lineSplited[i]);
                if (value < minValue) {
                    minValue = value;
                }
                if (value > maxValue) {
                    maxValue = value;
                }
                vector[i] = value;
                ++i;
            }
            vectors.add(new DoubleArray((double[])vector));
        }
        reader.close();
        this.clusters = new ArrayList<Cluster>();
        int vectorsSize = ((DoubleArray)vectors.get((int)0)).data.length;
        if (vectors.size() == 1) {
            vector = (DoubleArray)vectors.get(0);
            Cluster cluster = new Cluster(vectorsSize);
            cluster.addVector((DoubleArray)vector);
            this.clusters.add(cluster);
            return this.clusters;
        }
        int i = 0;
        while (i < k) {
            DoubleArray meanVector = this.generateRandomVector(minValue, maxValue, vectorsSize);
            Cluster cluster = new Cluster(vectorsSize);
            cluster.setMean(meanVector);
            this.clusters.add(cluster);
            ++i;
        }
        block3: while (true) {
            ++this.iterationCount;
            boolean changed = false;
            for (DoubleArray vector2 : vectors) {
                Cluster nearestCluster = null;
                Cluster containingCluster = null;
                double distanceToNearestCluster = Double.MAX_VALUE;
                for (Cluster cluster : this.clusters) {
                    double distance = this.euclideanDistance(cluster.getmean(), vector2);
                    if (distance < distanceToNearestCluster) {
                        nearestCluster = cluster;
                        distanceToNearestCluster = distance;
                    }
                    if (!cluster.contains(vector2)) continue;
                    containingCluster = cluster;
                }
                if (containingCluster == nearestCluster) continue;
                if (containingCluster != null) {
                    containingCluster.remove(vector2);
                }
                nearestCluster.addVector(vector2);
                changed = true;
            }
            MemoryLogger.getInstance().checkMemory();
            if (!changed) break;
            Iterator<Object> iterator = this.clusters.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block3;
                Cluster cluster = (Cluster)iterator.next();
                cluster.recomputeClusterMean();
            }
            break;
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.clusters;
    }

    private DoubleArray generateRandomVector(double minValue, double maxValue, int vectorsSize) {
        double[] vector = new double[vectorsSize];
        int i = 0;
        while (i < vectorsSize) {
            vector[i] = random.nextDouble() * (maxValue - minValue) + minValue;
            ++i;
        }
        return new DoubleArray(vector);
    }

    private double euclideanDistance(DoubleArray vector1, DoubleArray vector2) {
        double sum = 0.0;
        int i = 0;
        while (i < vector1.data.length) {
            sum += Math.pow(vector1.data[i] - vector2.data[i], 2.0);
            ++i;
        }
        return Math.sqrt(sum);
    }

    public void printStatistics() {
        System.out.println("========== KMEANS - STATS ============");
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " mb ");
        System.out.println(" Iteration count: " + this.iterationCount);
        System.out.println("=====================================");
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        int i = 0;
        while (i < this.clusters.size()) {
            if (this.clusters.get(i).getVectors().size() >= 1) {
                writer.write(this.clusters.get(i).toString());
                if (i < this.clusters.size() - 1) {
                    writer.newLine();
                }
            }
            ++i;
        }
        writer.close();
    }
}

