/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.hierarchical_clustering;

import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AlgoHierarchicalClustering {
    private double maxDistance = 0.0;
    List<Cluster> clusters = null;
    private long startTimestamp;
    private long endTimestamp;
    private long iterationCount;

    public List<Cluster> runAlgorithm(String inputFile, double maxDistance) throws NumberFormatException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.maxDistance = maxDistance;
        this.clusters = new ArrayList<Cluster>();
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            double[] vector = new double[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                double value;
                vector[i] = value = Double.parseDouble(lineSplited[i]);
                ++i;
            }
            DoubleArray theVector = new DoubleArray(vector);
            Cluster cluster = new Cluster(vector.length);
            cluster.addVector(theVector);
            cluster.setMean(theVector.clone());
            this.clusters.add(cluster);
        }
        reader.close();
        boolean changed = false;
        do {
            changed = this.mergeTheClosestCluster();
            MemoryLogger.getInstance().checkMemory();
        } while (changed);
        this.endTimestamp = System.currentTimeMillis();
        return this.clusters;
    }

    private boolean mergeTheClosestCluster() {
        Cluster clusterToMerge1 = null;
        Cluster clusterToMerge2 = null;
        double minClusterDistance = 2.147483647E9;
        int i = 0;
        while (i < this.clusters.size()) {
            int j = i + 1;
            while (j < this.clusters.size()) {
                double distance = this.euclideanDistance(this.clusters.get(i).getmean(), this.clusters.get(j).getmean());
                if (distance < minClusterDistance && distance <= this.maxDistance) {
                    minClusterDistance = distance;
                    clusterToMerge1 = this.clusters.get(i);
                    clusterToMerge2 = this.clusters.get(j);
                }
                ++j;
            }
            ++i;
        }
        if (clusterToMerge1 == null) {
            return false;
        }
        for (DoubleArray vector : clusterToMerge2.getVectors()) {
            clusterToMerge1.addVector(vector);
        }
        clusterToMerge1.recomputeClusterMean();
        this.clusters.remove(clusterToMerge2);
        ++this.iterationCount;
        return true;
    }

    private double euclideanDistance(DoubleArray vector1, DoubleArray vector2) {
        double sum = 0.0;
        int i = 0;
        while (i < vector1.data.length) {
            sum += Math.pow(vector1.data[i] - vector2.data[i], 2.0);
            ++i;
        }
        return Math.sqrt(sum);
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        int i = 0;
        while (i < this.clusters.size()) {
            if (this.clusters.get(i).getVectors().size() >= 1) {
                writer.write(this.clusters.get(i).toString());
                if (i < this.clusters.size() - 1) {
                    writer.newLine();
                }
            }
            ++i;
        }
        writer.close();
    }

    public void printStatistics() {
        System.out.println("========== HIERARCHICAL CLUSTERING - STATS ============");
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " mb ");
        System.out.println(" Iteration count: " + this.iterationCount);
        System.out.println("=====================================");
    }
}

