/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules;

import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.Rule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Rules {
    public final List<Rule> rules = new ArrayList<Rule>();
    private final String name;

    public void sortByConfidence() {
        Collections.sort(this.rules, new Comparator<Rule>(){

            @Override
            public int compare(Rule r1, Rule r2) {
                return (int)((r2.getConfidence() - r1.getConfidence()) * 2.147483647E9);
            }
        });
    }

    public Rules(String name) {
        this.name = name;
    }

    public void printRules(int databaseSize) {
        System.out.println(" ------- " + this.name + " -------");
        int i = 0;
        for (Rule rule : this.rules) {
            System.out.print("  rule " + i + ":  " + rule.toString());
            System.out.print("support :  " + rule.getRelativeSupport(databaseSize) + " (" + rule.getAbsoluteSupport() + "/" + databaseSize + ") ");
            System.out.print("confidence :  " + rule.getConfidence());
            System.out.println("");
            ++i;
        }
        System.out.println(" --------------------------------");
    }

    public void printRulesWithLift(int databaseSize) {
        System.out.println(" ------- " + this.name + " -------");
        int i = 0;
        for (Rule rule : this.rules) {
            System.out.print("  rule " + i + ":  " + rule.toString());
            System.out.print("support :  " + rule.getRelativeSupport(databaseSize) + " (" + rule.getAbsoluteSupport() + "/" + databaseSize + ") ");
            System.out.print("confidence :  " + rule.getConfidence());
            System.out.print(" lift :  " + rule.getLift());
            System.out.println("");
            ++i;
        }
        System.out.println(" --------------------------------");
    }

    public String toString(int databaseSize) {
        StringBuffer buffer = new StringBuffer(" ------- ");
        buffer.append(this.name);
        buffer.append(" -------\n");
        int i = 0;
        for (Rule rule : this.rules) {
            buffer.append("   rule ");
            buffer.append(i);
            buffer.append(":  ");
            buffer.append(rule.toString());
            buffer.append("support :  ");
            buffer.append(rule.getRelativeSupport(databaseSize));
            buffer.append(" (");
            buffer.append(rule.getAbsoluteSupport());
            buffer.append("/");
            buffer.append(databaseSize);
            buffer.append(") ");
            buffer.append("confidence :  ");
            buffer.append(rule.getConfidence());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public int getRulesCount() {
        return this.rules.size();
    }

    public List<Rule> getRules() {
        return this.rules;
    }
}

