/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules;

import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;

public class Rule {
    private Itemset itemset1;
    private Itemset itemset2;
    private int transactionCount;
    private double confidence;
    private double lift;

    public Rule(Itemset itemset1, Itemset itemset2, int transactionCount, double confidence, double lift) {
        this.itemset1 = itemset1;
        this.itemset2 = itemset2;
        this.transactionCount = transactionCount;
        this.confidence = confidence;
        this.lift = lift;
    }

    public double getRelativeSupport(int databaseSize) {
        return (double)this.transactionCount / (double)databaseSize;
    }

    public int getAbsoluteSupport() {
        return this.transactionCount;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getLift() {
        return this.lift;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return String.valueOf(this.itemset1.toString()) + " ==> " + this.itemset2.toString();
    }

    public Itemset getItemset1() {
        return this.itemset1;
    }

    public Itemset getItemset2() {
        return this.itemset2;
    }
}

