/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules;

import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.Rule;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.Rules;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;

public class AlgoAgrawalFaster94 {
    private Itemsets patterns;
    private Rules rules;
    BufferedWriter writer = null;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    private int ruleCount = 0;
    private int databaseSize = 0;
    private double minconf;
    private double minlift;
    private boolean usingLift = true;

    public Rules runAlgorithm(Itemsets patterns, String output, int databaseSize, double minconf) throws IOException {
        this.minconf = minconf;
        this.minlift = 0.0;
        this.usingLift = false;
        return this.runAlgorithm(patterns, output, databaseSize);
    }

    public Rules runAlgorithm(Itemsets patterns, String output, int databaseSize, double minconf, double minlift) throws IOException {
        this.minconf = minconf;
        this.minlift = minlift;
        this.usingLift = true;
        return this.runAlgorithm(patterns, output, databaseSize);
    }

    private Rules runAlgorithm(Itemsets patterns, String output, int databaseSize) throws IOException {
        if (output == null) {
            this.writer = null;
            this.rules = new Rules("ASSOCIATION RULES");
        } else {
            this.rules = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.databaseSize = databaseSize;
        this.startTimestamp = System.currentTimeMillis();
        this.ruleCount = 0;
        this.patterns = patterns;
        int k = 2;
        while (k < patterns.getLevels().size()) {
            for (Itemset lk : patterns.getLevels().get(k)) {
                HashSet<Itemset> H1 = new HashSet<Itemset>();
                for (Itemset itemsetSize1 : patterns.getLevels().get(1)) {
                    if (!lk.contains(itemsetSize1.getItems()[0])) continue;
                    H1.add(itemsetSize1);
                }
                HashSet<Itemset> H1_for_recursion = new HashSet<Itemset>();
                for (Itemset hm_P_1 : H1) {
                    Itemset itemset_Lk_minus_hm_P_1 = lk.cloneItemSetMinusAnItemset(hm_P_1);
                    this.calculateSupport(itemset_Lk_minus_hm_P_1);
                    double conf = (double)lk.getAbsoluteSupport() / (double)itemset_Lk_minus_hm_P_1.getAbsoluteSupport();
                    if (conf < this.minconf || Double.isInfinite(conf)) continue;
                    double lift = 0.0;
                    if (this.usingLift) {
                        this.calculateSupport(hm_P_1);
                        double term1 = (double)lk.getAbsoluteSupport() / (double)databaseSize;
                        double term2 = (double)itemset_Lk_minus_hm_P_1.getAbsoluteSupport() / (double)databaseSize;
                        double term3 = (double)hm_P_1.getAbsoluteSupport() / (double)databaseSize;
                        lift = term1 / (term2 * term3);
                        if (lift < this.minlift) continue;
                    }
                    Rule rule = new Rule(itemset_Lk_minus_hm_P_1, hm_P_1, lk.getAbsoluteSupport(), conf, lift);
                    this.saveRule(rule);
                    H1_for_recursion.add(hm_P_1);
                }
                this.apGenrules(k, 1, lk, H1_for_recursion);
            }
            ++k;
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimeStamp = System.currentTimeMillis();
        return this.rules;
    }

    private void saveRule(Rule rule) throws IOException {
        ++this.ruleCount;
        if (this.writer != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < rule.getItemset1().size()) {
                buffer.append(rule.getItemset1().get(i));
                if (i != rule.getItemset1().size() - 1) {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append(" ==> ");
            i = 0;
            while (i < rule.getItemset2().size()) {
                buffer.append(rule.getItemset2().get(i));
                if (i != rule.getItemset2().size() - 1) {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append(" #SUP: ");
            buffer.append(rule.getAbsoluteSupport());
            buffer.append(" #CONF: ");
            buffer.append(this.doubleToString(rule.getConfidence()));
            if (this.usingLift) {
                buffer.append(" #LIFT: ");
                buffer.append(this.doubleToString(rule.getLift()));
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
            this.writer.flush();
        } else {
            this.rules.addRule(rule);
        }
    }

    private void apGenrules(int k, int m, Itemset lk, Set<Itemset> Hm) throws IOException {
        if (k > m + 1) {
            Set<Itemset> Hm_plus_1 = this.generateCandidateSizeK(Hm);
            HashSet<Itemset> Hm_plus_1_for_recursion = new HashSet<Itemset>();
            for (Itemset hm_P_1 : Hm_plus_1) {
                Itemset itemset_Lk_minus_hm_P_1 = lk.cloneItemSetMinusAnItemset(hm_P_1);
                this.calculateSupport(itemset_Lk_minus_hm_P_1);
                double conf = (double)lk.getAbsoluteSupport() / (double)itemset_Lk_minus_hm_P_1.getAbsoluteSupport();
                if (conf < this.minconf || Double.isInfinite(conf)) continue;
                double lift = 0.0;
                if (this.usingLift) {
                    this.calculateSupport(hm_P_1);
                    double term1 = (double)lk.getAbsoluteSupport() / (double)this.databaseSize;
                    double term2 = (double)itemset_Lk_minus_hm_P_1.getAbsoluteSupport() / (double)this.databaseSize;
                    lift = term1 / (term2 * ((double)hm_P_1.getAbsoluteSupport() / (double)this.databaseSize));
                    if (lift < this.minlift) continue;
                }
                Rule rule = new Rule(itemset_Lk_minus_hm_P_1, hm_P_1, lk.getAbsoluteSupport(), conf, lift);
                this.saveRule(rule);
                Hm_plus_1_for_recursion.add(hm_P_1);
            }
            this.apGenrules(k, m + 1, lk, Hm_plus_1_for_recursion);
        }
    }

    private void calculateSupport(Itemset itemset_Lk_minus_hm_P_1) {
        for (Itemset itemset : this.patterns.getLevels().get(itemset_Lk_minus_hm_P_1.size())) {
            if (!itemset.isEqualTo(itemset_Lk_minus_hm_P_1)) continue;
            itemset_Lk_minus_hm_P_1.setAbsoluteSupport(itemset.getAbsoluteSupport());
            return;
        }
    }

    protected Set<Itemset> generateCandidateSizeK(Set<Itemset> levelK_1) {
        HashSet<Itemset> candidates = new HashSet<Itemset>();
        for (Itemset itemset1 : levelK_1) {
            for (Itemset itemset2 : levelK_1) {
                Integer missing = itemset1.allTheSameExceptLastItem(itemset2);
                if (missing == null) continue;
                int[] newItemset = new int[itemset1.size() + 1];
                System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                Itemset candidate = new Itemset(newItemset);
                if (!this.allSubsetsOfSizeK_1AreFrequent(candidate, levelK_1)) continue;
                candidates.add(candidate);
            }
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(Itemset candidate, Set<Itemset> levelK_1) {
        if (candidate.size() == 1) {
            return true;
        }
        int[] nArray = candidate.getItems();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer item = nArray[n2];
            Itemset subset = candidate.cloneItemSetMinusOneItem(item);
            boolean found = false;
            for (Itemset itemset : levelK_1) {
                if (!itemset.isEqualTo(subset)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void printStats() {
        System.out.println("=============  ASSOCIATION RULE GENERATION - STATS =============");
        System.out.println(" Number of association rules generated : " + this.ruleCount);
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    String doubleToString(double value) {
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(value);
    }

    private void saveTextToFile(String text) throws IOException {
        this.writer.write(text);
    }

    public void saveStatsToFile() throws IOException {
        this.saveTextToFile("=============  ASSOCIATION RULE GENERATION - STATS =============\n");
        this.saveTextToFile(" Number of itemsets generated : " + this.patterns.getItemsetsCount() + "\n");
        this.saveTextToFile(" Number of association rules generated : " + this.ruleCount + "\n");
        this.saveTextToFile(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms\n");
        this.saveTextToFile("===================================================\n");
    }
}

