/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.IGB;

import ca.pfv.spmf.algorithms.frequentpatterns.zart.TZTableClosed;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.rule_itemset_array_integer_with_count.Rule;
import ca.pfv.spmf.patterns.rule_itemset_array_integer_with_count.Rules;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AlgoIGB {
    private TZTableClosed closedPatternsAndGenerators;
    private double minconf;
    private int databaseSize;
    private Rules rules;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    private int ruleCount;
    BufferedWriter writer = null;

    public Rules runAlgorithm(TZTableClosed closedPatternsAndGenerators, int databaseSize, double minconf, String outputFilePath) throws IOException {
        if (outputFilePath == null) {
            this.writer = null;
            this.rules = new Rules("IGB ASSOCIATION RULES");
        } else {
            this.rules = null;
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        this.startTimestamp = System.currentTimeMillis();
        this.minconf = minconf;
        this.closedPatternsAndGenerators = closedPatternsAndGenerators;
        this.databaseSize = databaseSize;
        this.ruleCount = 0;
        for (List<Itemset> level : closedPatternsAndGenerators.levels) {
            for (Itemset itemset : level) {
                if (itemset.size() == 0) continue;
                this.processItemset(itemset);
            }
        }
        this.endTimeStamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.rules;
    }

    private void processItemset(Itemset i) throws IOException {
        if (i.getRelativeSupport(this.databaseSize) >= this.minconf) {
            Rule rule = new Rule(new Itemset(), i, i.getAbsoluteSupport(), i.getRelativeSupport(this.databaseSize));
            this.save(rule);
            return;
        }
        HashSet<Itemset> lSmallestPremise = new HashSet<Itemset>();
        int j = 0;
        while (j < i.size()) {
            for (Itemset i1 : this.closedPatternsAndGenerators.levels.get(j)) {
                if (!((double)i.getAbsoluteSupport() / (double)i1.getAbsoluteSupport() >= this.minconf) || !i.containsAll(i1)) continue;
                for (Itemset genI1 : this.closedPatternsAndGenerators.mapGenerators.get(i1)) {
                    boolean thereIsSmaller = false;
                    for (Itemset l : lSmallestPremise) {
                        if (!genI1.containsAll(l) || genI1.size() == l.size()) continue;
                        thereIsSmaller = true;
                        break;
                    }
                    if (thereIsSmaller) continue;
                    lSmallestPremise.add(genI1);
                }
            }
            ++j;
        }
        for (Itemset gs : lSmallestPremise) {
            ArrayList<Integer> list_i_gs = new ArrayList<Integer>();
            int[] nArray = i.itemset;
            int thereIsSmaller = i.itemset.length;
            int n = 0;
            while (n < thereIsSmaller) {
                Integer item = nArray[n];
                if (!gs.contains(item)) {
                    list_i_gs.add(item);
                }
                ++n;
            }
            int[] temp = new int[list_i_gs.size()];
            int k = 0;
            while (k < list_i_gs.size()) {
                temp[k] = (Integer)list_i_gs.get(k);
                ++k;
            }
            Itemset i_gs = new Itemset(temp);
            Rule rule = new Rule(gs, i_gs, i.getAbsoluteSupport(), (double)i.getAbsoluteSupport() / (double)gs.getAbsoluteSupport());
            this.save(rule);
        }
    }

    private void save(Rule rule) throws IOException {
        ++this.ruleCount;
        if (this.writer != null) {
            int i;
            StringBuffer buffer = new StringBuffer();
            if (rule.getItemset1().size() == 0) {
                buffer.append("__");
            } else {
                i = 0;
                while (i < rule.getItemset1().size()) {
                    buffer.append(rule.getItemset1().get(i));
                    if (i != rule.getItemset1().size() - 1) {
                        buffer.append(" ");
                    }
                    ++i;
                }
            }
            buffer.append(" ==> ");
            i = 0;
            while (i < rule.getItemset2().size()) {
                buffer.append(rule.getItemset2().get(i));
                if (i != rule.getItemset2().size() - 1) {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append(" #SUP: ");
            buffer.append(this.doubleToString(rule.getRelativeSupport(this.databaseSize)));
            buffer.append(" #CONF: ");
            buffer.append(this.doubleToString(rule.getConfidence()));
            this.writer.write(buffer.toString());
            this.writer.newLine();
            this.writer.flush();
        } else {
            this.rules.addRule(rule);
        }
    }

    private String doubleToString(double value) {
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(value);
    }

    public void printStatistics() {
        System.out.println("============= IGB ASSOCIATION RULE GENERATION - STATS =============");
        System.out.println(" Number of association rules generated : " + this.ruleCount);
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

