function [count total] = gen_classify(W, visB, hidB,mW,test_file,test_label);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RBM for generative classification                                  %   
% conf: training setting                                             %
% WW = [W visB hidB]                                                 %
% mW: mask of connections                                            %
% -*-sontran2012-*-                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Loading data & label
vars = whos('-file', test_file);
A = load(test_file,vars(1).name);
data = A.(vars(1).name);
vars = whos('-file', test_label);
A = load(test_label,vars(1).name);
label = A.(vars(1).name);
assert(size(data,1) == size(label,1),'[KRBM-GEN] Number of data and label mismatch'); 
Classes = unique(label)';
lNum = size(Classes,2);
%% Loading structure
[total visNum]= size(data);
sNum = 500;                                                                 % fix
bNum  = floor(total/sNum);                                                   % divide the testing samples to batches of sNum
%% Classifying
count = 0;
for i=1:bNum
    % Find the position of softmax unit which make lowest free energy
    L = lowest_fenergy(data((i-1)*sNum + 1:i*sNum,:),W, visB, hidB,Classes);
    count = count + sum(L==label((i-1)*sNum + 1:i*sNum));
end
L = lowest_fenergy(data(bNum*sNum + 1:total,:),W, visB, hidB,Classes);
count = count + sum(L==label(bNum*sNum + 1:total));
fprintf('Correct rate: %f (%d/%d)\n',count/total,count,total);
clear A vars data lNum sNum bNum out;
end

