function [ output_args ] = gen_evaluate( data,label,WW,Classes)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% generative classification                                          %   
% WW = [W visB hidB]                                                 %
% mW: mask of connections                                            %
% -*-sontran2012-*-                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Loading data & label
assert(size(data,1) == size(label,1),'[KRBM-GEN] Number of data and label mismatch'); 
lNum = size(Classes);
%% Loading structure
[total visNum]= size(data);
sNum = 500;                                                              % fix
bNum  = ceil(total/sNum);                                                % divide the testing samples to batches of sNum
%% Classifying
count = 0;
for i=1:bNum
    % Find the position of softmax unit which make lowest free energy
    L = lowest_fenergy(data((i-1)*sNum + 1:i*sNum,:),WW,lNum,Classes);
    count = count + sum(L==label((i-1)*sNum + 1:i*sNum));
end
L = lowest_fenergy(data(bNum*sNum + 1:total,:),WW,Classes);
count = count + sum(L==label(bNum*sNum + 1:total));
fprintf('Correct rate: %f (%d/%d)',count/total,count,total;
clear A vars data lNum sNum bNum out;
end

