function out = conv_subspace_delta(a, b, w, norm)
% out = conv_subspace_delta(a, b, w, norm)
% compute the distance vector from 2 vectors a,b using convolution euclidean         %
% w = convolution window 
%
% DW adapted from sontran2013

% window for convolution

s_len = numel(a);
if w == 0
    w = s_len;
end
cv_vec = ones(w,1);

out = sqrt(conv(cv_vec,(a - b).^2));
% out = out(:,w:end-w);
if norm 
  out = out./(conv(cv_vec,ones(s_len,1)));
end

% how to get to 1 dimension?
% out = sum(out);


