function [A, diag] = mahalmat_wrapper(X, Y, trainparams)
% dummy wrapper to plug any fixed mahalanobis matrix into the 
% testing set

% use deltafun to check for correct similarity
if isfield(trainparams,'deltafun')
    X = feval(trainparams.deltafun, X(:,1), X(:,2), trainparams.deltafun_params{:});
    diag.deltafun = trainparams.deltafun;
end

A = trainparams.mahalA;
if size(A,1) ~= size(X,1)
    error('wrong mahal matrix size');
end

diag.trainfun = 'mahalmat';
% ---
% intorducing model tyopology:
% mahal, nnet, gbrtree
% ---
diag.interpreter = 'DistMeasureMahal';