function [partBinTrn, partBinTst, partBinNoTrn] = sim_from_comparison_UNfair_components(comparison, comparison_ids, k, trainpart, filename)
%
% FOR ISMIR 2012 
%
% creates a cross-validation partitioning of the 
% similarity data in "multiG", NOT PRESERVING the 
% connected components in it during partitioning

% ---
% get the similarity multigraph and remove cycles
% ---
cprint(2, 'creating graph')
% Gm = ClipSimGraphMulti(comparison, comparison_ids);
% Gm.remove_cycles_length2; 
cprint(2, 'loading Multigraph for Similarity Constraints')
load('comp_SimGraphMulti.mat', 'G');


% get similarity data
[weights, a, b, c] = G.similarities();

% ---
% We randomise the constraint succession 
% ---
datPermu = randperm(numel(a));
a = a(datPermu);
b = b(datPermu);
c = c(datPermu);
weights = weights(datPermu);

% ---
% NOTE: we try the easy route: partition the graphs
% and look at which constraints  balance we end up with
% ---
P = cvpartition(numel(a), 'k', k);

% ---
% here we export  similarity test sets
% ---
cprint(2, 'export test similarity')
partBinTst = {};
for i = 1:P.NumTestSets  % test runs

    partBinTst{i} = [a(P.test(i))' b(P.test(i))' c(P.test(i))' weights(P.test(i))];
end


% ---
% Note: This uses a "truly" increasing training set
% to do the partial training partition
% ---
cprint(2, 'export train similarity')
for m = 1:numel(trainpart)

    % save test indices
    Ptrain(m) = cvpartition_trunctrain_incsubsets(P, trainpart(m));
end

% ---
% here we export similarity training sets
% ---
partBinTrn = {};
for i = 1:P.NumTestSets % train runs

    for m = 1:numel(trainpart) % increasing training sets

        % get training indices
        idxB = Ptrain(m).training(i);
        
        % save into cell
        partBinTrn{i,m} = [a(idxB)' b(idxB)' c(idxB)' weights(idxB)];
    end   
end

partBinNoTrn = {};
for i = 1:P.NumTestSets % train runs

    for m = 1:numel(trainpart) % increasing training sets

        % get training indices
        idxB = ~Ptrain(m).training(i) & ~Ptrain(m).test(i);
        
        % save into cell
        partBinNoTrn{i,m} = [a(idxB)' b(idxB)' c(idxB)' weights(idxB)];
    end   
end

if nargin == 5
    save(filename, 'partBinTrn', 'partBinTst', 'partBinNoTrn')
end
end