function [r, valididx, clip_ids, P] = ranking_from_comparison_Stober_diffs(nDatasets, nRuns)

global globalvars;
global comparison;
global comparison_ids;

% ---
% get the standard test set
% NOTE: we will keep the r and valididx, and just use
% the rest of the data for determining the issing edges etc
% ---
load('comp_SimGraphMulti_SimDataDump', 'G', 'r', 'valididx', 'clip_ids');
nData = sum(valididx > 0);

% ---
% initialise the new partition
% ---
P = cvpartition_alltrain(nData, nDatasets * nRuns);


for i = 1:nDatasets
    
    % ---
    % create new Stober graph
    % ---
    Gstob = ClipSimGraphStober();
    Gstob.random_all_constraints_graph;
    Gdiff = G - ClipSimGraphMulti(Gstob.to_DiGraph());
    
    % ---
    % get missing entries in stober similarity
    % ---
    idx = find_graph_in_valid(r, comparison_ids(clip_ids),valididx, Gdiff);
    lostData = sum(idx);
    if lostData ~= Gdiff.num_edges
        error ('Inconsistent Data: edges in gdiff could not be found');
    end

    % ---
    % save entries in DataPartition (remove from valid sets)
    % NOTE: this is manhual intervention into Class territory :(
    % ---
    for j = 1:nRuns
        jd = j + (i-1) * nRuns;
        P.mtraining{jd} = ones(P.N, 1) - idx(valididx)';
        P.mtest{jd} = ones(P.N, 1) - idx(valididx)';
        P.TrainSize(jd) = P.N - lostData;
        P.TestSize(jd) = P.N - lostData;
    end
end
end

% ---
%  This finds all graphs edges in the ranking
% ---
function idx = find_graph_in_valid(r, clip_ids, valididx, G)

    idx = zeros(1,size(r,1));
    for i = find(valididx)
        
        a = clip_ids(i);
        b = clip_ids(r{i,1});
        c = clip_ids(r{i,2});
        if G.edge(a,b,c) > 0
            idx(i) = 1;
        end
    end
end

