
% Results:
Gcomp = ClipComparedGraph(comparison, comparison_ids)
[Gcompcomps] = Gcomp.connected_components();
% only 2graphs  with 7 nodes, all subtriplets just connect via
% one node -> no "infestation" of other triplets

G = ClipSimGraph(comparison, comparison_ids)
[Gs,s, id] = G.all_strongly_connected_components();
u = hist(s);
% 179 cycled triplets in unprepared graph

Gmd = ClipSimGraphMD(comparison, comparison_ids)
[Gsmd, smd, id] = Gmd.all_strongly_connected_components();
Gsmd(1).order;
% Not a single triple cycle found

% ---
% analysis on compliance with stobers preprocessing
% trying to find out the differing ? Graph structures
% for that sake analysis with connected (no cycles) components
% ---
Graw = ClipSimGraph(comparison, comparison_ids);
[Gsraw, sraw] = connected_components(Graw)
hist(sraw)
% in the unedited graph, there are 346 connected triplets

Gm = ClipSimGraphMulti(comparison, comparison_ids);
[Gsraw2, sraw2] = connected_components(Gm)
u = hist(sraw2)
% in this unedited graph, there are still 346 connected triplets

Gm.remove_cycles_length2;
[Gs, s, id] = connected_components(DiGraph(Gm));
u = hist(s)
% 27 single nodes, 337 three-node graphs. why not two-nodes

% which clips do these belong to?
soloid = find(s == 1);
soloclips = [];
for i = 1:numel(soloid)
    tmpG = ClipSimGraph(Gs(soloid(i)));
    
    % get the clisp of the single node
    [sm, bg] = tmpG.clipsN(tmpG.nodes);
    soloclips = [soloclips sm bg];
end
soloclips = unique(soloclips)
% exactly 27 clips lost
    
% now with our graph processing
Gmd = ClipSimGraphMD(comparison, comparison_ids)
[Gsmd, smd] = connected_components(Gmd)
% same result,

% ---
% now which are the orphaned nodes ?
% ---
Go = Gm.unconnected_subgraph();
Go.label(Go.nodes)

% ---
% how many clips are completely lost?
% ---
Go = ClipSimGraphMulti(Gm.unconnected_subgraph());
Go.clips
numel(ans)
Gm.remove_graph(Go) % 
lastClip = intersect(Go.clips,Gm.clips)

% ---
% ok lets chase the last clip
% ---
Gm.node(21950)
Gs = Gm.connected_components(283);
Gs.visualise
DiGraph(Go).visualise


% ---
% validation with comparison data
% ---
Gm = ClipSimGraphMulti(comparison, comparison_ids);
num_compares = sparse(numel(comparison_ids), numel(comparison_ids));
for i = 1:size(comparison,1)
abc = sort(comparison(i,1:3));
a = abc(1);
b = abc(2);
c = abc(3);
num_compares(a,b) = num_compares(a,b) +1;
num_compares(b,c) = num_compares(b,c) +1;
num_compares(a,c) = num_compares(a,c) +1;
end

[i,j] = ind2sub(find(num_compares > 2))
[i,j] = ind2sub(size(num_compares), find(num_compares > 2))
[i,j] = ind2sub(size(num_compares), find(num_compares > 1)),
i(1)
j(1)
find(comparison(:,1) == i(1) || comparison(:,2) == i(1) || comparison(:,3) == i(1)...)
&& comparison(:,1) == j(1) || comparison(:,2) == j(1) || comparison(:,3) == j(1))
find((comparison(:,1) == i(1) | comparison(:,2) == i(1) | comparison(:,3) == i(1))...)
& (comparison(:,1) == j(1) | comparison(:,2) == j(1) | comparison(:,3) == j(1)))

num = 2;
a = find((comparison(:,1) == i(num) | comparison(:,2) == i(num) | comparison(:,3) == i(num))...)
& (comparison(:,1) == j(num) | comparison(:,2) == j(num) | comparison(:,3) == j(num)))
comparison(a,:)
[i,j] = ind2sub(size(num_compares), find(num_compares > 1))
num = 3;
a = find((comparison(:,1) == i(num) | comparison(:,2) == i(num) | comparison(:,3) == i(num))...)
& (comparison(:,1) == j(num) | comparison(:,2) == j(num) | comparison(:,3) == j(num)))
comparison(a,:)
[i,j] = ind2sub(size(num_compares), find(num_compares > 1))
num = 18;
a = find((comparison(:,1) == i(num) | comparison(:,2) == i(num) | comparison(:,3) == i(num))...)
& (comparison(:,1) == j(num) | comparison(:,2) == j(num) | comparison(:,3) == j(num)))
comparison(a,:)
[i,j] = ind2sub(size(num_compares), find(num_compares > 1))
num = 300;
a = find((comparison(:,1) == i(num) | comparison(:,2) == i(num) | comparison(:,3) == i(num))...)
& (comparison(:,1) == j(num) | comparison(:,2) == j(num) | comparison(:,3) == j(num)))
comparison(a,:)

% ---
% other simulated data
% ---
ClipSimGraph([1 2 3 5 1 0;], 1:100).visualise
ClipSimGraph([1 2 3 5 1 0; 1 2 4 6 0 0], 1:100).visualise
ClipSimGraph([1 2 3 5 1 0; 1 2 4 6 0 0], 1:100).max_degree
G = ClipSimGraph(comparison, comparison_ids);

% --- 
% scc algorithm tests
% ---
V = ones(1,5)
E = zeros(5)
for i=1:4
E(i+1,i) = 1
end
E(1,4) = 1
gtest = DiGRaph(V,E)

gtest.strongly_connected_components(4)
gtest.strongly_connected_components(5)

