function out = tag_stats(annots, names, max_plot)
% out = tag_stats(annots, names, max_plot)
% 
% calculates statistics for tag distributions
% and plots them

if nargin < 3
  max_plot = 25;  
end

% get overall frequency and sort accordingly
allapp = sum(annots > 0, 1);
% allapp = allapp/max(allapp);

[null, idx] = sort(allapp,'descend');

% ---
% visualize only the fist top 200
% ---
max_plot = min(numel(names), max_plot);

figure;
bar(1:max_plot,allapp(idx(1:max_plot)))
set(gca,'XTick',1:max_plot);
set(gca,'XTickLabel',names(idx(1:max_plot)));
axis([1 max_plot 0 max(allapp)])

legend('#appearances');
title 'tag statistics sorted by frequency of appearances'

out = [];